/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class ZeissXRMReader
extends FormatReader {
    private static final String DATESTAMP = "mm/dd/yyyy HH:mm:ss.SSS";
    private static final String IMAGE_INFO_PATH = "Root Entry/ImageInfo/";
    private static final String RECON_SETTINGS_PATH = "Root Entry/ReconSettings/";
    private static final String AUTORECON_PATH = "Root Entry/AutoRecon/";
    private static final String REFERENCE_PATH = "Root Entry/ReferenceData/";
    private static final String POSITIONS = "Positions: ";
    private static final String DATASET = "Dataset Info: ";
    private static final String RECON_SETTINGS = "Reconstruction Settings: ";
    private static final String IMAGE_DETAILS = "Image Details: ";
    private static final String SOURCE_ASSEMBLY = "Source Assembly Info: ";
    private static final String GENERAL_PARAMS = "General Parameters: ";
    private static final String PROJECTION = "Projection Info: ";
    private transient POIService poi;
    private List<String> imagePaths = new ArrayList<String>();
    private transient Double pixelSize = null;
    private transient double[] exposureTimes = null;
    private transient double[] current = null;
    private transient double[] voltage = null;
    private transient double[] xPos = null;
    private transient double[] yPos = null;
    private transient double[] zPos = null;
    private transient String[] datestamps = null;

    public ZeissXRMReader() {
        super("Zeiss XRM", new String[]{"txm", "txrm"});
        this.domains = new String[]{"Unknown"};
        this.suffixSufficient = true;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)4, (boolean)false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.poi == null) {
            this.initPOIService();
        }
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        try (RandomAccessInputStream stream = this.poi.getDocumentStream(this.imagePaths.get(no));){
            int skipBeginRow = x * bpp;
            int skipEndRow = bpp * (this.getSizeX() - w - x);
            int rowLen = w * bpp;
            for (int row = h - 1; row >= 0; --row) {
                stream.skipBytes(skipBeginRow);
                stream.read(buf, row * rowLen, rowLen);
                stream.skipBytes(skipEndRow);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.imagePaths.clear();
            this.pixelSize = null;
            this.exposureTimes = null;
            this.current = null;
            this.voltage = null;
            this.xPos = null;
            this.yPos = null;
            this.zPos = null;
            this.datestamps = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        String suffix = this.getCurrentFile().substring(this.getCurrentFile().lastIndexOf(".") + 1);
        boolean isTXM = suffix.equalsIgnoreCase("txm");
        boolean isTXRM = suffix.equalsIgnoreCase("txrm");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        this.initPOIService();
        Vector<String> allFiles = this.poi.getDocumentList();
        allFiles.sort(null);
        if (allFiles.isEmpty()) {
            throw new FormatException("No files were found - the file may be corrupt.");
        }
        for (String originalFile : allFiles) {
            String name = originalFile.replaceAll("\\\\", "/");
            if (name.startsWith("Root Entry/ImageData")) {
                int index = Integer.parseInt(name.substring(name.lastIndexOf("Image") + 5)) - 1;
                while (index >= this.imagePaths.size()) {
                    this.imagePaths.add(null);
                }
                this.imagePaths.set(index, originalFile);
                continue;
            }
            RandomAccessInputStream stream = this.poi.getDocumentStream(originalFile);
            try {
                String paramsPrefix;
                stream.order(true);
                if (isTXM) {
                    this.handleTXMMetadata(name, stream);
                } else if (isTXRM) {
                    this.handleTXRMMetadata(name, stream);
                }
                String string = paramsPrefix = isTXM ? GENERAL_PARAMS : PROJECTION;
                if (name.equals("Root Entry/ImageInfo/ImageWidth")) {
                    m.sizeX = stream.readInt();
                    this.addGlobalMeta("Image Details: Image width (pixels)", m.sizeX);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/ImageHeight")) {
                    m.sizeY = stream.readInt();
                    this.addGlobalMeta("Image Details: Image height (pixels)", m.sizeY);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/DataType")) {
                    int type = stream.readInt();
                    m.pixelType = this.getPixelType(type);
                    if (isTXM) {
                        this.addGlobalMeta("Reconstruction Settings: Output data type", this.getMetadataPixelType(type));
                    }
                    this.addGlobalMeta("Image Details: Data type", this.getMetadataPixelType(type));
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/FileType")) {
                    this.addGlobalMeta("Image Details: File type", stream.readString(4));
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/PixelSize")) {
                    this.pixelSize = stream.readFloat();
                    this.addGlobalMeta("Image Details: Pixel size (\u00b5m)", this.formatDouble(this.pixelSize));
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/AcquisitionMode")) {
                    int mode = stream.readInt();
                    String modeValue = String.valueOf(mode);
                    if (mode == 0) {
                        modeValue = "Tomography";
                    } else if (mode == 10) {
                        modeValue = "Recon";
                    } else {
                        LOGGER.warn("Could not identify acquisition mode: {}", (Object)mode);
                    }
                    this.addGlobalMeta("Image Details: Acquisition mode", modeValue);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/Current") && this.current == null) {
                    this.current = this.readAsDoubles(stream);
                    this.addGlobalMeta("Source Assembly Info: Current (\u00b5A)", this.current[0]);
                    if (!isTXM) continue;
                    this.addGlobalMeta("General Parameters: X-ray current (\u00b5A)", this.current[0]);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/XrayVoltage") && this.voltage == null) {
                    this.voltage = this.readAsDoubles(stream);
                    this.addMetadataList(this.voltage, paramsPrefix + "X-ray voltage (kV)", !isTXM);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/SourceFilterName")) {
                    String sourceFilter = this.readAsString(stream);
                    this.addGlobalMeta("Source Assembly Info: Source Filter Name", sourceFilter);
                    this.addGlobalMeta(paramsPrefix + "Source filter name", sourceFilter);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/Voltage")) {
                    this.addGlobalMeta("Source Assembly Info: Voltage (kV)", stream.readFloat());
                    continue;
                }
                if (name.equals("Root Entry/exeVersion")) {
                    this.addGlobalMeta("Dataset Info: Executable version", this.readAsString(stream));
                    continue;
                }
                if (name.equals("Root Entry/DetAssemblyInfo/LensInfo/LensName")) {
                    String objective = this.readAsString(stream);
                    this.addGlobalMeta(paramsPrefix + "Objective name", objective);
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/CameraNumberOfFramesPerImage")) {
                    this.addGlobalMeta(paramsPrefix + "Frames per image", stream.readInt());
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/NoOfImagesAveraged")) {
                    this.addGlobalMeta(paramsPrefix + "Images per projection", stream.readInt());
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/ExpTimes")) {
                    this.exposureTimes = this.readAsDoubles(stream);
                    if (this.exposureTimes.length <= 1) continue;
                    this.addGlobalMeta(paramsPrefix + "Exposure time (s)", this.formatDouble(this.exposureTimes[0]));
                    continue;
                }
                if (name.equals("Root Entry/ImageInfo/CameraBinning")) {
                    this.addGlobalMeta(paramsPrefix + "Camera binning", stream.readInt());
                    continue;
                }
                if (stream.getFilePointer() != 0L) continue;
                LOGGER.trace("Skipped '{}' ({}) bytes", (Object)name, (Object)stream.length());
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        m.sizeZ = this.imagePaths.size();
        m.sizeT = 1;
        m.sizeC = 1;
        m.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        m.dimensionOrder = "XYZTC";
        m.littleEndian = true;
        m.moduloZ.type = "Rotation";
        m.moduloZ.step = 1.0;
        m.moduloZ.start = 0.0;
        m.moduloZ.end = m.sizeZ - 1;
        this.addGlobalMeta("Dataset Info: Data file name", new Location(this.getCurrentFile()).getAbsolutePath());
        if (isTXM) {
            this.addGlobalMeta("Reconstruction Settings: Output file-format", suffix);
            if (this.current != null && this.voltage != null) {
                this.addGlobalMeta("General Parameters: X-ray power (W)", this.current[0] * this.voltage[0] / 1000.0);
            }
        } else if (isTXRM && this.current != null && this.voltage != null) {
            for (int i = 0; i < Math.min(this.current.length, this.voltage.length); ++i) {
                double calcPower = this.current[i] * this.voltage[i] / 1000.0;
                this.addGlobalMetaList("Projection Info: X-ray power (W)", this.formatDouble(calcPower));
            }
        }
        this.addGlobalMeta("Image Details: File type", suffix);
        if (this.pixelSize != null) {
            double fovX = (double)m.sizeX * this.pixelSize;
            double fovY = (double)m.sizeY * this.pixelSize;
            this.addGlobalMeta("Image Details: Field of view (\u00b5m)", this.formatDouble(fovX) + ", " + this.formatDouble(fovY));
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        if (this.pixelSize != null) {
            Length physicalSize = FormatTools.getPhysicalSize((Double)this.pixelSize, (String)"\u00b5m");
            store.setPixelsPhysicalSizeX(physicalSize, 0);
            store.setPixelsPhysicalSizeY(physicalSize, 0);
            store.setPixelsPhysicalSizeZ(physicalSize, 0);
        }
        double firstTimestamp = 0.0;
        for (int p = 0; p < this.getImageCount(); ++p) {
            if (this.exposureTimes != null && p < this.exposureTimes.length) {
                store.setPlaneExposureTime(new Time((Number)this.exposureTimes[p], UNITS.SECOND), 0, p);
            }
            if (this.xPos != null && p < this.xPos.length) {
                store.setPlanePositionX(new Length((Number)this.xPos[p], UNITS.MICROMETER), 0, p);
            }
            if (this.yPos != null && p < this.yPos.length) {
                store.setPlanePositionY(new Length((Number)this.yPos[p], UNITS.MICROMETER), 0, p);
            }
            if (this.zPos != null && p < this.zPos.length) {
                store.setPlanePositionZ(new Length((Number)this.zPos[p], UNITS.MICROMETER), 0, p);
            }
            if (this.datestamps == null) continue;
            if (p == 0) {
                firstTimestamp = DateTools.getTime(this.datestamps[0], DATESTAMP);
                store.setImageAcquisitionDate(new Timestamp(DateTools.formatDate(this.datestamps[0], DATESTAMP)), 0);
            }
            double delta = (double)DateTools.getTime(this.datestamps[p], DATESTAMP) - firstTimestamp;
            store.setPlaneDeltaT(new Time((Number)delta, UNITS.MILLISECOND), 0, p);
        }
    }

    private void handleTXMMetadata(String name, RandomAccessInputStream stream) throws IOException {
        if (name.equals("Root Entry/AutoRecon/MeanSampleX")) {
            this.addGlobalMeta("Positions: Mean sample X (\u00b5m)", this.formatDouble(stream.readFloat()));
        } else if (name.equals("Root Entry/AutoRecon/MeanSampleY")) {
            this.addGlobalMeta("Positions: Mean sample Y (\u00b5m)", this.formatDouble(stream.readFloat()));
        } else if (name.equals("Root Entry/AutoRecon/MeanSampleZ")) {
            this.addGlobalMeta("Positions: Mean sample Z (\u00b5m)", this.formatDouble(stream.readFloat()));
        } else if (name.equals("Root Entry/ReconSettings/SourceVoltage")) {
            this.voltage = this.readAsDoubles(stream);
            this.addGlobalMeta("General Parameters: X-ray voltage (kV)", this.voltage[0]);
        } else if (name.equals("Root Entry/ReconSettings/OutputFileLocation")) {
            this.addGlobalMeta("Reconstruction Settings: Output file location", this.readAsString(stream));
        } else if (name.equals("Root Entry/ReconSettings/InputFileName")) {
            this.addGlobalMeta("Reconstruction Settings: Input filename", this.readAsString(stream));
        } else if (name.equals("Root Entry/ReconSettings/CenterShift")) {
            this.addGlobalMeta("Reconstruction Settings: Center shift", stream.readFloat());
        } else if (name.equals("Root Entry/ReconSettings/BeamHardeningFileName")) {
            this.addGlobalMeta("Reconstruction Settings: Beam hardening", this.readAsString(stream));
        } else if (name.equals("Root Entry/ReconSettings/BeamHardening")) {
            this.addGlobalMeta("Reconstruction Settings: Beam-hardening constant", stream.readFloat());
        } else if (name.equals("Root Entry/ReconSettings/RotationAngle")) {
            this.addGlobalMeta("Reconstruction Settings: Rotation angle", stream.readFloat());
        } else if (name.equals("Root Entry/ReconSettings/ReconFilterChoice")) {
            int filter = stream.readInt();
            String filterName = String.valueOf(filter);
            if (filter == 2) {
                filterName = "Smooth";
            } else {
                LOGGER.warn("Could not identify reconstruction filter type: {}", (Object)filter);
            }
            this.addGlobalMeta("Reconstruction Settings: Recon filter", filterName);
        } else if (name.equals("Root Entry/ReconSettings/ReconFilterSmoothFactor")) {
            this.addGlobalMeta("Reconstruction Settings: Sigma", stream.readFloat());
        } else if (name.equals("Root Entry/ReconSettings/ReconScalingEnum")) {
            int scaling = stream.readInt();
            String scalingType = String.valueOf(scaling);
            if (scaling == 0) {
                scalingType = "Global";
            } else {
                LOGGER.warn("Could not identify reconstruction scaling: {}", (Object)scaling);
            }
            this.addGlobalMeta("Reconstruction Settings: Recon scaling", scalingType);
        } else if (name.equals("Root Entry/ReconSettings/GlobalMax")) {
            this.addGlobalMeta("Reconstruction Settings: Global max", stream.readFloat());
        } else if (name.equals("Root Entry/ReconSettings/GlobalMin")) {
            this.addGlobalMeta("Reconstruction Settings: Global min", stream.readFloat());
        } else if (name.equals("Root Entry/ReconSettings/UserMinMax")) {
            this.addGlobalMeta("Reconstruction Settings: User min-max", this.getYesNo(stream));
        } else if (name.equals("Root Entry/ReconSettings/UseCTScaleFilter")) {
            this.addGlobalMeta("Reconstruction Settings: Use CT-Scaling", this.getYesNo(stream));
        } else if (name.equals("Root Entry/ReconSettings/CTScaleFilter")) {
            this.addGlobalMeta("Reconstruction Settings: CT-scale name", this.readAsString(stream));
        } else if (name.equals("Root Entry/ReconSettings/SecondaryReferenceFileName")) {
            this.addGlobalMeta("Reconstruction Settings: Secondary ref. filename", this.readAsString(stream));
        } else if (name.equals("Root Entry/ReconSettings/SecRefSourceFilterName")) {
            this.addGlobalMeta("Reconstruction Settings: Secondary ref. filter name", this.readAsString(stream));
        } else if (name.equals("Root Entry/ReconSettings/SecondaryRefCollectionMode")) {
            int v = stream.readInt();
            String mode = v == 0 ? "None" : String.valueOf(v);
            this.addGlobalMeta("Reconstruction Settings: Secondary ref. collection", mode);
        } else if (name.equals("Root Entry/ReconSettings/ReconOperation")) {
            this.addGlobalMeta("Reconstruction Settings: Output down-sampling", stream.readInt());
        } else if (name.equals("Root Entry/AutoRecon/StoRADistance")) {
            float sRADistance = stream.readFloat() / -1000.0f;
            this.addGlobalMeta("Positions: Source to RA (mm)", this.formatDouble(sRADistance));
            this.addGlobalMeta("General Parameters: Source-RA (mm)", this.formatDouble(sRADistance));
        } else if (name.equals("Root Entry/AutoRecon/DtoRADistance")) {
            float dRADistance = stream.readFloat() / 1000.0f;
            this.addGlobalMeta("Positions: Detector to RA (mm)", this.formatDouble(dRADistance));
            this.addGlobalMeta("General Parameters: Detector-RA (mm)", this.formatDouble(dRADistance));
        } else if (name.equals("Root Entry/AutoRecon/NumOfProjects")) {
            this.addGlobalMeta("General Parameters: Number of projections used", stream.readInt());
        } else if (name.equals("Root Entry/ReconSettings/ReconServiceVersion")) {
            this.addGlobalMeta("Dataset Info: Recon Service Version", this.readAsString(stream));
        }
    }

    private void handleTXRMMetadata(String name, RandomAccessInputStream stream) throws IOException {
        if (name.equals("Root Entry/ReferenceData/ImageInfo/XrayMagnification")) {
            this.addGlobalMeta("Projection Info: Geometric Magnification", this.formatDouble(stream.readFloat()));
        } else if (name.equals("Root Entry/Selection/SelectedImages")) {
            this.addGlobalMeta("Projection Info: Selected", this.getYesNo(stream));
        } else if (name.equals("Root Entry/ImageInfo/XrayCurrent")) {
            this.current = this.readAsDoubles(stream);
            this.addMetadataList(this.current, "Projection Info: X-ray current (\u00b5A)", true);
        } else if (name.equals("Root Entry/ImageInfo/XPosition")) {
            this.xPos = this.readAsDoubles(stream);
        } else if (name.equals("Root Entry/ImageInfo/YPosition")) {
            this.yPos = this.readAsDoubles(stream);
        } else if (name.equals("Root Entry/ImageInfo/ZPosition")) {
            this.zPos = this.readAsDoubles(stream);
        } else if (name.equals("Root Entry/ImageInfo/DtoRADistance")) {
            this.addGlobalMeta("Projection Info: Detector-RA (mm)", this.formatDouble(stream.readFloat()));
        } else if (name.equals("Root Entry/ImageInfo/StoRADistance")) {
            this.addGlobalMeta("Projection Info: Source-RA (mm)", this.formatDouble(stream.readFloat()));
        } else if (name.equals("Root Entry/ImageInfo/FanAngle")) {
            double[] fanAngle = this.readAsDoubles(stream);
            this.addMetadataList(fanAngle, "Projection Info: Fan angle", true);
        } else if (name.equals("Root Entry/ImageInfo/ConeAngle")) {
            double[] coneAngle = this.readAsDoubles(stream);
            this.addMetadataList(coneAngle, "Projection Info: Cone angle", true);
        } else if (name.equals("Root Entry/ImageInfo/Angles")) {
            double[] angles = this.readAsDoubles(stream);
            this.addMetadataList(angles, "Projection Info: Angle", true);
        } else if (name.equals("Root Entry/ImageInfo/ReadOutTime")) {
            this.addGlobalMeta("Projection Info: Camera Readout Speed", stream.readInt());
        } else if (name.equals("Root Entry/ImageInfo/Temperature")) {
            this.addGlobalMeta("Projection Info: Camera Temperature", stream.readInt());
        } else if (name.equals("Root Entry/ImageInfo/Date")) {
            this.datestamps = new String[(int)(stream.length() / 40L)];
            for (int i = 0; i < this.datestamps.length; ++i) {
                this.datestamps[i] = stream.readString(DATESTAMP.length());
                stream.skipBytes(40 - DATESTAMP.length());
                this.addGlobalMetaList("Projection Info: Date", this.datestamps[i]);
            }
        }
    }

    private void initPOIService() throws FormatException, IOException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", (Throwable)de);
        }
        this.poi.initialize(Location.getMappedId(this.getCurrentFile()));
    }

    private int getPixelType(int dataType) throws FormatException {
        switch (dataType) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 7;
            }
        }
        throw new FormatException("Unsupported data type: " + dataType);
    }

    private String getMetadataPixelType(int dataType) throws FormatException {
        switch (dataType) {
            case 2: {
                return "byte";
            }
            case 3: {
                return "ubyte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "ushort";
            }
            case 6: {
                return "int";
            }
            case 7: {
                return "uint";
            }
            case 10: {
                return "float";
            }
            case 11: {
                return "double";
            }
        }
        throw new FormatException("Unsupported data type: " + dataType);
    }

    private String readAsString(RandomAccessInputStream stream) throws IOException {
        long len = stream.length();
        if (len > Integer.MAX_VALUE) {
            throw new IOException("Length too large to read as string: " + len);
        }
        String value = stream.readString((int)len);
        return value.trim();
    }

    private String getYesNo(RandomAccessInputStream stream) throws IOException {
        int v = stream.read();
        return v == 0 ? "No" : "Yes";
    }

    private double[] readAsDoubles(RandomAccessInputStream stream) throws IOException {
        double[] v = new double[(int)(stream.length() / 4L)];
        for (int i = 0; i < v.length; ++i) {
            v[i] = stream.readFloat();
        }
        return v;
    }

    private void addMetadataList(double[] v, String key) {
        this.addMetadataList(v, key, false);
    }

    private void addMetadataList(double[] v, String key, boolean formatDoubles) {
        boolean singleValue = true;
        for (double d : v) {
            if (!(Math.abs(d - v[0]) > 1.0E-6)) continue;
            singleValue = false;
            break;
        }
        if (singleValue) {
            this.addGlobalMeta(key, formatDoubles ? this.formatDouble(v[0]) : Double.valueOf(v[0]));
        } else {
            for (double d : v) {
                this.addGlobalMetaList(key, formatDoubles ? this.formatDouble(d) : Double.valueOf(d));
            }
        }
    }

    private String formatDouble(double v) {
        return String.format("%.02f", v);
    }
}

