/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Dichroic;
import ome.model.acquisition.Filter;
import ome.model.acquisition.LightPathEmissionFilterLink;
import ome.model.acquisition.LightPathExcitationFilterLink;
import ome.model.annotations.Annotation;
import ome.model.annotations.LightPathAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="lightpath_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="lightpath_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="lightpath_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="lightpath_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="lightpath_owner_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="lightpath_group_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="lightpath_event_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="lightpath_perms_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="lightpath_owner_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="lightpath_group_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="lightpath_event_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="lightpath_perms_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="lightpath_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="lightpath_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="lightpath_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="lightpath_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="lightpath_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="lightpath_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="lightpath_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="lightpath_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT logicalchannel.lightpath FROM logicalchannel*, channel*, pixels* WHERE logicalchannel.id = channel.logicalchannel AND channel.pixels = pixels.id AND pixels.image IN (:images)))")})
@Entity
@Table(name="lightpath", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_lightpath", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_lightpath"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class LightPath
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "lightpath_owner_filter";
    public static final String GROUP_FILTER = "lightpath_group_filter";
    public static final String EVENT_FILTER = "lightpath_event_filter";
    public static final String PERMS_FILTER = "lightpath_perms_filter";
    public static final String ID = "ome.model.acquisition.LightPath_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.LightPath_version";
    protected Integer version = 0;
    protected List<LightPathExcitationFilterLink> excitationFilterLink = new ArrayList<LightPathExcitationFilterLink>();
    public static final String OWNER_FILTER_EXCITATIONFILTERLINK = "lightpath_owner_filter_EXCITATIONFILTERLINK";
    public static final String GROUP_FILTER_EXCITATIONFILTERLINK = "lightpath_group_filter_EXCITATIONFILTERLINK";
    public static final String EVENT_FILTER_EXCITATIONFILTERLINK = "lightpath_event_filter_EXCITATIONFILTERLINK";
    public static final String PERMS_FILTER_EXCITATIONFILTERLINK = "lightpath_perms_filter_EXCITATIONFILTERLINK";
    private Map<Long, Long> excitationFilterLinkCountPerOwner = null;
    protected Dichroic dichroic = null;
    protected Set<LightPathEmissionFilterLink> emissionFilterLink = new HashSet<LightPathEmissionFilterLink>();
    public static final String OWNER_FILTER_EMISSIONFILTERLINK = "lightpath_owner_filter_EMISSIONFILTERLINK";
    public static final String GROUP_FILTER_EMISSIONFILTERLINK = "lightpath_group_filter_EMISSIONFILTERLINK";
    public static final String EVENT_FILTER_EMISSIONFILTERLINK = "lightpath_event_filter_EMISSIONFILTERLINK";
    public static final String PERMS_FILTER_EMISSIONFILTERLINK = "lightpath_perms_filter_EMISSIONFILTERLINK";
    private Map<Long, Long> emissionFilterLinkCountPerOwner = null;
    protected Set<LightPathAnnotationLink> annotationLinks = new HashSet<LightPathAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "lightpath_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "lightpath_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "lightpath_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "lightpath_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String EXCITATIONFILTERLINKCOUNTPEROWNER = "ome.model.acquisition.LightPath_excitationFilterLinkCountPerOwner";
    public static final String EXCITATIONFILTERLINK = "ome.model.acquisition.LightPath_excitationFilterLink";
    public static final String DICHROIC = "ome.model.acquisition.LightPath_dichroic";
    public static final String EMISSIONFILTERLINKCOUNTPEROWNER = "ome.model.acquisition.LightPath_emissionFilterLinkCountPerOwner";
    public static final String EMISSIONFILTERLINK = "ome.model.acquisition.LightPath_emissionFilterLink";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.acquisition.LightPath_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.LightPath_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.LightPath_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public LightPath() {
        this(null, true);
    }

    protected LightPath(Long id) {
        this(id, true);
    }

    public LightPath(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_lightpath")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @JoinColumn(name="parent", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="parent_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT link.id FROM lightpathexcitationfilterlink AS link*, filter*, image* WHERE link.child = filter.id AND filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="lightpath_owner_filter_EXCITATIONFILTERLINK", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="lightpath_group_filter_EXCITATIONFILTERLINK", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="lightpath_event_filter_EXCITATIONFILTERLINK", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="lightpath_perms_filter_EXCITATIONFILTERLINK", condition=":permsStr = permissions")})
    protected List<LightPathExcitationFilterLink> getExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationFilterLink;
    }

    protected void setExcitationFilterLink(List<LightPathExcitationFilterLink> excitationFilterLink) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.excitationFilterLink = excitationFilterLink;
    }

    public int sizeOfExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationFilterLink == null ? -1 : this.excitationFilterLink.size();
    }

    public Iterator<LightPathExcitationFilterLink> iterateExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return new EmptyIterator<LightPathExcitationFilterLink>();
        }
        return this.getExcitationFilterLink().iterator();
    }

    public Collection<LightPathExcitationFilterLink> unmodifiableExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getExcitationFilterLink());
    }

    public <E> List<E> collectExcitationFilterLink(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LightPathExcitationFilterLink> it = this.iterateExcitationFilterLink();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLightPathExcitationFilterLink(LightPathExcitationFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().add(target);
        if (target != null && target.isLoaded()) {
            target.setParent(this);
        }
    }

    public void addLightPathExcitationFilterLinkSet(Collection<LightPathExcitationFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().addAll(targets);
        for (LightPathExcitationFilterLink target : targets) {
            if (target == null || !target.isLoaded()) continue;
            target.setParent(this);
        }
    }

    public void removeLightPathExcitationFilterLink(LightPathExcitationFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().remove(target);
        if (target.isLoaded()) {
            target.setParent(null);
        }
    }

    public void removeLightPathExcitationFilterLinkSet(Collection<LightPathExcitationFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().removeAll(targets);
        for (LightPathExcitationFilterLink target : targets) {
            if (!target.isLoaded()) continue;
            target.setParent(null);
        }
    }

    public LightPathExcitationFilterLink getLightPathExcitationFilterLink(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        return this.getExcitationFilterLink().get(index);
    }

    public LightPathExcitationFilterLink setLightPathExcitationFilterLink(int index, LightPathExcitationFilterLink element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        LightPathExcitationFilterLink old = this.getExcitationFilterLink().set(index, element);
        if (element != null && element.isLoaded()) {
            element.setParent(this);
        }
        return old;
    }

    @Transient
    public LightPathExcitationFilterLink getPrimaryLightPathExcitationFilterLink() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        return this.getExcitationFilterLink().get(0);
    }

    public LightPathExcitationFilterLink setPrimaryLightPathExcitationFilterLink(LightPathExcitationFilterLink element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        List<LightPathExcitationFilterLink> list = this.getExcitationFilterLink();
        int index = list.indexOf(element);
        LightPathExcitationFilterLink old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    public LightPathExcitationFilterLink linkExcitationFilter(Filter addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        LightPathExcitationFilterLink link = new LightPathExcitationFilterLink();
        link.link(this, addition);
        this.addLightPathExcitationFilterLink(link, true);
        return link;
    }

    public void addLightPathExcitationFilterLink(LightPathExcitationFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().add(link);
    }

    public Iterator<Filter> linkedExcitationFilterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return new EmptyIterator<Filter>();
        }
        final Iterator<LightPathExcitationFilterLink> it = this.getExcitationFilterLink().iterator();
        return new Iterator<Filter>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Filter next() {
                if (it == null) {
                    throw new NoSuchElementException("excitationFilterLink is null; no elements.");
                }
                LightPathExcitationFilterLink link = (LightPathExcitationFilterLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<LightPathExcitationFilterLink> findLightPathExcitationFilterLink(Filter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<LightPathExcitationFilterLink> it = this.iterateExcitationFilterLink();
        HashSet<LightPathExcitationFilterLink> result = new HashSet<LightPathExcitationFilterLink>();
        while (it.hasNext()) {
            LightPathExcitationFilterLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Filter> linkedExcitationFilterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Filter> it = this.linkedExcitationFilterIterator();
        ArrayList<Filter> list = new ArrayList<Filter>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedExcitationFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Filter> it = this.linkedExcitationFilterIterator();
        while (it.hasNext()) {
            Filter obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkExcitationFilter(Filter removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<LightPathExcitationFilterLink> toRemove = this.findLightPathExcitationFilterLink(removal);
        Iterator<LightPathExcitationFilterLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeLightPathExcitationFilterLink(it.next(), true);
        }
    }

    public void removeLightPathExcitationFilterLink(LightPathExcitationFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().remove(link);
    }

    public void clearExcitationFilterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<LightPathExcitationFilterLink> list = new ArrayList<LightPathExcitationFilterLink>(this.getExcitationFilterLink());
        for (LightPathExcitationFilterLink link : list) {
            this.removeLightPathExcitationFilterLink(link, true);
        }
    }

    protected void setExcitationFilterLinkCountPerOwner(Map<Long, Long> map) {
        this.excitationFilterLinkCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_LightPath_excitationFilterLink")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_LightPath_excitationFilterLink_by_owner", joinColumns={@JoinColumn(name="LightPath_id")})
    public Map<Long, Long> getExcitationFilterLinkCountPerOwner() {
        return this.excitationFilterLinkCountPerOwner;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Dichroic.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="dichroic", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlightpath_dichroic_dichroic")
    public Dichroic getDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.dichroic;
    }

    public void setDichroic(Dichroic dichroic) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.dichroic = dichroic;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT link.id FROM lightpathemissionfilterlink AS link*, filter*, image* WHERE link.child = filter.id AND filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="lightpath_owner_filter_EMISSIONFILTERLINK", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="lightpath_group_filter_EMISSIONFILTERLINK", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="lightpath_event_filter_EMISSIONFILTERLINK", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="lightpath_perms_filter_EMISSIONFILTERLINK", condition=":permsStr = permissions")})
    protected Set<LightPathEmissionFilterLink> getEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionFilterLink;
    }

    protected void setEmissionFilterLink(Set<LightPathEmissionFilterLink> emissionFilterLink) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.emissionFilterLink = emissionFilterLink;
    }

    public int sizeOfEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionFilterLink == null ? -1 : this.emissionFilterLink.size();
    }

    public Iterator<LightPathEmissionFilterLink> iterateEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return new EmptyIterator<LightPathEmissionFilterLink>();
        }
        return this.getEmissionFilterLink().iterator();
    }

    public Collection<LightPathEmissionFilterLink> unmodifiableEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getEmissionFilterLink());
    }

    public <E> List<E> collectEmissionFilterLink(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LightPathEmissionFilterLink> it = this.iterateEmissionFilterLink();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLightPathEmissionFilterLink(LightPathEmissionFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addLightPathEmissionFilterLinkSet(Collection<LightPathEmissionFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().addAll(targets);
        for (LightPathEmissionFilterLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeLightPathEmissionFilterLink(LightPathEmissionFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().remove(target);
        target.setParent(null);
    }

    public void removeLightPathEmissionFilterLinkSet(Collection<LightPathEmissionFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().removeAll(targets);
        for (LightPathEmissionFilterLink target : targets) {
            target.setParent(null);
        }
    }

    public LightPathEmissionFilterLink linkEmissionFilter(Filter addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        LightPathEmissionFilterLink link = new LightPathEmissionFilterLink();
        link.link(this, addition);
        this.addLightPathEmissionFilterLink(link, true);
        return link;
    }

    public void addLightPathEmissionFilterLink(LightPathEmissionFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().add(link);
    }

    public Iterator<Filter> linkedEmissionFilterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return new EmptyIterator<Filter>();
        }
        final Iterator<LightPathEmissionFilterLink> it = this.getEmissionFilterLink().iterator();
        return new Iterator<Filter>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Filter next() {
                if (it == null) {
                    throw new NoSuchElementException("emissionFilterLink is null; no elements.");
                }
                LightPathEmissionFilterLink link = (LightPathEmissionFilterLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<LightPathEmissionFilterLink> findLightPathEmissionFilterLink(Filter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<LightPathEmissionFilterLink> it = this.iterateEmissionFilterLink();
        HashSet<LightPathEmissionFilterLink> result = new HashSet<LightPathEmissionFilterLink>();
        while (it.hasNext()) {
            LightPathEmissionFilterLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Filter> linkedEmissionFilterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Filter> it = this.linkedEmissionFilterIterator();
        ArrayList<Filter> list = new ArrayList<Filter>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedEmissionFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Filter> it = this.linkedEmissionFilterIterator();
        while (it.hasNext()) {
            Filter obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkEmissionFilter(Filter removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<LightPathEmissionFilterLink> toRemove = this.findLightPathEmissionFilterLink(removal);
        Iterator<LightPathEmissionFilterLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeLightPathEmissionFilterLink(it.next(), true);
        }
    }

    public void removeLightPathEmissionFilterLink(LightPathEmissionFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().remove(link);
    }

    public void clearEmissionFilterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<LightPathEmissionFilterLink> list = new ArrayList<LightPathEmissionFilterLink>(this.getEmissionFilterLink());
        for (LightPathEmissionFilterLink link : list) {
            this.removeLightPathEmissionFilterLink(link, true);
        }
    }

    protected void setEmissionFilterLinkCountPerOwner(Map<Long, Long> map) {
        this.emissionFilterLinkCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_LightPath_emissionFilterLink")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_LightPath_emissionFilterLink_by_owner", joinColumns={@JoinColumn(name="LightPath_id")})
    public Map<Long, Long> getEmissionFilterLinkCountPerOwner() {
        return this.emissionFilterLinkCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="lightpath_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="lightpath_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="lightpath_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="lightpath_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<LightPathAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<LightPathAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<LightPathAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<LightPathAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<LightPathAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LightPathAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLightPathAnnotationLink(LightPathAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addLightPathAnnotationLinkSet(Collection<LightPathAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (LightPathAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeLightPathAnnotationLink(LightPathAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeLightPathAnnotationLinkSet(Collection<LightPathAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (LightPathAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public LightPathAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        LightPathAnnotationLink link = new LightPathAnnotationLink();
        link.link(this, addition);
        this.addLightPathAnnotationLink(link, true);
        return link;
    }

    public void addLightPathAnnotationLink(LightPathAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<LightPathAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                LightPathAnnotationLink link = (LightPathAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<LightPathAnnotationLink> findLightPathAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<LightPathAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<LightPathAnnotationLink> result = new HashSet<LightPathAnnotationLink>();
        while (it.hasNext()) {
            LightPathAnnotationLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<LightPathAnnotationLink> toRemove = this.findLightPathAnnotationLink(removal);
        Iterator<LightPathAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeLightPathAnnotationLink(it.next(), true);
        }
    }

    public void removeLightPathAnnotationLink(LightPathAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<LightPathAnnotationLink> list = new ArrayList<LightPathAnnotationLink>(this.getAnnotationLinks());
        for (LightPathAnnotationLink link : list) {
            this.removeLightPathAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_LightPath_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_LightPath_annotationLinks_by_owner", joinColumns={@JoinColumn(name="LightPath_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public LightPath newInstance() {
        return new LightPath();
    }

    public LightPath proxy() {
        return new LightPath(this.id, false);
    }

    @Override
    public boolean acceptFilter(ome.util.Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.excitationFilterLinkCountPerOwner = __filter.filter(EXCITATIONFILTERLINKCOUNTPEROWNER, this.excitationFilterLinkCountPerOwner);
            this.excitationFilterLink = (List)__filter.filter(EXCITATIONFILTERLINK, this.excitationFilterLink);
            this.dichroic = (Dichroic)__filter.filter(DICHROIC, this.dichroic);
            this.emissionFilterLinkCountPerOwner = __filter.filter(EMISSIONFILTERLINKCOUNTPEROWNER, this.emissionFilterLinkCountPerOwner);
            this.emissionFilterLink = (Set)__filter.filter(EMISSIONFILTERLINK, this.emissionFilterLink);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(EXCITATIONFILTERLINKCOUNTPEROWNER)) {
            return this.getExcitationFilterLinkCountPerOwner();
        }
        if (field.equals(EXCITATIONFILTERLINK)) {
            return this.getExcitationFilterLink();
        }
        if (field.equals(DICHROIC)) {
            return this.getDichroic();
        }
        if (field.equals(EMISSIONFILTERLINKCOUNTPEROWNER)) {
            return this.getEmissionFilterLinkCountPerOwner();
        }
        if (field.equals(EMISSIONFILTERLINK)) {
            return this.getEmissionFilterLink();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(EXCITATIONFILTERLINKCOUNTPEROWNER)) {
            this.setExcitationFilterLinkCountPerOwner((Map)value);
        } else if (field.equals(EXCITATIONFILTERLINK)) {
            this.setExcitationFilterLink((List)value);
        } else if (field.equals(DICHROIC)) {
            this.setDichroic((Dichroic)value);
        } else if (field.equals(EMISSIONFILTERLINKCOUNTPEROWNER)) {
            this.setEmissionFilterLinkCountPerOwner((Map)value);
        } else if (field.equals(EMISSIONFILTERLINK)) {
            this.setEmissionFilterLink((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.excitationFilterLinkCountPerOwner = null;
        this.excitationFilterLink = null;
        this.dichroic = null;
        this.emissionFilterLinkCountPerOwner = null;
        this.emissionFilterLink = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(EXCITATIONFILTERLINKCOUNTPEROWNER);
        raw.add(EXCITATIONFILTERLINK);
        raw.add(DICHROIC);
        raw.add(EMISSIONFILTERLINKCOUNTPEROWNER);
        raw.add(EMISSIONFILTERLINK);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKlightpath_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlightpath_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKlightpath_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlightpath_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlightpath_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

