/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import ome.conditions.ApiUsageException;
import ome.model.IGlobal;
import ome.model.ILink;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@Table(name="groupexperimentermap", uniqueConstraints={@UniqueConstraint(columnNames={"parent", "child"}), @UniqueConstraint(columnNames={"child", "child_index"})})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_groupexperimentermap", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_groupexperimentermap"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class GroupExperimenterMap
implements Serializable,
IObject,
IGlobal,
IMutable,
ILink {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.GroupExperimenterMap_id";
    protected Long id;
    public static final String VERSION = "ome.model.meta.GroupExperimenterMap_version";
    protected Integer version = 0;
    protected IObject parent = null;
    protected IObject child = null;
    protected Boolean owner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String PARENT = "ome.model.meta.GroupExperimenterMap_parent";
    public static final String CHILD = "ome.model.meta.GroupExperimenterMap_child";
    public static final String OWNER = "ome.model.meta.GroupExperimenterMap_owner";
    public static final String DETAILS = "ome.model.meta.GroupExperimenterMap_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public GroupExperimenterMap() {
        this(null, true);
    }

    protected GroupExperimenterMap(Long id) {
        this(id, true);
    }

    public GroupExperimenterMap(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public GroupExperimenterMap(IObject _parent, IObject _child, Boolean _owner) {
        this(null, true);
        this.setParent(_parent);
        this.setChild(_child);
        this.setOwner(_owner);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_groupexperimentermap")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ExperimenterGroup.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="parent", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKgroupexperimentermap_parent_experimentergroup")
    @Target(value=ExperimenterGroup.class)
    public IObject getParent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.parent;
    }

    @Override
    public void setParent(IObject parent) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.parent = parent;
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Experimenter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="child", nullable=false, unique=false, insertable=false, updatable=false)
    @ForeignKey(name="FKgroupexperimentermap_child_experimenter")
    @Target(value=Experimenter.class)
    public IObject getChild() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.child;
    }

    @Override
    public void setChild(IObject child) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.child = child;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="owner", updatable=true)
    public Boolean getOwner() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.owner;
    }

    public void setOwner(Boolean owner) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.owner = owner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public GroupExperimenterMap newInstance() {
        return new GroupExperimenterMap();
    }

    public GroupExperimenterMap proxy() {
        return new GroupExperimenterMap(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.parent = (IObject)__filter.filter(PARENT, this.parent);
            this.child = (IObject)__filter.filter(CHILD, this.child);
            this.owner = (Boolean)__filter.filter(OWNER, this.owner);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(PARENT)) {
            return this.getParent();
        }
        if (field.equals(CHILD)) {
            return this.getChild();
        }
        if (field.equals(OWNER)) {
            return this.getOwner();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(PARENT)) {
            this.setParent((IObject)value);
        } else if (field.equals(CHILD)) {
            this.setChild((IObject)value);
        } else if (field.equals(OWNER)) {
            this.setOwner((Boolean)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.parent = null;
        this.child = null;
        this.owner = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    public void link(ExperimenterGroup parent, Experimenter child) {
        this.setParent(parent);
        this.setChild(child);
    }

    public ExperimenterGroup parent() {
        return (ExperimenterGroup)this.getParent();
    }

    public Experimenter child() {
        return (Experimenter)this.getChild();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(PARENT);
        raw.add(CHILD);
        raw.add(OWNER);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKgroupexperimentermap_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

