/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import ome.model.enums.UnitsElectricPotential;
import ome.model.enums.UnitsFrequency;
import ome.model.enums.UnitsLength;
import ome.model.enums.UnitsPower;
import ome.model.enums.UnitsPressure;
import ome.model.enums.UnitsTemperature;
import ome.model.enums.UnitsTime;
import ome.model.units.ElectricPotential;
import ome.model.units.Frequency;
import ome.model.units.Length;
import ome.model.units.Power;
import ome.model.units.Pressure;
import ome.model.units.Temperature;
import ome.model.units.Time;
import ome.model.units.Unit;

public enum UNITS {
    ELECTRICPOTENTIAL(ElectricPotential.class, UnitsElectricPotential.class, 3001),
    FREQUENCY(Frequency.class, UnitsFrequency.class, 3002),
    LENGTH(Length.class, UnitsLength.class, 3003),
    PRESSURE(Pressure.class, UnitsPressure.class, 3004),
    POWER(Power.class, UnitsPower.class, 3005),
    TEMPERATURE(Temperature.class, UnitsTemperature.class, 3006),
    TIME(Time.class, UnitsTime.class, 3007);

    Class<? extends Unit> quantityType;
    Class<? extends Enum<?>> enumType;
    int sqlType;
    Enum<? extends Enum<?>>[] values;
    Map<String, Enum<? extends Enum<?>>> enumMap;
    Map<Enum<? extends Enum<?>>, String> valueMap;

    private UNITS(Class<? extends Unit> quantityType, Class<? extends Enum<?>> enumType, int sqlType) {
        this.quantityType = quantityType;
        this.enumType = enumType;
        this.sqlType = sqlType;
        this.values = enumType.getEnumConstants();
        this.enumMap = new HashMap();
        this.valueMap = new HashMap();
        try {
            Method m = this.enumType.getMethod("getSymbol", new Class[0]);
            for (Enum<? extends Enum<?>> e : this.values) {
                String symbol = (String)m.invoke(e, new Object[0]);
                this.enumMap.put(symbol, e);
                this.valueMap.put(e, symbol);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse units", e);
        }
    }

    public static Map<String, Integer> listSqlTypes() {
        try {
            HashMap<String, Integer> rv = new HashMap<String, Integer>();
            for (UNITS u : UNITS.values()) {
                rv.put(u.enumType.getSimpleName(), u.sqlType);
            }
            return rv;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load sql types", e);
        }
    }

    public String todbvalue(Object obj) {
        Enum<?> e = Enum.valueOf(this.enumType, obj.toString());
        return this.valueMap.get(e);
    }

    public Enum fromdbvalue(String obj) {
        return this.enumMap.get(obj);
    }
}

