/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import ome.model.IObject;
import ome.model.acquisition.ImagingEnvironment;
import ome.model.core.Channel;
import ome.model.core.Pixels;
import ome.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Validator {
    protected static Logger log = LoggerFactory.getLogger(Validator.class);

    public static Validation validate(IObject obj) {
        return Validation.VALID();
    }

    public static Validation validate(Channel channel) {
        Validation v = Validation.VALID();
        String piType = channel.getLogicalChannel().getPhotometricInterpretation().getValue();
        if ((piType.equals("RGB") || piType.equals("ARGB") || piType.equals("CMYK") || piType.equals("HSV")) && (channel.getRed() == null || channel.getGreen() == null || channel.getBlue() == null || channel.getAlpha() == null)) {
            v.invalidate("Channel colors  cannot be null if PiType == {RGB|ARGB|CMYK|HSV}");
        }
        return v;
    }

    public static Validation validate(ImagingEnvironment imageEnvironment) {
        Double humidity;
        Validation v = Validation.VALID();
        Double co2 = imageEnvironment.getCo2percent();
        if (null != co2 && (co2.floatValue() < 0.0f || co2.floatValue() > 1.0f)) {
            v.invalidate("ImageEnvironment.co2percent must be between 0 and 1");
        }
        if (null != (humidity = imageEnvironment.getHumidity()) && (humidity.floatValue() < 0.0f || humidity.floatValue() > 1.0f)) {
            v.invalidate("ImageEnvironment.humidity must be between 0 and 1");
        }
        return v;
    }

    public static Validation valid(Pixels pixels) {
        Validation v = Validation.VALID();
        int planeInfoSize = pixels.sizeOfPlaneInfo();
        int sizeC = pixels.getSizeC();
        int sizeT = pixels.getSizeT();
        int sizeZ = pixels.getSizeZ();
        if (planeInfoSize != 0 && planeInfoSize != sizeC * sizeT * sizeZ) {
            v.invalidate("Size of planeInfo in Pixels should be 0 or sizeC*sizeT*sizeZ");
        }
        return v;
    }
}

