/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.ini4j.Config;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.OptionHandler;
import org.ini4j.OptionMapImpl;
import org.ini4j.OptionParser;
import org.ini4j.spi.EscapeTool;

public class Options
extends OptionMapImpl {
    private static final char OPERATOR = '=';
    private static final String NEWLINE = "\n";
    private Config _config = Config.getGlobal().clone();

    public Options() {
        this._config.setEmptyOption(true);
    }

    public Options(Reader input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Options(InputStream input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Options(URL input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public void setConfig(Config value) {
        this._config = value;
    }

    public void load(InputStream input) throws IOException, InvalidIniFormatException {
        OptionParser.newInstance(this.getConfig()).parse(input, (OptionHandler)new Builder());
    }

    public void load(Reader input) throws IOException, InvalidIniFormatException {
        OptionParser.newInstance(this.getConfig()).parse(input, (OptionHandler)new Builder());
    }

    public void load(URL input) throws IOException, InvalidIniFormatException {
        OptionParser.newInstance(this.getConfig()).parse(input, (OptionHandler)new Builder());
    }

    public void store(OutputStream output) throws IOException {
        this.format(new OutputStreamWriter(output));
    }

    public void store(Writer output) throws IOException {
        this.format(output);
    }

    protected Config getConfig() {
        return this._config;
    }

    protected String escape(String input) {
        return this.getConfig().isEscape() ? EscapeTool.getInstance().escape(input) : input;
    }

    protected void format(Writer output) throws IOException {
        for (String name : this.keySet()) {
            int n = this.getConfig().isMultiOption() ? this.length(name) : 1;
            for (int i = 0; i < n; ++i) {
                String value = (String)this.get(name, i);
                if (value == null && !this.getConfig().isEmptyOption()) continue;
                output.append(this.escape(name));
                output.append('=');
                if (value != null) {
                    output.append(this.escape(value));
                }
                output.append(NEWLINE);
            }
        }
        output.flush();
    }

    private class Builder
    implements OptionHandler {
        private Builder() {
        }

        public void handleOption(String name, String value) {
            if (Options.this.getConfig().isMultiOption()) {
                Options.this.add(name, value);
            } else {
                Options.this.put(name, value);
            }
        }
    }
}

