/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import ome.annotations.NotNull;
import ome.annotations.PermitAll;
import ome.annotations.RolesAllowed;
import ome.api.IAdmin;
import ome.api.RawFileStore;
import ome.api.ServiceInterface;
import ome.api.local.LocalAdmin;
import ome.conditions.ApiUsageException;
import ome.conditions.AuthenticationException;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel2Service;
import ome.logic.LdapImpl;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ExperimenterAnnotationLink;
import ome.model.annotations.FileAnnotation;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.enums.AdminPrivilege;
import ome.model.enums.ChecksumAlgorithm;
import ome.model.internal.NamedValue;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.parameters.Parameters;
import ome.security.ACLVoter;
import ome.security.AdminAction;
import ome.security.ChmodStrategy;
import ome.security.SecureAction;
import ome.security.auth.PasswordChangeException;
import ome.security.auth.PasswordProvider;
import ome.security.auth.PasswordUtil;
import ome.security.auth.RoleProvider;
import ome.security.basic.LightAdminPrivileges;
import ome.services.query.Definitions;
import ome.services.query.Query;
import ome.services.query.QueryParameterDef;
import ome.services.sessions.events.UserGroupUpdateEvent;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Roles;
import ome.system.SimpleEventContext;
import ome.tools.hibernate.QueryBuilder;
import ome.tools.hibernate.SecureMerge;
import ome.tools.hibernate.SessionFactory;
import ome.util.SqlAction;
import ome.util.Utils;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumType;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class AdminImpl
extends AbstractLevel2Service
implements LocalAdmin,
ApplicationContextAware {
    protected final SqlAction sql;
    protected final SessionFactory osf;
    protected final MailSender mailSender;
    protected final SimpleMailMessage templateMessage;
    protected final ACLVoter aclVoter;
    protected final PasswordProvider passwordProvider;
    protected final RoleProvider roleProvider;
    protected final PasswordUtil passwordUtil;
    protected final LdapImpl ldapUtil;
    protected final ChmodStrategy chmod;
    protected final ChecksumProviderFactory cpf;
    protected final LightAdminPrivileges adminPrivileges;
    protected OmeroContext context;
    protected static final String NSEXPERIMENTERPHOTO = "openmicroscopy.org/omero/experimenter/photo";

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.context = (OmeroContext)ctx;
    }

    public AdminImpl(SqlAction sql, SessionFactory osf, MailSender mailSender, SimpleMailMessage templateMessage, ACLVoter aclVoter, PasswordProvider passwordProvider, RoleProvider roleProvider, LdapImpl ldapUtil, PasswordUtil passwordUtil, ChmodStrategy chmod, ChecksumProviderFactory cpf, LightAdminPrivileges adminPrivileges) {
        this.sql = sql;
        this.osf = osf;
        this.mailSender = mailSender;
        this.templateMessage = templateMessage;
        this.aclVoter = aclVoter;
        this.passwordProvider = passwordProvider;
        this.roleProvider = roleProvider;
        this.ldapUtil = ldapUtil;
        this.passwordUtil = passwordUtil;
        this.chmod = chmod;
        this.cpf = cpf;
        this.adminPrivileges = adminPrivileges;
    }

    public Class<? extends ServiceInterface> getServiceInterface() {
        return IAdmin.class;
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter userProxy(Long id) {
        if (id == null) {
            throw new ApiUsageException("Id argument cannot be null.");
        }
        Experimenter e = (Experimenter)this.iQuery.get(Experimenter.class, id);
        return e;
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter userProxy(String omeName) {
        if (omeName == null) {
            throw new ApiUsageException("omeName argument cannot be null.");
        }
        Experimenter e = (Experimenter)this.iQuery.findByString(Experimenter.class, "omeName", this.roleProvider.isIgnoreCaseLookup() ? omeName.toLowerCase() : omeName);
        if (e == null) {
            throw new ApiUsageException("No such experimenter: " + omeName);
        }
        return e;
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup groupProxy(Long id) {
        if (id == null) {
            throw new ApiUsageException("Id argument cannot be null.");
        }
        ExperimenterGroup g = (ExperimenterGroup)this.iQuery.get(ExperimenterGroup.class, id);
        return g;
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup groupProxy(String groupName) {
        if (groupName == null) {
            throw new ApiUsageException("groupName argument cannot be null.");
        }
        ExperimenterGroup g = (ExperimenterGroup)this.iQuery.findByString(ExperimenterGroup.class, "name", groupName);
        if (g == null) {
            throw new ApiUsageException("No such group: " + groupName);
        }
        return g;
    }

    @RolesAllowed(value={"user"})
    public List<Long> getLeaderOfGroupIds(Experimenter e) {
        Assert.notNull((Object)e);
        Assert.notNull((Object)e.getId());
        final QueryBuilder qb = new QueryBuilder();
        qb.select("g.id").from("ExperimenterGroup", "g");
        qb.join("g.groupExperimenterMap", "m", false, false);
        qb.where();
        qb.and("m.owner = true");
        qb.and("m.parent.id = g.id");
        qb.and("m.child.id = :id");
        qb.param("id", (Object)e.getId());
        List groupIds = (List)this.iQuery.execute((HibernateCallback)new HibernateCallback<List<Long>>(){

            public List<Long> doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Query q = qb.query(session);
                return q.list();
            }
        });
        return groupIds;
    }

    @RolesAllowed(value={"user"})
    public List<Long> getMemberOfGroupIds(Experimenter e) {
        return this.getGroupField(e, "id");
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<String> getUserRoles(Experimenter e) {
        return this.getGroupField(e, "name");
    }

    private List getGroupField(final Experimenter e, final String name) {
        Assert.notNull((Object)e);
        Assert.notNull((Object)e.getId());
        List groupNames = (List)this.iQuery.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Query q = session.createQuery("select m.parent." + name + " from Experimenter e join e.groupExperimenterMap m where e.id = :id order by index(m)");
                q.setParameter("id", (Object)e.getId());
                return q.list();
            }
        });
        return groupNames;
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean canAnnotate(IObject obj) {
        if (obj == null) {
            throw new ApiUsageException("Argument cannot be null");
        }
        Class c = Utils.trueClass(obj.getClass());
        IObject trusted = this.iQuery.get(c, obj.getId());
        return this.aclVoter.allowAnnotate(trusted, trusted.getDetails());
    }

    @RolesAllowed(value={"user"})
    public boolean canUpdate(IObject obj) {
        if (obj == null) {
            throw new ApiUsageException("Argument cannot be null");
        }
        Class c = Utils.trueClass(obj.getClass());
        IObject trusted = this.iQuery.get(c, obj.getId());
        return this.aclVoter.allowUpdate(trusted, trusted.getDetails());
    }

    @RolesAllowed(value={"user"})
    public Experimenter getExperimenter(long id) {
        Experimenter e = this.iQuery.execute(new UserQ(new Parameters().addId(Long.valueOf(id))));
        if (e == null) {
            throw new ApiUsageException("No such experimenter: " + id);
        }
        return e;
    }

    @RolesAllowed(value={"user"})
    public Experimenter lookupExperimenter(String omeName) {
        Experimenter e = this.iQuery.execute(new UserQ(new Parameters().addString("name", this.roleProvider.isIgnoreCaseLookup() ? omeName.toLowerCase() : omeName)));
        if (e == null) {
            throw new ApiUsageException("No such experimenter: " + omeName);
        }
        return e;
    }

    @RolesAllowed(value={"user"})
    public List<Experimenter> lookupExperimenters() {
        return this.iQuery.findAllByQuery("select distinct e from Experimenter e left outer join fetch e.groupExperimenterMap m left outer join fetch m.parent g", null);
    }

    @RolesAllowed(value={"user"})
    public List<Map<String, Object>> lookupLdapAuthExperimenters() {
        return this.ldapUtil.lookupLdapAuthExperimenters();
    }

    @RolesAllowed(value={"user"})
    public String lookupLdapAuthExperimenter(long id) {
        return this.ldapUtil.lookupLdapAuthExperimenter(id);
    }

    @RolesAllowed(value={"user"})
    public ExperimenterGroup getGroup(long id) {
        ExperimenterGroup g = this.iQuery.execute(new GroupQ(new Parameters().addId(Long.valueOf(id))));
        if (g == null) {
            throw new ApiUsageException("No such group: " + id);
        }
        return g;
    }

    @RolesAllowed(value={"user"})
    public ExperimenterGroup lookupGroup(String groupName) {
        ExperimenterGroup g = this.iQuery.execute(new GroupQ(new Parameters().addString("name", groupName)));
        if (g == null) {
            throw new ApiUsageException("No such group: " + groupName);
        }
        return g;
    }

    @RolesAllowed(value={"user"})
    public List<ExperimenterGroup> lookupGroups() {
        return this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent", null);
    }

    @RolesAllowed(value={"user"})
    public Experimenter[] containedExperimenters(long groupId) {
        List experimenters = this.iQuery.findAllByQuery("select distinct e from Experimenter as e join fetch e.groupExperimenterMap as map join fetch map.parent g where e.id in   (select m.child from GroupExperimenterMap m   where m.parent.id = :id )", new Parameters().addId(Long.valueOf(groupId)));
        return experimenters.toArray(new Experimenter[experimenters.size()]);
    }

    @RolesAllowed(value={"user"})
    public ExperimenterGroup[] containedGroups(long experimenterId) {
        List groups = this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", new Parameters().addId(Long.valueOf(experimenterId)));
        return groups.toArray(new ExperimenterGroup[groups.size()]);
    }

    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public void synchronizeLoginCache() {
        Logger log = this.getBeanHelper().getLogger();
        List<Map<String, Object>> dnIds = this.ldapUtil.lookupLdapAuthExperimenters();
        if (dnIds.size() > 0) {
            log.info("Synchronizing " + dnIds.size() + " ldap user(s)");
        }
        for (Map<String, Object> dnId : dnIds) {
            String dn = (String)dnId.get("dn");
            Long id = (Long)dnId.get("experimenter_id");
            try {
                Experimenter e = this.userProxy(id);
                this.ldapUtil.synchronizeLdapUser(e.getOmeName());
            }
            catch (ApiUsageException aue) {
                log.debug("User not found: " + dn);
            }
            catch (Exception e) {
                log.error("synchronizeLdapUser:" + dnId, (Throwable)e);
            }
        }
        this.context.publishEvent((ApplicationEvent)new UserGroupUpdateEvent(this));
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateSelf(@NotNull Experimenter e) {
        EventContext ec = this.getSecuritySystem().getEventContext();
        Long userId = ec.getCurrentUserId();
        Long sudoerId = ec.getCurrentSudoerId();
        Experimenter self = this.getExperimenter(userId);
        if (sudoerId != null && !sudoerId.equals(userId)) {
            this.adminOfUser(self);
        }
        self.setFirstName(e.getFirstName());
        self.setMiddleName(e.getMiddleName());
        self.setLastName(e.getLastName());
        self.setEmail(e.getEmail());
        self.setInstitution(e.getInstitution());
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.flush();
            }
        });
        this.getBeanHelper().getLogger().info("Updated own user info: " + self.getOmeName());
    }

    public List<OriginalFile> getMyUserPhotos() {
        Parameters parameters = new Parameters();
        parameters.addId(this.getEventContext().getCurrentUserId());
        parameters.addString("ns", NSEXPERIMENTERPHOTO);
        List photos = this.iQuery.findAllByQuery("select f from Experimenter e join e.annotationLinks l join l.child a join a.file f where e.id = :id and a.ns = :ns", parameters);
        return photos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long uploadMyUserPhoto(String filename, String mimetype, byte[] data) {
        Long uid = this.getEventContext().getCurrentUserId();
        List<OriginalFile> photos = this.getMyUserPhotos();
        OriginalFile file = null;
        if (photos.size() > 0) {
            file = photos.get(0);
        }
        if (file == null) {
            file = new OriginalFile();
            file.setName(filename);
            file.setPath(filename);
            file.setSize(Long.valueOf(data.length));
            file.setHasher(new ChecksumAlgorithm("SHA1-160"));
            file.setHash(this.cpf.getProvider(ChecksumType.SHA1).putBytes(data).checksumAsString());
            file.setMimetype(mimetype);
            FileAnnotation fa = new FileAnnotation();
            fa.setNs(NSEXPERIMENTERPHOTO);
            fa.setFile(file);
            ExperimenterAnnotationLink link = new ExperimenterAnnotationLink();
            link.link(new Experimenter(uid, false), (Annotation)fa);
            link = (ExperimenterAnnotationLink)this.iUpdate.saveAndReturnObject((IObject)link);
            fa = (FileAnnotation)link.getChild();
            file = fa.getFile();
            this.internalMoveToCommonSpace((IObject)file);
            this.internalMoveToCommonSpace((IObject)fa);
            this.internalMoveToCommonSpace((IObject)link);
        } else {
            file.setName(filename);
            file.setPath(filename);
            file.setMimetype(mimetype);
            file = (OriginalFile)this.iUpdate.saveAndReturnObject((IObject)file);
        }
        try (RawFileStore rfs = (RawFileStore)this.context.getBean("internal-ome.api.RawFileStore", RawFileStore.class);){
            rfs.setFileId(file.getId().longValue());
            rfs.write(data, 0L, data.length);
            file = rfs.save();
        }
        return file.getId();
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateExperimenter(@NotNull Experimenter experimenter) {
        try {
            this.adminOfUser(experimenter);
            String name = experimenter.getOmeName();
            this.copyAndSaveExperimenter(experimenter);
            this.getBeanHelper().getLogger().info("Updated user info for " + name);
        }
        catch (SecurityViolation sv) {
            Long currentID = this.getEventContext().getCurrentUserId();
            Long experimenterID = experimenter.getId();
            if (currentID.equals(experimenterID)) {
                this.updateSelf(experimenter);
            }
            throw sv;
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateExperimenterWithPassword(@NotNull Experimenter experimenter, String password) {
        this.adminOfUser(experimenter);
        this.copyAndSaveExperimenter(experimenter);
        Experimenter orig = this.userProxy(experimenter.getId());
        String name = orig.getOmeName();
        this.changeUserPassword(name, password);
        this.getBeanHelper().getLogger().info("Updated user info and password for " + name);
    }

    private void copyAndSaveExperimenter(Experimenter experimenter) {
        String newOmeName;
        Experimenter orig = this.userProxy(experimenter.getId());
        String origOmeName = orig.getOmeName();
        if (!origOmeName.equals(newOmeName = experimenter.getOmeName())) {
            Roles roles = this.getSecurityRoles();
            ImmutableSet fixedExperimenterNames = ImmutableSet.of((Object)roles.getRootName(), (Object)roles.getGuestName());
            if (fixedExperimenterNames.contains(origOmeName)) {
                throw new ValidationException("cannot change name of special experimenter '" + origOmeName + "'");
            }
            if (fixedExperimenterNames.contains(newOmeName)) {
                throw new ValidationException("cannot change name to special experimenter '" + newOmeName + "'");
            }
        }
        orig.setOmeName(newOmeName);
        orig.setEmail(experimenter.getEmail());
        orig.setFirstName(experimenter.getFirstName());
        orig.setMiddleName(experimenter.getMiddleName());
        orig.setLastName(experimenter.getLastName());
        orig.setInstitution(experimenter.getInstitution());
        this.reallySafeSave((IObject)orig);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateGroup(@NotNull ExperimenterGroup group) {
        String newName;
        ExperimenterGroup orig;
        String origName;
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroup"), group);
        Permissions p = group.getDetails().getPermissions();
        if (p != null) {
            this.changePermissions((IObject)group, p);
        }
        if (!(origName = (orig = this.getGroup(group.getId())).getName()).equals(newName = group.getName())) {
            Roles roles = this.getSecurityRoles();
            ImmutableSet fixedGroupNames = ImmutableSet.of((Object)roles.getGuestGroupName(), (Object)roles.getSystemGroupName(), (Object)roles.getUserGroupName());
            if (fixedGroupNames.contains(origName)) {
                throw new ValidationException("cannot change name of special group '" + origName + "'");
            }
            if (fixedGroupNames.contains(newName)) {
                throw new ValidationException("cannot change name to special group '" + newName + "'");
            }
            if (group.getId().equals(this.getEventContext().getCurrentGroupId())) {
                throw new ValidationException("cannot rename the current group context '" + origName + "'");
            }
        }
        orig.setName(newName);
        orig.setDescription(group.getDescription());
        this.reallySafeSave((IObject)orig);
        this.getBeanHelper().getLogger().info("Updated group info for " + group);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long createUser(Experimenter newUser, String defaultGroup) {
        ExperimenterGroup proxy = this.groupProxy(defaultGroup);
        return this.createExperimenter(newUser, proxy, this.groupProxy(this.sec.getSecurityRoles().getUserGroupName()));
    }

    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public long createSystemUser(Experimenter newSystemUser) {
        return this.createExperimenter(newSystemUser, this.groupProxy(this.sec.getSecurityRoles().getSystemGroupName()), this.groupProxy(this.sec.getSecurityRoles().getUserGroupName()));
    }

    private long createSystemUserWithPassword(Experimenter newSystemUser, String password) {
        return this.createExperimenterWithPassword(newSystemUser, password, this.groupProxy(this.sec.getSecurityRoles().getSystemGroupName()), this.groupProxy(this.sec.getSecurityRoles().getUserGroupName()));
    }

    private List<NamedValue> getRestrictedSystemUserConfig(Collection<AdminPrivilege> privileges) {
        this.assertKnownPrivileges(privileges);
        ArrayList<NamedValue> userConfig = new ArrayList<NamedValue>();
        for (AdminPrivilege privilege : LightAdminPrivileges.getAllPrivileges()) {
            if (privileges.contains(privilege)) continue;
            userConfig.add(new NamedValue(this.adminPrivileges.getConfigNameForPrivilege(privilege), Boolean.toString(false)));
        }
        return userConfig;
    }

    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public long createRestrictedSystemUser(Experimenter newSystemUser, List<AdminPrivilege> privileges) {
        newSystemUser.setConfig(this.getRestrictedSystemUserConfig(privileges));
        return this.createSystemUser(newSystemUser);
    }

    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public long createRestrictedSystemUserWithPassword(Experimenter newSystemUser, List<AdminPrivilege> privileges, String password) {
        newSystemUser.setConfig(this.getRestrictedSystemUserConfig(privileges));
        return this.createSystemUserWithPassword(newSystemUser, password);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long createExperimenter(Experimenter experimenter, ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        this.adminOrPiOfNonUserGroups(defaultGroup, otherGroups);
        long uid = this.roleProvider.createExperimenter(experimenter, defaultGroup, otherGroups);
        this.changeUserPassword(experimenter.getOmeName(), " ", true);
        this.assertNoPrivilegeElevation(new Experimenter(Long.valueOf(uid), false), Collections.emptySet());
        this.getBeanHelper().getLogger().info("Created user with blank password: " + experimenter.getOmeName());
        return uid;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long createExperimenterWithPassword(Experimenter experimenter, String password, ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        this.adminOrPiOfNonUserGroups(defaultGroup, otherGroups);
        long uid = this.roleProvider.createExperimenter(experimenter, defaultGroup, otherGroups);
        this.changeUserPassword(experimenter.getOmeName(), password, true);
        this.assertNoPrivilegeElevation(new Experimenter(Long.valueOf(uid), false), Collections.emptySet());
        this.getBeanHelper().getLogger().info("Created user with password: " + experimenter.getOmeName());
        return uid;
    }

    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public long createGroup(ExperimenterGroup group) {
        if (!this.getCurrentAdminPrivilegesForSession().contains(this.adminPrivileges.getPrivilege("ModifyGroup"))) {
            this.throwNonAdminOrPi();
        }
        long gid = this.roleProvider.createGroup(group);
        this.getBeanHelper().getLogger().info("Created group: " + group.getName());
        return gid;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addGroups(Experimenter user, ExperimenterGroup ... groups) {
        if (groups == null || groups.length == 0) {
            throw new ValidationException("Nothing to do.");
        }
        this.assertManaged((IObject)user);
        for (ExperimenterGroup group : groups) {
            this.assertManaged((IObject)group);
        }
        ImmutableSet targetUserPrivilegesBefore = ImmutableSet.copyOf(this.getAdminPrivileges(user));
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroupMembership"), groups);
        this.roleProvider.addGroups(user, groups);
        this.assertNoPrivilegeElevation(user, (Set<AdminPrivilege>)targetUserPrivilegesBefore);
        this.getBeanHelper().getLogger().info(String.format("Added user %s to groups %s", this.userProxy(user.getId()).getOmeName(), Arrays.asList(groups)));
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeGroups(Experimenter user, ExperimenterGroup ... groups) {
        if (user == null) {
            return;
        }
        if (groups == null) {
            return;
        }
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroupMembership"), groups);
        Roles roles = this.getSecurityRoles();
        boolean removeSystemOrUser = Iterators.any((Iterator)Iterators.forArray((Object[])groups), (Predicate)Predicates.or(arg_0 -> ((Roles)roles).isSystemGroup(arg_0), arg_0 -> ((Roles)roles).isUserGroup(arg_0)));
        if (removeSystemOrUser && roles.isRootUser(user)) {
            throw new ValidationException("experimenter '" + roles.getRootName() + "' may not be removed from the '" + roles.getSystemGroupName() + "' or '" + roles.getUserGroupName() + "' group");
        }
        EventContext eventContext = this.getEventContext();
        boolean userOperatingOnThemself = eventContext.getCurrentUserId().equals(user.getId());
        if (removeSystemOrUser && userOperatingOnThemself) {
            throw new ValidationException("experimenters may not remove themselves from the '" + roles.getSystemGroupName() + "' or '" + roles.getUserGroupName() + "' group");
        }
        Experimenter loadedUser = this.userProxy(user.getId());
        HashSet<Long> resultingGroupIds = new HashSet<Long>();
        for (GroupExperimenterMap map : loadedUser.collectGroupExperimenterMap(null)) {
            resultingGroupIds.add(map.parent().getId());
        }
        for (ExperimenterGroup group : groups) {
            resultingGroupIds.remove(group.getId());
        }
        if (resultingGroupIds.isEmpty()) {
            throw new ValidationException("experimenter must remain a member of some group");
        }
        if (resultingGroupIds.equals(Collections.singleton(roles.getUserGroupId()))) {
            throw new ValidationException("experimenter cannot be a member of only the '" + roles.getUserGroupName() + "' group, a different default group is also required");
        }
        this.roleProvider.removeGroups(user, groups);
        this.getBeanHelper().getLogger().info(String.format("Removed user %s from groups %s", user, groups));
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setDefaultGroup(Experimenter user, ExperimenterGroup group) {
        if (user == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (group.getId() == null) {
            throw new ApiUsageException("Group argument to setDefaultGroup must be managed (i.e. have an id)");
        }
        EventContext ec = this.getSecuritySystem().getEventContext();
        if (!(this.isAdmin() && this.getCurrentAdminPrivilegesForSession().contains(this.adminPrivileges.getPrivilege("ModifyUser")) || ec.getCurrentUserId().equals(user.getId()))) {
            throw new SecurityViolation("User " + user.getId() + " can only set own default group.");
        }
        Roles roles = this.getSecuritySystem().getSecurityRoles();
        if (Long.valueOf(roles.getUserGroupId()).equals(group.getId())) {
            throw new ApiUsageException("Cannot set default group to: " + roles.getUserGroupName());
        }
        this.roleProvider.setDefaultGroup(user, group);
        this.getBeanHelper().getLogger().info(String.format("Changing default group for %s to %s", user, group));
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setGroupOwner(ExperimenterGroup group, Experimenter owner) {
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroupMembership"), group);
        this.toggleGroupOwner(group, owner, Boolean.TRUE);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void unsetGroupOwner(ExperimenterGroup group, Experimenter owner) {
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroupMembership"), group);
        this.toggleGroupOwner(group, owner, Boolean.FALSE);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addGroupOwners(ExperimenterGroup group, Experimenter ... owner) {
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroupMembership"), group);
        for (Experimenter o : owner) {
            this.toggleGroupOwner(group, o, Boolean.TRUE);
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeGroupOwners(ExperimenterGroup group, Experimenter ... owner) {
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroupMembership"), group);
        for (Experimenter o : owner) {
            this.toggleGroupOwner(group, o, Boolean.FALSE);
        }
    }

    private void toggleGroupOwner(ExperimenterGroup group, Experimenter owner, Boolean value) {
        if (owner == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (group.getId() == null) {
            throw new ApiUsageException("Group argument to setGroupOwner must be managed (i.e. have an id)");
        }
        if (owner.getId() == null) {
            throw new ApiUsageException("Owner argument to setGroupOwner must be managed (i.e. have an id)");
        }
        GroupExperimenterMap m = this.findLink(group, owner);
        if (m == null) {
            this.addGroups(owner, group);
            m = this.findLink(group, owner);
        }
        m.setOwner(value);
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.flush();
            }
        });
        this.getBeanHelper().getLogger().info(String.format("%s user %s as owner of group %s", value != false ? "Setting" : "Unsetting", owner.getId(), group.getId()));
    }

    private GroupExperimenterMap findLink(ExperimenterGroup group, Experimenter owner) {
        GroupExperimenterMap m = (GroupExperimenterMap)this.iQuery.findByQuery("select m from GroupExperimenterMap m where m.parent.id = :pid and m.child.id = :cid", new Parameters().addLong("pid", group.getId()).addLong("cid", owner.getId()));
        return m;
    }

    @RolesAllowed(value={"user"})
    public ExperimenterGroup getDefaultGroup(@NotNull long experimenterId) {
        ExperimenterGroup g = (ExperimenterGroup)this.iQuery.findByQuery("select g from ExperimenterGroup g, Experimenter e join e.groupExperimenterMap m where e.id = :id and m.parent = g.id and g.name != :userGroup and index(m) = 0", new Parameters().addId(Long.valueOf(experimenterId)).addString("userGroup", this.sec.getSecurityRoles().getUserGroupName()));
        if (g == null) {
            throw new ValidationException("The user " + experimenterId + " has no default group set.");
        }
        return g;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void deleteExperimenter(Experimenter user) {
        this.adminOfUser(user);
        final Experimenter e = this.userProxy(user.getId());
        int count = this.sql.removePassword(e.getId());
        if (count == 0) {
            this.getBeanHelper().getLogger().info("No password found for user " + e.getOmeName() + ". Cannot delete.");
        }
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.deleteObject((IObject)e);
            }
        });
        this.getBeanHelper().getLogger().info("Deleted user: " + e.getOmeName());
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void deleteGroup(ExperimenterGroup group) {
        this.adminOrPiOfGroups(this.adminPrivileges.getPrivilege("ModifyGroup"), group);
        final ExperimenterGroup g = this.groupProxy(group.getId());
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.deleteObject((IObject)g);
            }
        });
        this.getBeanHelper().getLogger().info("Deleted group: " + g.getName());
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changeOwner(IObject iObject, String omeName) {
        IObject copy = this.iQuery.get(iObject.getClass(), iObject.getId());
        Experimenter owner = this.userProxy(omeName);
        copy.getDetails().setOwner(owner);
        this.iUpdate.saveObject(copy);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changeGroup(IObject iObject, String groupName) {
        Map<String, Long> locks;
        Long total;
        IObject copy = this.iQuery.get(iObject.getClass(), iObject.getId());
        ExperimenterGroup group = this.groupProxy(groupName);
        EventContext ec = this.getSecuritySystem().getEventContext();
        if (!ec.getCurrentUserId().equals(copy.getDetails().getOwner().getId()) && !ec.isCurrentUserAdmin()) {
            throw new SecurityViolation("Cannot change group for:" + iObject);
        }
        if (this.getSecurityRoles().getUserGroupId() == group.getId().longValue()) {
            throw new SecurityViolation("Use moveToCommonSpace for moving to user group");
        }
        if (!ec.getMemberOfGroupsList().contains(group.getId())) {
            throw new SecurityViolation("Can't change to group; not a member of " + group.getId());
        }
        copy.getDetails().setGroup(group);
        this.secureFlush(copy);
        if (copy instanceof Image) {
            Image img = (Image)copy;
            Iterator it = img.iteratePixels();
            while (it.hasNext()) {
                Pixels pix = (Pixels)it.next();
                pix.getDetails().setGroup(group);
                this.secureFlush((IObject)pix);
            }
        }
        if ((total = (locks = this.getLockingIds(copy.getClass(), copy.getId(), group.getId())).get("*")) != null && total > 0L) {
            throw new SecurityViolation("Locks: " + locks);
        }
    }

    private void secureFlush(IObject copy) {
        this.getSecuritySystem().doAction(new SecureAction(){

            @Override
            public <T extends IObject> T updateObject(T ... objs) {
                AdminImpl.this.iUpdate.flush();
                return null;
            }
        }, new IObject[]{copy});
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changePermissions(IObject iObject, Permissions perms) {
        Session s = this.osf.getSession();
        String p = perms.toString();
        Object[] checks = this.chmod.getChecks(iObject, p);
        this.chmod.chmod(iObject, p);
        for (Object check : checks) {
            this.chmod.check(iObject, check);
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void moveToCommonSpace(IObject ... iObjects) {
        AdminPrivilege modifyGroup = this.adminPrivileges.getPrivilege("ModifyGroup");
        for (IObject object : iObjects) {
            if (object == null) continue;
            Long id = object.getId();
            Class c = Utils.trueClass(object.getClass());
            IObject o = this.iQuery.get(c, id);
            ExperimenterGroup g = o.getDetails().getGroup();
            if (g.getId().equals(this.getSecurityRoles().getUserGroupId())) continue;
            this.adminOrPiOfGroups(modifyGroup, g);
            this.internalMoveToCommonSpace(o);
        }
    }

    @Override
    public void internalMoveToCommonSpace(IObject obj) {
        Session session = this.osf.getSession();
        obj.getDetails().setGroup(this.groupProxy(this.getSecurityRoles().getUserGroupId()));
        this.secureFlush(obj);
        this.getBeanHelper().getLogger().info("Moved object to common space: " + obj);
    }

    public Map<String, Long> getLockingIds(IObject object) {
        return this.getLockingIds(object.getClass(), object.getId(), null);
    }

    @Override
    public Map<String, Long> getLockingIds(Class<IObject> type, long id, Long groupId) {
        String groupClause = "";
        if (groupId != null) {
            groupClause = "and details.group.id <> " + groupId;
        }
        Class klass = Utils.trueClass(type);
        String[][] checks = this.metadata.getLockChecks(klass);
        return this.metadata.countLocks(this.osf.getSession(), id, checks, groupClause);
    }

    @PermitAll
    @Transactional(readOnly=false)
    public void reportForgottenPassword(final String name, final String email) throws AuthenticationException {
        if (name == null) {
            throw new IllegalArgumentException("Unexpected null username.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Unexpected null e-mail.");
        }
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                Experimenter e = (Experimenter)AdminImpl.this.iQuery.findByString(Experimenter.class, "omeName", name);
                if (e == null) {
                    throw new AuthenticationException("Unknown user.");
                }
                if (e.getEmail() == null) {
                    throw new AuthenticationException("User has no email address.");
                }
                if (!e.getEmail().equals(email)) {
                    throw new AuthenticationException("Email address does not match.");
                }
                if (AdminImpl.this.passwordUtil.getDnById(e.getId())) {
                    throw new AuthenticationException("User is authenticated by LDAP server you cannot reset this password.");
                }
                long systemGroupId = AdminImpl.this.getSecurityRoles().getSystemGroupId();
                for (ExperimenterGroup group : e.linkedExperimenterGroupList()) {
                    if (group.getId() != systemGroupId) continue;
                    throw new ApiUsageException("Cannot reset password of administrators. Have another administrator set the new password.");
                }
                String passwd = AdminImpl.this.passwordUtil.generateRandomPasswd();
                AdminImpl.this.sendEmail(e, passwd);
                AdminImpl.this._changePassword(e.getOmeName(), passwd);
            }
        });
    }

    private void sendEmail(Experimenter e, String newPassword) {
        SimpleMailMessage msg = new SimpleMailMessage(this.templateMessage);
        msg.setSubject("OMERO - Reset password");
        msg.setTo(e.getEmail());
        msg.setText("Dear " + e.getFirstName() + " " + e.getLastName() + " (" + e.getOmeName() + ") your new password is: " + newPassword);
        try {
            this.mailSender.send(msg);
            this.getBeanHelper().getLogger().info("sent new password for {} to {}", (Object)e.getOmeName(), (Object)e.getEmail());
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception: " + ex.getMessage() + ". Password was not changed because email could not be sent to user:" + e.getOmeName() + ". Please turn on the debug mode by setting omero.mail.debug to true using bin/omero config set.");
        }
    }

    @PermitAll
    @Transactional(readOnly=false)
    public void changeExpiredCredentials(String name, String oldCred, String newCred) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    @RolesAllowed(value={"user", "HasPassword"})
    @Transactional(readOnly=false)
    public void changePassword(String newPassword) {
        String user = this.getSecuritySystem().getEventContext().getCurrentUserName();
        this._changePassword(user, newPassword);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changePasswordWithOldPassword(String oldPassword, String newPassword) {
        String user = this.getSecuritySystem().getEventContext().getCurrentUserName();
        if (!this.checkPassword(user, oldPassword, false)) {
            throw new SecurityViolation("Old password is invalid");
        }
        this._changePassword(user, newPassword);
    }

    @RolesAllowed(value={"user", "HasPassword"})
    @Transactional(readOnly=false)
    public void changeUserPassword(String user, String newPassword) {
        this.changeUserPassword(user, newPassword, false);
    }

    private void changeUserPassword(String user, String newPassword, boolean isNewUser) {
        Experimenter targetUser = this.userProxy(user);
        if (isNewUser) {
            this.adminOrPiOfUser(targetUser);
        } else {
            this.adminOfUser(targetUser);
        }
        Set<AdminPrivilege> myPrivileges = this.getCurrentAdminPrivilegesForSession();
        for (AdminPrivilege targetPrivilege : this.getAdminPrivileges(targetUser)) {
            if (myPrivileges.contains(targetPrivilege)) continue;
            throw new SecurityViolation("Cannot change the password of a more privileged user.");
        }
        this._changePassword(user, newPassword);
    }

    private void _changePassword(String user, String newPassword) {
        try {
            this.passwordProvider.changePassword(user, newPassword);
            this.getBeanHelper().getLogger().info("Changed password for user: " + user);
        }
        catch (PasswordChangeException e) {
            throw new SecurityViolation("PasswordChangeException: " + e.getMessage());
        }
    }

    @Override
    public boolean checkPassword(String name, String password, boolean readOnly) {
        Boolean result = this.passwordProvider.checkPassword(name, password, readOnly);
        if (result == null) {
            this.getBeanHelper().getLogger().warn("Password provider returned null: " + this.passwordProvider);
            return false;
        }
        return result;
    }

    @RolesAllowed(value={"user"})
    public List<Experimenter> getAdminsWithPrivileges(List<AdminPrivilege> privileges) {
        this.assertKnownPrivileges(privileges);
        ArrayList<Experimenter> admins = new ArrayList<Experimenter>();
        long systemGroupId = this.getSecurityRoles().getSystemGroupId();
        Iterator memberships = this.getGroup(systemGroupId).iterateGroupExperimenterMap();
        while (memberships.hasNext()) {
            boolean hasPrivileges = true;
            Experimenter admin = this.userProxy(((GroupExperimenterMap)memberships.next()).getChild().getId());
            List<AdminPrivilege> privilegesOfAdmin = this.getAdminPrivileges(admin);
            for (AdminPrivilege privilege : privileges) {
                if (privilegesOfAdmin.contains(privilege)) continue;
                hasPrivileges = false;
                break;
            }
            if (!hasPrivileges) continue;
            admins.add(admin);
        }
        return admins;
    }

    @RolesAllowed(value={"user"})
    public List<AdminPrivilege> getCurrentAdminPrivileges() {
        return new ArrayList<AdminPrivilege>(this.getCurrentAdminPrivilegesForSession());
    }

    @RolesAllowed(value={"user"})
    public List<AdminPrivilege> getAdminPrivileges(Experimenter user) {
        if (!this.getMemberOfGroupIds(user).contains(this.getSecurityRoles().getSystemGroupId())) {
            return Collections.emptyList();
        }
        List userConfig = this.userProxy(user.getId()).getConfig();
        ArrayList<AdminPrivilege> privileges = new ArrayList<AdminPrivilege>((Collection<AdminPrivilege>)LightAdminPrivileges.getAllPrivileges());
        if (CollectionUtils.isNotEmpty((Collection)userConfig)) {
            for (NamedValue configProperty : userConfig) {
                if (Boolean.parseBoolean(configProperty.getValue())) continue;
                privileges.remove(this.adminPrivileges.getPrivilegeForConfigName(configProperty.getName()));
            }
        }
        return privileges;
    }

    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public void setAdminPrivileges(Experimenter user, List<AdminPrivilege> privileges) {
        ArrayList<NamedValue> userConfig;
        this.assertKnownPrivileges(privileges);
        ImmutableSet targetUserPrivilegesBefore = ImmutableSet.copyOf(this.getAdminPrivileges(user));
        HashSet<AdminPrivilege> privilegesToRemove = new HashSet<AdminPrivilege>((Collection<AdminPrivilege>)LightAdminPrivileges.getAllPrivileges());
        privilegesToRemove.removeAll(privileges);
        if (user.getId().longValue() == this.getSecurityRoles().getRootId() && !privilegesToRemove.isEmpty()) {
            throw new ApiUsageException("cannot remove light administrator privileges from the root user");
        }
        if ((user = this.userProxy(user.getId())).getConfig() == null) {
            userConfig = new ArrayList<NamedValue>();
            user.setConfig(userConfig);
        } else {
            userConfig = user.getConfig();
            for (NamedValue configProperty : userConfig) {
                AdminPrivilege currentPrivilege = this.adminPrivileges.getPrivilegeForConfigName(configProperty.getName());
                if (currentPrivilege == null) continue;
                boolean hasPrivilege = privileges.contains(currentPrivilege);
                if (hasPrivilege != Boolean.parseBoolean(configProperty.getValue())) {
                    configProperty.setValue(Boolean.toString(hasPrivilege));
                }
                privilegesToRemove.remove(currentPrivilege);
            }
        }
        for (AdminPrivilege privilege : privilegesToRemove) {
            userConfig.add(new NamedValue(this.adminPrivileges.getConfigNameForPrivilege(privilege), Boolean.toString(false)));
        }
        this.iUpdate.saveObject((IObject)user);
        this.assertNoPrivilegeElevation(user, (Set<AdminPrivilege>)targetUserPrivilegesBefore);
    }

    @PermitAll
    public Roles getSecurityRoles() {
        return this.getSecuritySystem().getSecurityRoles();
    }

    @PermitAll
    public EventContext getEventContext() {
        return new SimpleEventContext(this.getSecuritySystem().getEventContext(true));
    }

    @Override
    public EventContext getEventContextQuiet() {
        return new SimpleEventContext(this.getSecuritySystem().getEventContext(false));
    }

    protected void assertManaged(IObject o) {
        if (o == null) {
            throw new ApiUsageException("Argument may not be null.");
        }
        if (o.getId() == null) {
            throw new ApiUsageException(o.getClass().getName() + " has no id.");
        }
    }

    private Set<String> classes() {
        return this.getExtendedMetadata().getClasses();
    }

    private String table(String className) {
        try {
            Class<?> c = Class.forName(className);
            Table t = null;
            if (IGlobal.class.isAssignableFrom(c)) {
                return null;
            }
            if (c.getAnnotation(Table.class) == null) {
                return null;
            }
            if (c.getAnnotation(PrimaryKeyJoinColumn.class) != null) {
                return null;
            }
            t = c.getAnnotation(Table.class);
            return t.name();
        }
        catch (Exception e) {
            throw new InternalException("Miss configuration. Should never happen.");
        }
    }

    private void reallySafeSave(IObject obj) {
        final Session session = this.osf.getSession();
        this.sec.doAction(new SecureMerge(session), new IObject[]{obj});
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                session.flush();
            }
        });
    }

    private boolean isAdmin() {
        return this.getEventContext().isCurrentUserAdmin();
    }

    private boolean isPiOf(Experimenter user) {
        if (user == null) {
            return true;
        }
        List<Long> userIn = this.getMemberOfGroupIds(user);
        List piOf = this.getEventContext().getLeaderOfGroupsList();
        for (Long id : piOf) {
            if (!userIn.contains(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isPiOf(ExperimenterGroup group) {
        if (group == null) {
            return true;
        }
        EventContext ec = this.getEventContext();
        List piOf = ec.getLeaderOfGroupsList();
        return piOf.contains(group.getId());
    }

    private void throwNonAdmin() {
        String msg = "Current user is not admin for the given user(s)";
        throw new SecurityViolation("Current user is not admin for the given user(s)");
    }

    private void throwNonAdminOrPi() {
        String msg = "Current user is neither admin nor group-leader for the given user(s)/group(s)";
        throw new SecurityViolation(msg);
    }

    private void adminOfUser(Experimenter user) {
        if (!this.isAdmin() || !this.getCurrentAdminPrivilegesForSession().contains(this.adminPrivileges.getPrivilege("ModifyUser"))) {
            this.throwNonAdmin();
        }
    }

    private void adminOrPiOfUser(Experimenter user) {
        if (!(this.isAdmin() && this.getCurrentAdminPrivilegesForSession().contains(this.adminPrivileges.getPrivilege("ModifyUser")) || this.isPiOf(user))) {
            this.throwNonAdminOrPi();
        }
    }

    private void adminOrPiOfGroups(AdminPrivilege overridingPrivilege, ExperimenterGroup ... groups) {
        if (!this.isAdmin() || !this.getCurrentAdminPrivilegesForSession().contains(overridingPrivilege)) {
            for (ExperimenterGroup group : groups) {
                if (this.isPiOf(group)) continue;
                this.throwNonAdminOrPi();
            }
        }
    }

    private void adminOrPiOfNonUserGroups(ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        HashSet<ExperimenterGroup> nonUserGroupGroups = new HashSet<ExperimenterGroup>();
        for (ExperimenterGroup eg : otherGroups) {
            if (eg.getId().equals(this.getSecurityRoles().getUserGroupId())) continue;
            nonUserGroupGroups.add(eg);
        }
        AdminPrivilege modifyUser = this.adminPrivileges.getPrivilege("ModifyUser");
        this.adminOrPiOfGroups(modifyUser, defaultGroup);
        this.adminOrPiOfGroups(modifyUser, nonUserGroupGroups.toArray(new ExperimenterGroup[0]));
    }

    private void assertKnownPrivileges(Iterable<AdminPrivilege> privileges) {
        for (AdminPrivilege privilege : privileges) {
            if (this.adminPrivileges.getPrivilege(privilege.getValue()) != null) continue;
            throw new ApiUsageException("unknown light administrator privilege: " + privilege.getValue());
        }
    }

    private void assertNoPrivilegeElevation(Experimenter user, Set<AdminPrivilege> privilegesInitial) {
        ImmutableSet privilegesNow = ImmutableSet.copyOf(this.getAdminPrivileges(user));
        Sets.SetView privilegesGained = Sets.difference((Set)privilegesNow, privilegesInitial);
        if (!Sets.difference((Set)privilegesGained, this.getCurrentAdminPrivilegesForSession()).isEmpty()) {
            throw new SecurityViolation("cannot give administrator privileges that current user does not have");
        }
    }

    private Set<AdminPrivilege> getCurrentAdminPrivilegesForSession() {
        return this.isAdmin() ? this.getEventContextQuiet().getCurrentAdminPrivileges() : Collections.emptySet();
    }

    static class GroupQ
    extends BaseQ<ExperimenterGroup> {
        public GroupQ(Parameters params) {
            super(params);
        }

        @Override
        protected void buildQuery(Session session) throws HibernateException, SQLException {
            QueryBuilder qb = new QueryBuilder();
            qb.select("g");
            qb.from("ExperimenterGroup", "g");
            qb.join("g.groupExperimenterMap", "m", true, true);
            qb.join("m.child", "user", true, true);
            qb.where();
            Object name = this.value("name");
            Object id = this.value("id");
            if (name != null) {
                qb.and("g.name = :name");
                qb.param("name", name);
            } else if (id != null) {
                qb.and("g.id = :id");
                qb.param("id", id);
            } else {
                throw new InternalException("Name and id are both null for group query.");
            }
            this.setQuery(qb.query(session));
        }
    }

    static class UserQ
    extends BaseQ<Experimenter> {
        public UserQ(Parameters params) {
            super(params);
        }

        @Override
        protected void buildQuery(Session session) throws HibernateException, SQLException {
            Criteria c = session.createCriteria(Experimenter.class);
            Criteria m = c.createCriteria("groupExperimenterMap", 1);
            Criteria g = m.createCriteria("parent", 1);
            if (this.value("name") != null) {
                c.add((Criterion)Restrictions.eq((String)"omeName", (Object)this.value("name")));
            } else if (this.value("id") != null) {
                c.add((Criterion)Restrictions.eq((String)"id", (Object)this.value("id")));
            } else {
                throw new InternalException("Name and id are both null for user query.");
            }
            this.setCriteria(c);
        }
    }

    static abstract class BaseQ<T>
    extends Query<T> {
        static Definitions defs = new Definitions(new QueryParameterDef("name", String.class, true), new QueryParameterDef("id", Long.class, true));

        public BaseQ(Parameters params) {
            super(defs, new Parameters().unique().addAll(params));
        }
    }
}

