/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import java.util.Map;
import ome.model.internal.Details;
import ome.security.SecurityFilter;
import ome.security.basic.AllGroupsSecurityFilter;
import ome.security.basic.CurrentDetails;
import ome.security.basic.OneGroupSecurityFilter;
import ome.security.basic.SharingSecurityFilter;
import ome.system.EventContext;
import org.hibernate.Session;

public class SecurityFilterHolder
implements SecurityFilter {
    protected final AllGroupsSecurityFilter allgroups;
    protected final OneGroupSecurityFilter onegroup;
    protected final SharingSecurityFilter share;
    protected final CurrentDetails cd;
    protected ThreadLocal<SecurityFilter> current = new ThreadLocal<SecurityFilter>(){

        @Override
        protected SecurityFilter initialValue() {
            return SecurityFilterHolder.this.onegroup;
        }
    };

    public SecurityFilterHolder(CurrentDetails cd, OneGroupSecurityFilter onegroup, AllGroupsSecurityFilter allgroups, SharingSecurityFilter share) {
        this.cd = cd;
        this.onegroup = onegroup;
        this.allgroups = allgroups;
        this.share = share;
    }

    public SecurityFilter choose() {
        EventContext ec = this.cd.getCurrentEventContext();
        Long groupId = ec.getCurrentGroupId();
        Long shareId = ec.getCurrentShareId();
        if (shareId != null && shareId >= 0L) {
            return this.share;
        }
        if (groupId < 0L) {
            return this.allgroups;
        }
        return this.onegroup;
    }

    @Override
    public String getName() {
        return this.choose().getName();
    }

    @Override
    public String getDefaultCondition() {
        return this.choose().getDefaultCondition();
    }

    @Override
    public Map<String, String> getParameterTypes() {
        return this.choose().getParameterTypes();
    }

    @Override
    public void enable(Session sess, EventContext ec) {
        this.choose().enable(sess, ec);
    }

    @Override
    public void disable(Session sess) {
        this.choose().disable(sess);
    }

    @Override
    public boolean passesFilter(Session s, Details d, EventContext c) {
        return this.choose().passesFilter(s, d, c);
    }
}

