/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.Collection;
import java.util.Collections;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightAdminPrivilegesCleanup
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightAdminPrivilegesCleanup.class);
    private final SqlAction sqlAction;
    private final long halfDelayMs;
    private long latestRunEnded = Long.MIN_VALUE;
    private Collection<Long> transactionIds = Collections.emptyList();

    public LightAdminPrivilegesCleanup(SqlAction sqlAction, int delay) {
        this.sqlAction = sqlAction;
        this.halfDelayMs = 500L * (long)delay;
    }

    @Override
    public void run() {
        if (this.latestRunEnded + this.halfDelayMs >= System.currentTimeMillis()) {
            LOGGER.debug("skipping periodic cleanup of _current_admin_privileges table");
            return;
        }
        LOGGER.debug("running periodic cleanup of _current_admin_privileges table");
        this.sqlAction.deleteOldAdminPrivileges(this.transactionIds);
        this.transactionIds = this.sqlAction.findOldAdminPrivileges();
        this.latestRunEnded = System.currentTimeMillis();
    }
}

