/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import ome.conditions.SecurityViolation;
import ome.model.IEnum;
import ome.model.IObject;
import ome.model.meta.Event;
import ome.security.basic.CurrentDetails;
import ome.security.basic.TokenHolder;
import ome.tools.hibernate.HibernateUtils;
import ome.util.Utils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.MergeEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.ForeignKeyDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.IdTransferringMergeEventListener;
import org.springframework.util.Assert;

public class MergeEventListener
extends IdTransferringMergeEventListener {
    public static final String MERGE_EVENT = "MergeEvent";
    private static final long serialVersionUID = 240558701677298961L;
    private static Logger log = LoggerFactory.getLogger(MergeEventListener.class);
    private final CurrentDetails cd;
    private final TokenHolder th;

    public MergeEventListener(CurrentDetails cd, TokenHolder th) {
        Assert.notNull((Object)cd);
        Assert.notNull((Object)th);
        this.cd = cd;
        this.th = th;
    }

    public void onMerge(MergeEvent event) throws HibernateException {
        if (this.cd.isDisabled(MERGE_EVENT)) {
            throw new SecurityViolation("The MergeEventListener has been disabled.");
        }
        if (this.earlyExit(event)) {
            return;
        }
        super.onMerge(event);
    }

    public void onMerge(MergeEvent event, Map copyCache) throws HibernateException {
        if (this.cd.isDisabled(MERGE_EVENT)) {
            throw new SecurityViolation("The MergeEventListener has been disabled.");
        }
        if (this.earlyExit(event)) {
            return;
        }
        super.onMerge(event, copyCache);
    }

    private boolean earlyExit(MergeEvent event) {
        IObject iobject;
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        if (entity instanceof IObject && !(iobject = (IObject)entity).isLoaded()) {
            log.trace("ignoring unloaded iobject");
            event.setResult(source.load(event.getEntityName(), (Serializable)iobject.getId()));
            return true;
        }
        return false;
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache) {
        if (entity instanceof IObject) {
            HibernateUtils.fixNulledOrFilteredCollections((IObject)entity, (IObject)target, persister, source);
            this.propagateHiddenValues((IObject)entity, (IObject)target);
        }
        super.copyValues(persister, entity, target, source, copyCache);
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        if (entity instanceof IObject) {
            HibernateUtils.fixNulledOrFilteredCollections((IObject)entity, (IObject)target, persister, source);
            this.propagateHiddenValues((IObject)entity, (IObject)target);
        }
        super.copyValues(persister, entity, target, source, copyCache, foreignKeyDirection);
    }

    protected void entityIsTransient(MergeEvent event, Map copyCache) {
        Class<?> cls = event.getOriginal().getClass();
        IEnum extant = null;
        if (IEnum.class.isAssignableFrom(cls)) {
            String value = ((IEnum)event.getOriginal()).getValue();
            Class<?> type = ((IEnum)event.getOriginal()).getClass();
            Criteria c = event.getSession().createCriteria(type).add((Criterion)Restrictions.eq((String)"value", (Object)value));
            extant = (IEnum)c.uniqueResult();
            if (null != extant) {
                this.log("Using existing Enum(", event.getEntityName(), ") with value:", value);
                copyCache.put(event.getEntity(), extant);
                event.setResult((Object)extant);
            }
        }
        if (extant == null) {
            super.entityIsTransient(event, copyCache);
        }
        this.fillReplacement(event);
    }

    protected void entityIsDetached(MergeEvent event, Map copyCache) {
        IObject orig = (IObject)event.getOriginal();
        EventSource source = event.getSession();
        if (HibernateUtils.isUnloaded(orig)) {
            this.log("Reloading unloaded entity:", event.getEntityName(), ":", orig.getId());
            Class k = Utils.trueClass(orig.getClass());
            Object obj = source.load(k, (Serializable)orig.getId());
            event.setResult(obj);
            copyCache.put(event.getEntity(), obj);
        } else if (orig instanceof Event) {
            Object obj = source.load(Event.class, (Serializable)orig.getId());
            event.setResult(obj);
            copyCache.put(event.getEntity(), obj);
        } else {
            super.entityIsDetached(event, copyCache);
        }
        this.fillReplacement(event);
    }

    protected void fillReplacement(MergeEvent event) {
        if (event.getOriginal() instanceof IObject) {
            IObject obj = (IObject)event.getOriginal();
            obj.getGraphHolder().setReplacement((IObject)event.getResult());
        }
    }

    protected void propagateHiddenValues(IObject from, IObject to) {
        this.th.copyToken(from, to);
        if (from.getDetails() != null && from.getDetails().filteredSize() > 0) {
            to.getDetails().addFiltered((Collection)from.getDetails().filteredSet());
        }
    }

    private void log(Object ... objects) {
        if (log.isDebugEnabled() && objects != null && objects.length > 0) {
            StringBuilder sb = new StringBuilder(objects.length * 16);
            for (Object obj : objects) {
                sb.append(obj == null ? "null" : obj.toString());
            }
            log.debug(sb.toString());
        }
    }
}

