/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.model.IObject;
import ome.model.meta.Node;
import ome.parameters.Filter;
import ome.parameters.Parameters;
import ome.security.NodeProvider;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import org.hibernate.Session;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class NodeProviderInDb
implements NodeProvider,
ReadOnlyStatus.IsAware {
    public final String uuid;
    private final Executor executor;
    private final Principal principal;

    public NodeProviderInDb(String uuid, Executor executor) {
        this.uuid = uuid;
        this.executor = executor;
        this.principal = new Principal(uuid, "system", "Internal");
    }

    @Override
    public Principal principal() {
        return this.principal;
    }

    @Override
    public long getManagerIdByUuid(String managerUuid, SqlAction sql) {
        try {
            return sql.nodeId(managerUuid);
        }
        catch (EmptyResultDataAccessException erdae) {
            return 0L;
        }
    }

    @Override
    public Node getManagerByUuid(String managerUuid, ServiceFactory sf) {
        Parameters p = new Parameters();
        p.addString("uuid", managerUuid).setFilter(new Filter().page(Integer.valueOf(0), Integer.valueOf(1)));
        return (Node)sf.getQueryService().findByQuery("select n from Node n where uuid = :uuid", p);
    }

    @Override
    public Set<String> getManagerList(final boolean onlyActive) {
        return (Set)this.executor.execute(this.principal, new Executor.SimpleWork(this, "getManagerList", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List nodes = sf.getQueryService().findAll(Node.class, null);
                HashSet<String> nodeIds = new HashSet<String>();
                for (Node node : nodes) {
                    if (onlyActive && node.getDown() != null) continue;
                    nodeIds.add(node.getUuid());
                }
                return nodeIds;
            }
        });
    }

    @Override
    public int closeSessionsForManager(final String managerUuid) {
        return (Integer)this.executor.execute(this.principal, new Executor.SimpleWork(this, "executeUpdate - set closed = now()", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return this.getSqlAction().closeNodeSessions(managerUuid);
            }
        });
    }

    @Override
    public void setManagerDown(final String managerUuid) {
        this.executor.execute(this.principal, new Executor.SimpleWork(this, "setManagerDown", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return this.getSqlAction().closeNode(managerUuid);
            }
        });
    }

    @Override
    public Node addManager(String managerUuid, String proxyString) {
        final Node node = new Node();
        node.setConn(proxyString);
        node.setUuid(managerUuid);
        node.setUp(new Timestamp(System.currentTimeMillis()));
        return (Node)this.executor.execute(this.principal, new Executor.SimpleWork(this, "addManager", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getUpdateService().saveAndReturnObject((IObject)node);
            }
        });
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return readOnly.isReadOnlyDb();
    }
}

