/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class SVGRasterizer {
    protected TranscoderInput input;
    protected TranscodingHints hints = new TranscodingHints();
    protected BufferedImage img;

    public SVGRasterizer(String uri) {
        this.input = new TranscoderInput(uri);
    }

    public SVGRasterizer(URL url) {
        this.input = new TranscoderInput(url.toString());
    }

    public SVGRasterizer(InputStream istream) {
        this.input = new TranscoderInput(istream);
    }

    public SVGRasterizer(Reader reader) {
        this.input = new TranscoderInput(reader);
    }

    public BufferedImage createBufferedImage() throws TranscoderException {
        Rasterizer r = new Rasterizer();
        r.setTranscodingHints((Map)this.hints);
        r.transcode(this.input, null);
        return this.img;
    }

    public void createJPEG(OutputStream outputStream) throws TranscoderException {
        JPEGTranscoder t = new JPEGTranscoder();
        t.setTranscodingHints((Map)this.hints);
        TranscoderOutput output = new TranscoderOutput(outputStream);
        t.transcode(this.input, output);
    }

    public void setQuality(float quality) {
        this.hints.put((Object)JPEGTranscoder.KEY_QUALITY, (Object)Float.valueOf(quality));
    }

    public void setImageWidth(float width) {
        this.hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
    }

    public void setImageHeight(float height) {
        this.hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
    }

    public void setLanguages(String language) {
        this.hints.put((Object)ImageTranscoder.KEY_LANGUAGE, (Object)language);
    }

    public void setPixelToMMFactor(float px2mm) {
        this.hints.put((Object)ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(px2mm));
    }

    public void setUserStyleSheetURI(String uri) {
        this.hints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)uri);
    }

    public void setXMLParserValidating(boolean b) {
        this.hints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setMedia(String media) {
        this.hints.put((Object)ImageTranscoder.KEY_MEDIA, (Object)media);
    }

    public void setAlternateStylesheet(String alternateStylesheet) {
        this.hints.put((Object)ImageTranscoder.KEY_ALTERNATE_STYLESHEET, (Object)alternateStylesheet);
    }

    public void setBackgroundColor(Paint p) {
        this.hints.put((Object)ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)p);
    }

    protected class Rasterizer
    extends ImageTranscoder {
        protected Rasterizer() {
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            SVGRasterizer.this.img = img;
        }
    }
}

