/*
 * Decompiled with CFR 0.152.
 */
package ome.services.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import ome.conditions.DatabaseBusyException;
import ome.util.messages.UserSignalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class SelfCorrectingDataSource
extends DelegatingDataSource
implements ApplicationListener<UserSignalMessage> {
    private static final Logger log = LoggerFactory.getLogger(SelfCorrectingDataSource.class);
    private final long errorTimeout;
    private final int maxRetries;
    private final long maxBackOff;
    private final List<Long> errorTimes = new ArrayList<Long>();

    public SelfCorrectingDataSource(DataSource delegate, long timeoutInMilliseconds) {
        this(delegate, timeoutInMilliseconds, 3, 10000L);
    }

    public SelfCorrectingDataSource(DataSource delegate, long timeoutInMilliseconds, int maxRetries, long maxBackOff) {
        super(delegate);
        this.errorTimeout = timeoutInMilliseconds;
        this.maxRetries = maxRetries;
        this.maxBackOff = maxBackOff;
    }

    public Connection getConnection() throws SQLException {
        return this.callWithRetries(null, null, false);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.callWithRetries(username, password, true);
    }

    public void onApplicationEvent(UserSignalMessage usm) {
        if (usm.signal == 1) {
            log.info("Received USR" + usm.signal + " - calling close()");
            try {
                Method m = this.getTargetDataSource().getClass().getMethod("close", new Class[0]);
                m.invoke((Object)this.getTargetDataSource(), new Object[0]);
            }
            catch (Exception e) {
                log.error("Failed to close " + this.getTargetDataSource(), (Throwable)e);
            }
        }
    }

    protected Connection callWithRetries(String username, String password, boolean useArgs) throws SQLException {
        int retries = 0;
        while (true) {
            try {
                return this.call(username, password, useArgs);
            }
            catch (SQLException sql) {
                long backOff;
                block6: {
                    backOff = this.markAndSweep();
                    if (++retries < this.maxRetries) {
                        log.info("Sleeping for " + backOff + " then retry: " + retries);
                        try {
                            Thread.sleep(backOff);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break block6;
                        }
                        continue;
                    }
                }
                log.error("Failed to acquire connection after retries=" + this.maxRetries, (Throwable)sql);
                throw new DatabaseBusyException("Cannot acquire connection", backOff);
            }
            break;
        }
    }

    protected Connection call(String username, String password, boolean useArgs) throws SQLException {
        if (useArgs) {
            return super.getConnection(username, password);
        }
        return super.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long markAndSweep() {
        long timeAgo = System.currentTimeMillis() - this.errorTimeout;
        List<Long> list = this.errorTimes;
        synchronized (list) {
            int location = Collections.binarySearch(this.errorTimes, timeAgo);
            log.info("Found location in errorTimes: " + location);
            if (location < 0) {
                location = -location - 1;
            }
            ArrayList<Long> subList = new ArrayList<Long>(this.errorTimes.subList(location, this.errorTimes.size()));
            int eSize = this.errorTimes.size();
            int sSize = subList.size();
            log.info("Removing " + (eSize - sSize) + " from errorTimes");
            this.errorTimes.clear();
            this.errorTimes.addAll(subList);
            log.warn("Registering error with list: Current size: " + sSize);
            this.errorTimes.add(System.currentTimeMillis());
            return this.calculateBackOff(sSize);
        }
    }

    protected long calculateBackOff(int numberOfErrors) {
        long backOff = 1000L * Math.round(Math.sqrt(numberOfErrors));
        if (backOff > this.maxBackOff) {
            return this.maxBackOff;
        }
        return backOff;
    }
}

