/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete.files;

import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ome.io.nio.AbstractFileSystemService;
import ome.services.delete.files.OriginalFileDeletions;
import ome.services.delete.files.PixelsFileDeletions;
import ome.services.delete.files.ThumbnailFileDeletions;
import ome.system.OmeroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDeleter {
    private static final Logger log = LoggerFactory.getLogger(FileDeleter.class);
    private OmeroContext ctx;
    private final AbstractFileSystemService afs;
    private final SetMultimap<String, Long> deleteTargets;
    private OriginalFileDeletions originalFD;
    private ThumbnailFileDeletions thumbFD;
    private PixelsFileDeletions pixelsFD;
    private HashMap<String, long[]> undeletedFiles;
    private int filesFailed = 0;
    private long bytesFailed = 0L;

    public FileDeleter(OmeroContext ctx, AbstractFileSystemService afs, SetMultimap<String, Long> deleteTargets) {
        this.ctx = ctx;
        this.afs = afs;
        this.deleteTargets = deleteTargets;
    }

    public void run() {
        this.originalFD = new OriginalFileDeletions(this.afs, this.load(Type.OriginalFile), this.ctx);
        this.filesFailed += this.originalFD.deleteLocal();
        this.bytesFailed += this.originalFD.getBytesFailed();
        this.thumbFD = new ThumbnailFileDeletions(this.afs, this.load(Type.Thumbnail));
        this.filesFailed += this.thumbFD.deleteLocal();
        this.bytesFailed += this.thumbFD.getBytesFailed();
        this.pixelsFD = new PixelsFileDeletions(this.afs, this.load(Type.Pixels));
        this.filesFailed += this.pixelsFD.deleteLocal();
        this.bytesFailed += this.pixelsFD.getBytesFailed();
        this.undeletedFiles = new HashMap();
        this.undeletedFiles.put(Type.OriginalFile.toString(), this.originalFD.getUndeletedFiles());
        this.undeletedFiles.put(Type.Thumbnail.toString(), this.thumbFD.getUndeletedFiles());
        this.undeletedFiles.put(Type.Pixels.toString(), this.pixelsFD.getUndeletedFiles());
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, long[]> undeletedFilesOneClass : this.undeletedFiles.entrySet()) {
                String className = undeletedFilesOneClass.getKey();
                long[] ids = undeletedFilesOneClass.getValue();
                if (ids.length <= 0) continue;
                log.debug("Failed to delete files : " + className + ":" + Arrays.toString(ids));
            }
        }
    }

    protected Set<Long> load(Type fileType) {
        return this.deleteTargets.get((Object)fileType.toString());
    }

    public HashMap<String, long[]> getUndeletedFiles() {
        return this.undeletedFiles;
    }

    public int getFailedFilesCount() {
        return this.filesFailed;
    }

    public String getWarning() {
        return String.format("Warning: %s file(s) comprising %s bytes were not removed", this.filesFailed, this.bytesFailed);
    }

    static enum Type {
        OriginalFile,
        Pixels,
        Thumbnail;

    }
}

