/*
 * Decompiled with CFR 0.152.
 */
package ome.services.mail;

import java.util.Collections;
import java.util.Set;
import ome.services.mail.MailSender;
import ome.services.messages.LoginAttemptMessage;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ApplicationListener;

public class FailedLoginMailSender
extends MailSender
implements ApplicationListener<LoginAttemptMessage> {
    private boolean contactUser;
    private boolean contactSystem;
    private boolean onAllUsers;
    private Set<String> onSpecificUsers;

    public void setContactUser(boolean contactUser) {
        this.contactUser = contactUser;
    }

    public void setContactSystem(boolean contactSystem) {
        this.contactSystem = contactSystem;
    }

    public void setOnAllUsers(boolean onAllUsers) {
        this.onAllUsers = onAllUsers;
    }

    public void setOnSpecificUsers(Set<String> onSpecificUsers) {
        this.onSpecificUsers = onSpecificUsers;
    }

    public void onApplicationEvent(LoginAttemptMessage lam) {
        boolean hasSpecific;
        if (!this.isEnabled()) {
            return;
        }
        if (lam.success == null || lam.success.booleanValue()) {
            return;
        }
        String subj = String.format("Login failed for '%s'", lam.user);
        boolean bl = hasSpecific = !CollectionUtils.isEmpty(this.onSpecificUsers) && this.onSpecificUsers.contains(lam.user);
        if (this.onAllUsers || hasSpecific) {
            if (this.contactSystem) {
                this.sendBlind(this.getAllSystemUsers(false), subj);
            }
            if (this.contactUser) {
                this.sendBlind(Collections.singleton(this.getUserEmail(lam.user)), subj);
            }
        }
    }
}

