/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.sql.SQLException;
import java.util.Collection;
import ome.conditions.ApiUsageException;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.parameters.Parameters;
import ome.services.query.AbstractClassIdsOptionsQuery;
import ome.tools.hibernate.QueryBuilder;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class PojosGetImagesQueryDefinition
extends AbstractClassIdsOptionsQuery {
    public PojosGetImagesQueryDefinition(Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void buildQuery(Session session) throws HibernateException, SQLException {
        Class klass = (Class)this.value("class");
        Collection ids = (Collection)this.value("ids");
        QueryBuilder qb = new QueryBuilder();
        qb.select("img");
        qb.from("Image", "img");
        qb.join("img.details.creationEvent", "ce", true, true);
        qb.join("img.details.updateEvent", "ue", true, true);
        qb.join("img.pixels", "pix", true, true);
        qb.join("pix.timeIncrement", "increment", true, true);
        qb.join("pix.pixelsType", "pt", true, true);
        qb.join("img.format", "format", true, true);
        qb.join("img.annotationLinksCountPerOwner", "i_c_ann", true, true);
        qb.join("img.datasetLinksCountPerOwner", "i_c_ds", true, true);
        if (this.params.isAcquisitionData()) {
            qb.join("img.stageLabel", "position", true, true);
            qb.join("img.imagingEnvironment", "condition", true, true);
            qb.join("img.objectiveSettings", "os", true, true);
            qb.join("os.medium", "me", true, true);
            qb.join("os.objective", "objective", true, true);
            qb.join("objective.immersion", "im", true, true);
            qb.join("objective.correction", "co", true, true);
        }
        if (Image.class.isAssignableFrom(klass)) {
            qb.where();
            qb.and("img.id in (:ids)");
        } else if (Dataset.class.isAssignableFrom(klass)) {
            qb.join("img.datasetLinks", "dil", false, false);
            qb.join("dil.parent", "ds", false, false);
            qb.where();
            qb.and("ds.id in (:ids)");
        } else if (Project.class.isAssignableFrom(klass)) {
            qb.join("img.datasetLinks", "dil", false, false);
            qb.join("dil.parent", "ds", false, false);
            qb.join("ds.projectLinks", "pdl", false, false);
            qb.join("pdl.parent", "prj", false, false);
            qb.where();
            qb.and("prj.id in (:ids)");
        } else {
            throw new ApiUsageException("Query not implemented for " + klass);
        }
        if (this.params.getStartTime() != null) {
            qb.and("img.details.creationEvent.time > :starttime");
            qb.param("starttime", (Object)this.params.getStartTime());
        }
        if (this.params.getEndTime() != null) {
            qb.and("img.details.creationEvent.time < :endtime");
            qb.param("endtime", (Object)this.params.getEndTime());
        }
        qb.paramList("ids", ids);
        Query q = qb.query(session);
        this.setQuery(q);
    }

    @Override
    protected void enableFilters(Session session) {
        this.ownerOrGroupFilters(session, new String[]{"image_owner_filter"}, new String[]{"image_group_filter"});
    }
}

