/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(ThreadPool.class);
    private final Semaphore maxBackground;
    private final long backgroundTimeout;

    public ThreadPool() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.maxBackground = new Semaphore(10);
        this.backgroundTimeout = 3600000L;
    }

    public ThreadPool(int minThreads, int maxThreads, long msTimeout, int backgroundThreads, long backgroundTimeout) {
        super(minThreads, maxThreads, msTimeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.maxBackground = new Semaphore(backgroundThreads);
        this.backgroundTimeout = backgroundTimeout;
        log.info("ThreadPool: normal=(#{}, {}ms), background=(#{}, {}ms)", new Object[]{maxThreads, msTimeout, backgroundThreads, backgroundTimeout});
    }

    @Deprecated
    public ExecutorService getExecutor() {
        return this;
    }

    public <T> Future<T> background(Callable<T> callable) {
        Slf4JStopWatch sw = new Slf4JStopWatch();
        try {
            if (!this.maxBackground.tryAcquire(1, this.backgroundTimeout, TimeUnit.MILLISECONDS)) {
                String msg = String.format("Failed to execute %s after %sms", callable, this.backgroundTimeout);
                log.warn(msg);
                throw new RejectedExecutionException(msg);
            }
            Future<T> msg = this.submit(new BackgroundCallable<T>(callable));
            return msg;
        }
        catch (InterruptedException e) {
            String msg = String.format("Interrupted while waiting to execute %s", callable);
            log.warn(msg);
            throw new RejectedExecutionException(msg);
        }
        finally {
            sw.stop("omero.background.submit");
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof BackgroundCallable) {
            BackgroundCallable background = (BackgroundCallable)callable;
            return new BackgroundFutureTask(background.delegate);
        }
        return super.newTaskFor(callable);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            if (r instanceof BackgroundFutureTask) {
                this.maxBackground.release();
                ((BackgroundFutureTask)r).sw.stop("omero.background.task");
            }
        }
        finally {
            super.afterExecute(r, t);
        }
    }

    private static class BackgroundFutureTask<T extends FutureTask<T>>
    extends FutureTask<T> {
        StopWatch sw = new Slf4JStopWatch();

        public BackgroundFutureTask(Callable<T> callable) {
            super(callable);
        }
    }

    private static class BackgroundCallable<T extends Callable<T>>
    implements Callable<T> {
        Callable<T> delegate;

        BackgroundCallable(Callable<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T call() throws Exception {
            return (T)((Callable)this.delegate.call());
        }
    }
}

