/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import ome.model.internal.Details;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.parameters.Parameters;

public class SearchValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    public boolean caseSensitive = false;
    public int batchSize = 1000;
    public boolean mergedBatches = false;
    public boolean returnUnloaded = false;
    public boolean useProjections = false;
    public boolean leadingWildcard = false;
    public boolean idOnly = false;
    public List<Class> fetchAnnotations = new ArrayList<Class>();
    public List<String> fetches = new ArrayList<String>();
    public List<String> orderBy = new ArrayList<String>();
    public Timestamp createdStart = null;
    public Timestamp createdStop = null;
    public Timestamp modifiedStart = null;
    public Timestamp modifiedStop = null;
    public Timestamp annotatedStart = null;
    public Timestamp annotatedStop = null;
    public List<Long> onlyIds = null;
    public List<Class> onlyTypes = null;
    public List<Class> onlyAnnotatedWith = null;
    public Details ownedBy = null;
    public Details notOwnedBy = null;
    public Details annotatedBy = null;
    public Details notAnnotatedBy = null;

    public void copy(SearchValues values) {
        this.caseSensitive = values.caseSensitive;
        this.batchSize = values.batchSize;
        this.mergedBatches = values.mergedBatches;
        this.returnUnloaded = values.returnUnloaded;
        this.useProjections = values.useProjections;
        this.leadingWildcard = values.leadingWildcard;
        this.idOnly = values.idOnly;
        this.fetchAnnotations = new ArrayList<Class>(values.fetchAnnotations);
        this.fetches = new ArrayList<String>(values.fetches);
        this.orderBy = new ArrayList<String>(values.orderBy);
        this.createdStart = SearchValues.copyTimestamp(values.createdStart);
        this.createdStop = SearchValues.copyTimestamp(values.createdStop);
        this.modifiedStart = SearchValues.copyTimestamp(values.modifiedStart);
        this.modifiedStop = SearchValues.copyTimestamp(values.modifiedStop);
        this.annotatedStart = SearchValues.copyTimestamp(values.annotatedStart);
        this.annotatedStop = SearchValues.copyTimestamp(values.annotatedStop);
        this.onlyIds = SearchValues.copyList(values.onlyIds);
        this.onlyTypes = SearchValues.copyList(values.onlyTypes);
        this.onlyAnnotatedWith = SearchValues.copyList(values.onlyAnnotatedWith);
        this.ownedBy = SearchValues.copyDetails(values.ownedBy);
        this.annotatedBy = SearchValues.copyDetails(values.annotatedBy);
        this.notOwnedBy = SearchValues.copyDetails(values.notOwnedBy);
        this.notAnnotatedBy = SearchValues.copyDetails(values.notAnnotatedBy);
    }

    public void copy(Parameters params) {
        if (params != null) {
            if (params.getLimit() != null) {
                this.batchSize = params.getLimit();
            }
            if (params.owner() >= 0L) {
                this.ownedBy = Details.create();
                this.ownedBy.setOwner(new Experimenter(Long.valueOf(params.owner()), false));
            } else if (params.group() >= 0L) {
                this.ownedBy = Details.create();
                this.ownedBy.setGroup(new ExperimenterGroup(Long.valueOf(params.group()), false));
            }
        }
    }

    public static <T> List<T> copyList(List<T> old) {
        if (old == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(old);
        return list;
    }

    public static Details copyDetails(Details old) {
        Details d;
        Details details = d = old == null ? null : Details.create();
        if (d != null) {
            d.copy(old);
        }
        return d;
    }

    public static Timestamp copyTimestamp(Timestamp old) {
        Timestamp t = old == null ? null : new Timestamp(old.getTime());
        return t;
    }

    public static Class[] copyClassListToArray(List<Class> old) {
        if (old == null) {
            return new Class[0];
        }
        return old.toArray(new Class[0]);
    }
}

