/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ome.model.IEnum;
import ome.model.IGlobal;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class EnsureEnum {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnsureEnum.class);
    private final Executor executor;
    private final Principal principal;
    private final Map<String, String> callContext;
    private final boolean isReadOnlyDb;

    public EnsureEnum(Executor executor, String uuid, Roles roles, ReadOnlyStatus readOnly) {
        this.executor = executor;
        this.principal = new Principal(uuid, roles.getSystemGroupName(), "Internal");
        this.callContext = ImmutableMap.of((Object)"omero.group", (Object)Long.toString(roles.getUserGroupId()));
        this.isReadOnlyDb = readOnly.isReadOnlyDb();
    }

    private static <E extends IEnum & IGlobal> Long ensure(Session session, Class<E> enumClass, String enumValue) {
        IEnum instance = (IEnum)session.createCriteria(enumClass).add((Criterion)Restrictions.eq((String)"value", (Object)enumValue)).uniqueResult();
        if (instance != null) {
            return instance.getId();
        }
        String prettyEnum = enumClass.getSimpleName() + '.' + enumValue;
        try {
            instance = (IEnum)enumClass.getConstructor(String.class).newInstance(enumValue);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            LOGGER.error("failed to create enumeration value " + prettyEnum, (Throwable)e);
            return null;
        }
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            LOGGER.warn("no enumeration value {} but database is read-only", (Object)prettyEnum);
            return null;
        }
        LOGGER.info("adding to database new enumeration value " + prettyEnum);
        return (Long)session.save((Object)instance);
    }

    public <E extends IEnum & IGlobal> List<Long> ensure(final Class<E> enumClass, final Collection<String> enumValues) {
        if (enumValues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.isReadOnlyDb ? this.executor.execute(this.callContext, this.principal, new FetchEnums<E>(){

            @Override
            public String description() {
                return "check enum values (ro)";
            }

            @Override
            @Transactional(readOnly=true)
            public List<Long> doWork(Session session, ServiceFactory sf) {
                return this.innerWork(session, enumClass, enumValues);
            }
        }) : this.executor.execute(this.callContext, this.principal, new FetchEnums<E>(){

            @Override
            public String description() {
                return "ensure enum values (rw)";
            }

            @Override
            @Transactional(readOnly=false)
            public List<Long> doWork(Session session, ServiceFactory sf) {
                return this.innerWork(session, enumClass, enumValues);
            }
        });
    }

    private static abstract class FetchEnums<E extends IEnum & IGlobal>
    implements Executor.LoggedWork<List<Long>> {
        private FetchEnums() {
        }

        protected List<Long> innerWork(Session session, Class<E> enumClass, Collection<String> enumValues) {
            ArrayList<Long> enumIds = new ArrayList<Long>(enumValues.size());
            for (String enumValue : enumValues) {
                enumIds.add(EnsureEnum.ensure(session, enumClass, enumValue));
            }
            return enumIds;
        }
    }
}

