/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import ome.conditions.ApiUsageException;
import ome.model.IEnum;
import ome.model.IObject;
import ome.tools.hibernate.UpdateFilter;
import ome.util.Filterable;
import org.hibernate.Query;
import org.hibernate.Session;

public class ReloadFilter
extends UpdateFilter {
    private final Session session;
    private final Map<Class, Map<String, IEnum>> enumsMap = new HashMap<Class, Map<String, IEnum>>();

    public ReloadFilter(Session s) {
        this.session = s;
    }

    @Override
    public Filterable filter(String fieldId, Filterable f) {
        if (this.session.contains((Object)f)) {
            return f;
        }
        if (f instanceof IObject) {
            IObject o = (IObject)f;
            if (!o.isLoaded()) {
                return (IObject)this.session.get(o.getClass(), (Serializable)o.getId());
            }
            if (f instanceof IEnum) {
                IEnum enu;
                IEnum e = (IEnum)f;
                String val = e.getValue();
                Map<String, IEnum> enums = this.enumsMap.get(f.getClass());
                if (enums != null && (enu = enums.get(val)) != null) {
                    return enu;
                }
                Query q = this.session.createQuery(String.format("select e from %s e where e.value = :val", f.getClass().getName()));
                q.setString("val", val);
                IEnum existing = (IEnum)q.uniqueResult();
                if (existing != null) {
                    enums = this.enumsMap.get(f.getClass());
                    if (enums == null) {
                        enums = new HashMap<String, IEnum>();
                        this.enumsMap.put(f.getClass(), enums);
                    }
                    enums.put(val, existing);
                    return existing;
                }
            }
            if (o.getId() != null) {
                throw new ApiUsageException("INSERTs only! Pass only new objects, enums, or unloaded objects to this method.");
            }
        }
        return super.filter(fieldId, f);
    }
}

