/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import hdf.hdf5lib.H5;

public class HDF5DataSetTemplate
implements AutoCloseable {
    private final HDF5StorageLayout layout;
    private final long[] dimensions;
    private final long[] maxDimensions;
    private final long dataSetCreationPropertyListId;
    private final boolean closeCreationPropertyListId;
    private final long storageDataTypeId;
    private long dataspaceId;

    HDF5DataSetTemplate(long dataspaceId, long dataSetCreationPropertyListId, boolean closeCreationPropertyListId, long storageDataTypeId, long[] dimensions, long[] maxDimensions, HDF5StorageLayout layout) {
        this.dataspaceId = dataspaceId;
        this.dataSetCreationPropertyListId = dataSetCreationPropertyListId;
        this.closeCreationPropertyListId = closeCreationPropertyListId;
        this.storageDataTypeId = storageDataTypeId;
        this.dimensions = dimensions;
        this.maxDimensions = maxDimensions;
        this.layout = layout;
    }

    long getDataspaceId() {
        return this.dataspaceId;
    }

    long getDataSetCreationPropertyListId() {
        return this.dataSetCreationPropertyListId;
    }

    long getStorageDataTypeId() {
        return this.storageDataTypeId;
    }

    long[] getDimensions() {
        return this.dimensions;
    }

    long[] getMaxDimensions() {
        return this.maxDimensions;
    }

    HDF5StorageLayout getLayout() {
        return this.layout;
    }

    @Override
    public void close() {
        if (this.dataspaceId > 0L) {
            H5.H5Sclose(this.dataspaceId);
            this.dataspaceId = -1L;
            if (this.closeCreationPropertyListId) {
                H5.H5Pclose(this.dataSetCreationPropertyListId);
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)this.dataspaceId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5DataSetTemplate other = (HDF5DataSetTemplate)obj;
        return this.dataspaceId == other.dataspaceId;
    }
}

