/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5StringReader;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.Iterator;

public class HDF5StringReader
implements IHDF5StringReader {
    private final HDF5BaseReader baseReader;

    HDF5StringReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public String getAttr(String objectPath, String attributeName) {
        return this.getStringAttribute(objectPath, attributeName, false);
    }

    @Override
    public String getAttrRaw(String objectPath, String attributeName) {
        return this.getStringAttribute(objectPath, attributeName, true);
    }

    String getStringAttribute(final String objectPath, final String attributeName, final boolean readRaw) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                long objectId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openObject(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                return HDF5StringReader.this.baseReader.getStringAttribute(objectId, objectPath, attributeName, readRaw, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String[] getArrayAttr(String objectPath, String attributeName) {
        return this.getStringArrayAttribute(objectPath, attributeName, false);
    }

    @Override
    public String[] getArrayAttrRaw(String objectPath, String attributeName) {
        return this.getStringArrayAttribute(objectPath, attributeName, true);
    }

    String[] getStringArrayAttribute(final String objectPath, final String attributeName, final boolean readRaw) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> readRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                long objectId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openObject(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                return HDF5StringReader.this.baseReader.getStringArrayAttribute(objectId, objectPath, attributeName, readRaw, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public MDArray<String> getMDArrayAttr(String objectPath, String attributeName) {
        return this.getStringMDArrayAttribute(objectPath, attributeName, false);
    }

    @Override
    public MDArray<String> getMDArrayAttrRaw(String objectPath, String attributeName) {
        return this.getStringMDArrayAttribute(objectPath, attributeName, true);
    }

    MDArray<String> getStringMDArrayAttribute(final String objectPath, final String attributeName, final boolean readRaw) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readRunnable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                long objectId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openObject(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                return HDF5StringReader.this.baseReader.getStringMDArrayAttribute(objectId, objectPath, attributeName, readRaw, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String read(String objectPath) throws HDF5JavaException {
        return this.readString(objectPath, false);
    }

    @Override
    public String readRaw(String objectPath) throws HDF5JavaException {
        return this.readString(objectPath, true);
    }

    String readString(final String objectPath, final boolean readRaw) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> writeRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                boolean isString;
                long dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                long dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                if (!isString) {
                    throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                }
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    String[] data = new String[1];
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, data);
                    return data[0];
                }
                int size = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataTypeSize(dataTypeId);
                CharacterEncoding encoding = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getCharacterEncoding(dataTypeId);
                byte[] data = new byte[size];
                ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, dataTypeId, data);
                return readRaw ? StringUtils.fromBytes(data, encoding) : StringUtils.fromBytes0Term(data, encoding);
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public String[] readArrayRaw(String objectPath) throws HDF5JavaException {
        return this.readStringArray(objectPath, true);
    }

    @Override
    public String[] readArray(String objectPath) throws HDF5JavaException {
        return this.readStringArray(objectPath, false);
    }

    String[] readStringArray(final String objectPath, final boolean readRaw) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> writeRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                long[] dimensions = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataDimensions(dataSetId, registry);
                int oneDimSize = HDF5Utils.getOneDimensionalArraySize(dimensions);
                String[] data = new String[oneDimSize];
                long dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, data);
                } else {
                    byte[] bdata;
                    int strLength;
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    if (readRaw) {
                        strLength = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataTypeSize(dataTypeId);
                        bdata = new byte[oneDimSize * strLength];
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, dataTypeId, bdata);
                    } else {
                        strLength = -1;
                        bdata = null;
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, data);
                    }
                    if (bdata != null && readRaw) {
                        CharacterEncoding encoding = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getCharacterEncoding(dataTypeId);
                        int i = 0;
                        int startIdx = 0;
                        while (i < oneDimSize) {
                            data[i] = StringUtils.fromBytes(bdata, startIdx, startIdx + strLength, encoding);
                            ++i;
                            startIdx += strLength;
                        }
                    }
                }
                return data;
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public String[] readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, (long)blockSize * blockNumber);
    }

    @Override
    public String[] readArrayBlockRaw(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffsetRaw(objectPath, blockSize, (long)blockSize * blockNumber);
    }

    String[] readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset, final boolean readRaw) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> readCallable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5StringReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                String[] data = new String[spaceParams.blockSize];
                long dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                } else {
                    byte[] bdata;
                    int strLength;
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    if (readRaw) {
                        strLength = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataTypeSize(dataTypeId);
                        bdata = new byte[spaceParams.blockSize * strLength];
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, bdata);
                    } else {
                        strLength = -1;
                        bdata = null;
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                    }
                    if (bdata != null && readRaw) {
                        CharacterEncoding encoding = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getCharacterEncoding(dataTypeId);
                        int i = 0;
                        int startIdx = 0;
                        while (i < spaceParams.blockSize) {
                            data[i] = StringUtils.fromBytes(bdata, startIdx, startIdx + strLength, encoding);
                            ++i;
                            startIdx += strLength;
                        }
                    }
                }
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public String[] readArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, offset, false);
    }

    @Override
    public String[] readArrayBlockWithOffsetRaw(String objectPath, int blockSize, long offset) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, offset, true);
    }

    @Override
    public MDArray<String> readMDArray(String objectPath) {
        return this.readStringMDArray(objectPath, false);
    }

    @Override
    public MDArray<String> readMDArrayRaw(String objectPath) {
        return this.readStringMDArray(objectPath, true);
    }

    MDArray<String> readStringMDArray(final String objectPath, final boolean readRaw) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readCallable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5StringReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                Object[] data = new String[spaceParams.blockSize];
                long dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, (String[])data);
                } else {
                    byte[] bdata;
                    int strLength;
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    if (readRaw) {
                        strLength = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataTypeSize(dataTypeId);
                        bdata = new byte[spaceParams.blockSize * strLength];
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, dataTypeId, bdata);
                    } else {
                        strLength = -1;
                        bdata = null;
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, (String[])data);
                    }
                    if (bdata != null && readRaw) {
                        CharacterEncoding encoding = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getCharacterEncoding(dataTypeId);
                        int i = 0;
                        int startIdx = 0;
                        while (i < spaceParams.blockSize) {
                            data[i] = StringUtils.fromBytes(bdata, startIdx, startIdx + strLength, encoding);
                            ++i;
                            startIdx += strLength;
                        }
                    }
                }
                return new MDArray(data, spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    MDArray<String> readMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset, final boolean readRaw) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readCallable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5StringReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                Object[] dataBlock = new String[spaceParams.blockSize];
                long dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, (String[])dataBlock);
                } else {
                    int strLength;
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    byte[] bdata = null;
                    if (readRaw) {
                        strLength = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataTypeSize(dataTypeId);
                        bdata = new byte[spaceParams.blockSize * strLength];
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, bdata);
                    } else {
                        strLength = -1;
                        ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, (String[])dataBlock);
                    }
                    if (bdata != null && readRaw) {
                        CharacterEncoding encoding = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getCharacterEncoding(dataTypeId);
                        int i = 0;
                        int startIdx = 0;
                        while (i < spaceParams.blockSize) {
                            dataBlock[i] = StringUtils.fromBytes(bdata, startIdx, startIdx + strLength, encoding);
                            ++i;
                            startIdx += strLength;
                        }
                    }
                }
                return new MDArray(dataBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDArray<String> readMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset, false);
    }

    @Override
    public MDArray<String> readMDArrayBlockWithOffsetRaw(String objectPath, int[] blockDimensions, long[] offset) {
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset, true);
    }

    @Override
    public MDArray<String> readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDArray<String> readMDArrayBlockRaw(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffsetRaw(objectPath, blockDimensions, offset);
    }

    Iterable<HDF5DataBlock<String[]>> getArrayNaturalBlocks(final String dataSetPath, final boolean readRaw) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<String[]>>(){

            @Override
            public Iterator<HDF5DataBlock<String[]>> iterator() {
                return new Iterator<HDF5DataBlock<String[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<String[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        String[] block = readRaw ? HDF5StringReader.this.readArrayBlockWithOffsetRaw(dataSetPath, this.index.getBlockSize(), offset) : HDF5StringReader.this.readArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<String[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.getArrayNaturalBlocks(dataSetPath, false);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getArrayNaturalBlocksRaw(String dataSetPath) throws HDF5JavaException {
        return this.getArrayNaturalBlocks(dataSetPath, true);
    }

    Iterable<HDF5MDDataBlock<MDArray<String>>> getMDArrayNaturalBlocks(final String objectPath, final boolean readRaw) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5MDDataBlock<MDArray<String>>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDArray<String>>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDArray<String>>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDArray<String>> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDArray<String> data = readRaw ? HDF5StringReader.this.readMDArrayBlockWithOffsetRaw(objectPath, this.index.getBlockSize(), offset) : HDF5StringReader.this.readMDArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDArray<String>>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getMDArrayNaturalBlocks(String objectPath) {
        return this.getMDArrayNaturalBlocks(objectPath, false);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getMDArrayNaturalBlocksRaw(String objectPath) {
        return this.getMDArrayNaturalBlocks(objectPath, true);
    }
}

