/*
 * Decompiled with CFR 0.152.
 */
package ome.util.mem;

import java.io.IOException;
import java.io.InputStream;
import ome.util.mem.ReadOnlyByteArray;

public class ByteArray
extends ReadOnlyByteArray {
    public ByteArray(byte[] base, int offset, int length) {
        super(base, offset, length);
    }

    public void set(int index, byte value) {
        this.checkIndex(index);
        this.base[this.offset + index] = value;
    }

    public void set(int index, byte[] buf) {
        if (buf == null) {
            throw new NullPointerException("No buffer.");
        }
        if (buf.length == 0) {
            return;
        }
        this.checkIndex(index);
        this.checkIndex(index + buf.length - 1);
        System.arraycopy(buf, 0, this.base, this.offset + index, buf.length);
    }

    public int set(int index, int maxLength, InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("No stream.");
        }
        if (maxLength <= 0) {
            return 0;
        }
        this.checkIndex(index);
        maxLength = index + maxLength <= this.length ? maxLength : this.length - index;
        return in.read(this.base, this.offset + index, maxLength);
    }
}

