/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.codomain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omeis.providers.re.codomain.CodomainMap;
import omeis.providers.re.codomain.CodomainMapContext;

public class CodomainChain {
    private int[] LUT;
    private List<CodomainMapContext> chain = new ArrayList<CodomainMapContext>();
    private int intervalStart;
    private int intervalEnd;

    private void buildLUT() {
        this.LUT = new int[this.intervalEnd - this.intervalStart + 1];
        for (int x = this.intervalStart; x <= this.intervalEnd; ++x) {
            int v = x;
            for (CodomainMapContext ctx : this.chain) {
                CodomainMap map = ctx.getCodomainMap();
                map.setContext(ctx);
                v = map.transform(v);
            }
            this.LUT[x - this.intervalStart] = v;
        }
    }

    private void verifyInterval(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException(start + " cannot be greater than " + end);
        }
        if (start < 0) {
            throw new IllegalArgumentException(start + " cannot be lower than " + 0);
        }
        if (end > 255) {
            throw new IllegalArgumentException(end + " cannot be greater than " + 255);
        }
    }

    private int verifyInput(int x) {
        if (x < this.intervalStart) {
            x = this.intervalStart;
        } else if (x > this.intervalEnd) {
            x = this.intervalEnd;
        }
        return x;
    }

    public CodomainChain(int start, int end) {
        this(start, end, null);
    }

    public CodomainChain(int start, int end, List<CodomainMapContext> mapContexts) {
        if (mapContexts != null && 0 < mapContexts.size()) {
            for (CodomainMapContext ctx : mapContexts) {
                if (!this.chain.contains(ctx)) {
                    ctx = ctx.copy();
                    this.chain.add(ctx);
                    continue;
                }
                int j = this.chain.indexOf(ctx);
                if (j == -1) continue;
                ctx = ctx.copy();
                this.chain.set(j, ctx);
            }
        }
        this.setInterval(start, end);
    }

    public void setInterval(int start, int end) {
        this.verifyInterval(start, end);
        this.intervalStart = start;
        this.intervalEnd = end;
        for (CodomainMapContext ctx : this.chain) {
            ctx.setCodomain(start, end);
            ctx.buildContext();
        }
        this.buildLUT();
    }

    public int getIntervalEnd() {
        return this.intervalEnd;
    }

    public int getIntervalStart() {
        return this.intervalStart;
    }

    public void remove() {
        this.intervalStart = 0;
        this.intervalEnd = 255;
        this.chain.removeAll(this.chain);
        this.buildLUT();
    }

    public boolean add(CodomainMapContext mapCtx) {
        if (mapCtx == null) {
            throw new NullPointerException("No context.");
        }
        if (this.chain.contains(mapCtx)) {
            this.update(mapCtx);
            return false;
        }
        mapCtx = mapCtx.copy();
        mapCtx.setCodomain(this.intervalStart, this.intervalEnd);
        mapCtx.buildContext();
        this.chain.add(mapCtx);
        this.buildLUT();
        return true;
    }

    public void update(CodomainMapContext mapCtx) {
        if (mapCtx == null) {
            throw new NullPointerException("No context.");
        }
        int i = this.chain.indexOf(mapCtx);
        if (i == -1) {
            throw new IllegalArgumentException("No such a context.");
        }
        mapCtx = mapCtx.copy();
        mapCtx.setCodomain(this.intervalStart, this.intervalEnd);
        mapCtx.buildContext();
        this.chain.set(i, mapCtx);
        this.buildLUT();
    }

    public boolean remove(CodomainMapContext mapCtx) {
        if (mapCtx != null && this.chain.contains(mapCtx)) {
            this.chain.remove(mapCtx);
            this.buildLUT();
            return true;
        }
        return false;
    }

    public int transform(int x) {
        int y = this.verifyInput(x);
        return this.LUT[y - this.intervalStart];
    }

    public boolean hasMapContext() {
        return !this.chain.isEmpty();
    }

    public List<CodomainMapContext> getContexts() {
        Iterator<CodomainMapContext> i = this.chain.iterator();
        ArrayList<CodomainMapContext> contexts = new ArrayList<CodomainMapContext>();
        while (i.hasNext()) {
            contexts.add(i.next().copy());
        }
        return contexts;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator<CodomainMapContext> i = this.chain.iterator();
        int n = this.chain.size();
        int j = 1;
        while (i.hasNext()) {
            CodomainMapContext mapCtx = i.next();
            buf.append(mapCtx.getCodomainMap());
            if (j == n) {
                buf.append(".");
            } else {
                buf.append(", ");
            }
            ++j;
        }
        return buf.toString();
    }
}

