/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.data;

import ome.model.core.Pixels;
import ome.model.enums.PixelsType;
import ome.util.PixelData;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.PlaneFactory;
import omeis.providers.re.data.RegionDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plane2D {
    private static Logger log = LoggerFactory.getLogger(Plane2D.class);
    private PixelData data;
    protected PlaneDef planeDef;
    protected int bytesPerPixel;
    protected int sizeX;
    protected int sizeY;
    protected boolean signed;
    protected int slice;

    public Plane2D(PlaneDef pDef, Pixels pixels, PixelData data) {
        this.planeDef = pDef;
        RegionDef region = pDef.getRegion();
        if (region != null) {
            this.sizeX = region.getWidth();
            this.sizeY = region.getHeight();
        } else {
            this.sizeX = pixels.getSizeX();
            this.sizeY = pixels.getSizeY();
        }
        int stride = pDef.getStride();
        if (stride < 0) {
            stride = 0;
        }
        this.sizeX /= ++stride;
        this.sizeY /= stride;
        this.data = data;
        PixelsType type = pixels.getPixelsType();
        this.bytesPerPixel = PlaneFactory.bytesPerPixel(type);
        this.signed = PlaneFactory.isTypeSigned(type);
        this.slice = pDef.getSlice();
        log.debug("Created Plane2D with dimensions " + this.sizeX + "x" + this.sizeY + "x" + this.bytesPerPixel);
    }

    public double getPixelValue(int x1, int x2) {
        switch (this.slice) {
            case 0: {
                return this.data.getPixelValueDirect(this.bytesPerPixel * (this.sizeX * x2 + x1));
            }
            case 2: {
                return this.data.getPixelValueDirect(this.bytesPerPixel * (x2 * this.sizeX * this.sizeY + this.sizeX * this.planeDef.getY() + x1));
            }
            case 1: {
                return this.data.getPixelValueDirect(this.bytesPerPixel * (x1 * this.sizeX * this.sizeY + this.sizeX * x2 + this.planeDef.getX()));
            }
        }
        throw new RuntimeException("Unknown PlaneDef slice: " + this.slice);
    }

    public double getPixelValue(int offset) {
        return this.data.getPixelValue(offset);
    }

    public boolean isXYPlanar() {
        return this.slice == 0;
    }

    public PixelData getData() {
        return this.data;
    }
}

