/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.ArrayBoolean;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayShort;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexConstant;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;

public abstract class Array {
    protected final DataType dataType;
    protected final Index indexCalc;
    protected final int rank;
    private IndexIterator ii;

    public static Array factory(DataType dataType, int[] shape) {
        return Array.factory(dataType, Index.factory(shape), null);
    }

    public static Array factory(DataType dataType, int[] shape, Object storage) {
        return Array.factory(dataType, Index.factory(shape), storage);
    }

    public static Array factory(DataType dtype, Index index, Object storage) {
        switch (dtype) {
            case DOUBLE: {
                return ArrayDouble.factory(index, (double[])storage);
            }
            case FLOAT: {
                return ArrayFloat.factory(index, (float[])storage);
            }
            case CHAR: {
                return ArrayChar.factory(index, (char[])storage);
            }
            case BOOLEAN: {
                return ArrayBoolean.factory(index, (boolean[])storage);
            }
            case ENUM4: 
            case UINT: 
            case INT: {
                return ArrayInt.factory(index, dtype.isUnsigned(), (int[])storage);
            }
            case ENUM2: 
            case USHORT: 
            case SHORT: {
                return ArrayShort.factory(index, dtype.isUnsigned(), (short[])storage);
            }
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                return ArrayByte.factory(index, dtype.isUnsigned(), (byte[])storage);
            }
            case ULONG: 
            case LONG: {
                return ArrayLong.factory(index, dtype.isUnsigned(), (long[])storage);
            }
            case STRING: {
                return ArrayObject.factory(dtype, String.class, false, index, (Object[])storage);
            }
            case STRUCTURE: {
                return ArrayObject.factory(dtype, StructureData.class, false, index, (Object[])storage);
            }
            case SEQUENCE: {
                return ArrayObject.factory(dtype, StructureDataIterator.class, false, index, (Object[])storage);
            }
            case OPAQUE: {
                return ArrayObject.factory(dtype, ByteBuffer.class, false, index, (Object[])storage);
            }
        }
        throw new RuntimeException("Cant use this method for datatype " + (Object)((Object)dtype));
    }

    public static Array makeVlenArray(int[] shape, @Nonnull Array[] storage) {
        Index index = Index.factory(shape);
        return ArrayObject.factory(storage[0].getDataType(), storage[0].getClass(), true, index, storage);
    }

    public static Array makeObjectArray(DataType dtype, Class classType, int[] shape, Object storage) {
        Index index = Index.factory(shape);
        return ArrayObject.factory(dtype, classType, false, index, (Object[])storage);
    }

    public static Array factoryConstant(DataType dtype, int[] shape, Object storage) {
        IndexConstant index = new IndexConstant(shape);
        switch (dtype) {
            case BOOLEAN: {
                return new ArrayBoolean(index, (boolean[])storage);
            }
            case BYTE: {
                return new ArrayByte(index, false, (byte[])storage);
            }
            case CHAR: {
                return new ArrayChar(index, (char[])storage);
            }
            case SHORT: {
                return new ArrayShort(index, false, (short[])storage);
            }
            case INT: {
                return new ArrayInt(index, false, (int[])storage);
            }
            case LONG: {
                return new ArrayLong(index, false, (long[])storage);
            }
            case FLOAT: {
                return new ArrayFloat(index, (float[])storage);
            }
            case DOUBLE: {
                return new ArrayDouble(index, (double[])storage);
            }
            case ENUM1: 
            case UBYTE: {
                return new ArrayByte(index, true, (byte[])storage);
            }
            case ENUM2: 
            case USHORT: {
                return new ArrayShort(index, true, (short[])storage);
            }
            case ENUM4: 
            case UINT: {
                return new ArrayInt(index, true, (int[])storage);
            }
            case ULONG: {
                return new ArrayLong(index, true, (long[])storage);
            }
            case STRING: {
                return new ArrayObject(dtype, String.class, false, index, (Object[])storage);
            }
            case STRUCTURE: {
                return new ArrayObject(dtype, StructureData.class, false, index, (Object[])storage);
            }
            case SEQUENCE: {
                return new ArrayObject(dtype, StructureDataIterator.class, false, index, (Object[])storage);
            }
            case OPAQUE: {
                return new ArrayObject(dtype, ByteBuffer.class, false, index, (Object[])storage);
            }
        }
        return ArrayObject.factory(DataType.OBJECT, Object.class, false, index, (Object[])storage);
    }

    public static Array makeFromJavaArray(Object javaArray) {
        return Array.makeFromJavaArray(javaArray, false);
    }

    public static Array makeFromJavaArray(Object javaArray, boolean isUnsigned) {
        int rank_ = 0;
        Class<?> componentType = javaArray.getClass();
        while (componentType.isArray()) {
            ++rank_;
            componentType = componentType.getComponentType();
        }
        int count = 0;
        int[] shape = new int[rank_];
        Object jArray = javaArray;
        Class<?> cType = jArray.getClass();
        while (cType.isArray()) {
            shape[count++] = java.lang.reflect.Array.getLength(jArray);
            jArray = java.lang.reflect.Array.get(jArray, 0);
            cType = jArray.getClass();
        }
        DataType dtype = DataType.getType(componentType, isUnsigned);
        Array aa = Array.factory(dtype, shape);
        IndexIterator aaIter = aa.getIndexIterator();
        Array.reflectArrayCopyIn(javaArray, aa, aaIter);
        return aa;
    }

    private static void reflectArrayCopyIn(Object jArray, Array aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (cType.isPrimitive()) {
            aa.copyFrom1DJavaArray(aaIter, jArray);
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                Array.reflectArrayCopyIn(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    private static void reflectArrayCopyOut(Object jArray, Array aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (!cType.isArray()) {
            aa.copyTo1DJavaArray(aaIter, jArray);
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                Array.reflectArrayCopyOut(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    public static void arraycopy(Array arraySrc, int srcPos, Array arrayDst, int dstPos, int len) {
        if (arraySrc.isConstant()) {
            double d = arraySrc.getDouble(0);
            for (int i = dstPos; i < dstPos + len; ++i) {
                arrayDst.setDouble(i, d);
            }
            return;
        }
        Object src = arraySrc.get1DJavaArray(arraySrc.getDataType());
        Object dst = arrayDst.getStorage();
        System.arraycopy(src, srcPos, dst, dstPos, len);
    }

    public static Array makeArray(DataType dtype, int npts, double start, double incr) {
        Array result = Array.factory(dtype, new int[]{npts});
        IndexIterator dataI = result.getIndexIterator();
        for (int i = 0; i < npts; ++i) {
            double val = start + (double)i * incr;
            dataI.setDoubleNext(val);
        }
        return result;
    }

    public static Array makeArray(DataType dtype, List<String> stringValues) throws NumberFormatException {
        Array result = Array.factory(dtype, new int[]{stringValues.size()});
        IndexIterator dataI = result.getIndexIterator();
        for (String s : stringValues) {
            if (dtype == DataType.STRING) {
                dataI.setObjectNext(s);
                continue;
            }
            if (dtype == DataType.LONG) {
                if (dtype.isUnsigned()) {
                    BigInteger biggy = new BigInteger(s);
                    dataI.setLongNext(biggy.longValue());
                    continue;
                }
                long val = Long.parseLong(s);
                dataI.setLongNext(val);
                continue;
            }
            double val = Double.parseDouble(s);
            dataI.setDoubleNext(val);
        }
        return result;
    }

    public static Array makeArray(DataType dtype, String[] stringValues) throws NumberFormatException {
        return Array.makeArray(dtype, Arrays.asList(stringValues));
    }

    public static Array makeArrayRankPlusOne(Array org) {
        int[] shape = new int[org.getRank() + 1];
        System.arraycopy(org.getShape(), 0, shape, 1, org.getRank());
        shape[0] = 1;
        return Array.factory(org.getDataType(), shape, org.getStorage());
    }

    public static Array factoryCopy(DataType dataType, int[] shape, List<Array> arrays) {
        if (arrays.isEmpty()) {
            throw new IllegalArgumentException("Expected a non-empty list of Arrays to combine");
        }
        if (arrays.size() == 1) {
            return Array.factory(dataType, shape, arrays.get(0).getStorage());
        }
        long size = Index.computeSize(shape);
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Could not combine Arrays");
        }
        if (dataType == DataType.STRUCTURE) {
            return Array.combineArrayStructures(size, arrays);
        }
        return Array.combinePrimitiveArrays(dataType, shape, arrays);
    }

    private static Array combinePrimitiveArrays(DataType dataType, int[] shape, List<Array> arrays) {
        Array combinedArray = Array.factory(dataType, shape);
        int start = 0;
        for (Array array : arrays) {
            Array.arraycopy(array, 0, combinedArray, start, (int)array.getSize());
            start = (int)((long)start + array.getSize());
        }
        return combinedArray;
    }

    private static Array combineArrayStructures(long size, List<Array> arrays) {
        StructureData[] combinedStructureData = new StructureData[(int)size];
        StructureMembers members = ((ArrayStructure)arrays.get(0)).getStructureMembers();
        if (arrays.stream().anyMatch(array -> !((ArrayStructure)array).getStructureMembers().equals(members))) {
            throw new IllegalArgumentException("Expected ArrayStructures to be combined to have the same members");
        }
        int count = 0;
        for (Array array2 : arrays) {
            ArrayStructure arrayStructure = (ArrayStructure)array2;
            for (StructureData structureData : arrayStructure) {
                combinedStructureData[count++] = structureData;
            }
        }
        return new ArrayStructureW(members, new int[]{count}, combinedStructureData);
    }

    protected Array(DataType dataType, int[] shape) {
        this.dataType = dataType;
        this.rank = shape.length;
        this.indexCalc = Index.factory(shape);
    }

    protected Array(DataType dataType, Index index) {
        this.dataType = dataType;
        this.rank = index.getRank();
        this.indexCalc = index;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Index getIndex() {
        return (Index)this.indexCalc.clone();
    }

    public IndexIterator getIndexIterator() {
        return this.indexCalc.getIndexIterator(this);
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getShape() {
        return this.indexCalc.getShape();
    }

    public long getSize() {
        return this.indexCalc.getSize();
    }

    public long getSizeBytes() {
        DataType dtype = DataType.getType(this);
        return this.indexCalc.getSize() * (long)dtype.getSize();
    }

    public IndexIterator getRangeIterator(List<Range> ranges) throws InvalidRangeException {
        return this.section(ranges).getIndexIterator();
    }

    public abstract Class getElementType();

    public abstract Object getStorage();

    protected abstract void copyFrom1DJavaArray(IndexIterator var1, Object var2);

    protected abstract void copyTo1DJavaArray(IndexIterator var1, Object var2);

    protected abstract Array createView(Index var1);

    public Array section(List<Range> ranges) throws InvalidRangeException {
        return this.createView(this.indexCalc.section(ranges));
    }

    public Array section(int[] origin, int[] shape) throws InvalidRangeException {
        return this.section(origin, shape, null);
    }

    public Array section(int[] origin, int[] shape, int[] stride) throws InvalidRangeException {
        int i;
        ArrayList<Range> ranges = new ArrayList<Range>(origin.length);
        if (stride == null) {
            stride = new int[origin.length];
            for (i = 0; i < stride.length; ++i) {
                stride[i] = 1;
            }
        }
        for (i = 0; i < origin.length; ++i) {
            ranges.add(new Range(origin[i], origin[i] + stride[i] * shape[i] - 1, stride[i]));
        }
        return this.createView(this.indexCalc.section(ranges));
    }

    public Array sectionNoReduce(List<Range> ranges) throws InvalidRangeException {
        return this.createView(this.indexCalc.sectionNoReduce(ranges));
    }

    public Array sectionNoReduce(int[] origin, int[] shape, int[] stride) throws InvalidRangeException {
        int i;
        ArrayList<Range> ranges = new ArrayList<Range>(origin.length);
        if (stride == null) {
            stride = new int[origin.length];
            for (i = 0; i < stride.length; ++i) {
                stride[i] = 1;
            }
        }
        for (i = 0; i < origin.length; ++i) {
            if (shape[i] < 0) {
                ranges.add(Range.VLEN);
                continue;
            }
            ranges.add(new Range(origin[i], origin[i] + stride[i] * shape[i] - 1, stride[i]));
        }
        return this.createView(this.indexCalc.sectionNoReduce(ranges));
    }

    public Array slice(int dim, int value) {
        int[] origin = new int[this.rank];
        int[] shape = this.getShape();
        origin[dim] = value;
        shape[dim] = 1;
        try {
            return this.sectionNoReduce(origin, shape, null).reduce(dim);
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException();
        }
    }

    public Array copy() {
        Array newA = Array.factory(this.getDataType(), this.getShape());
        MAMath.copy(newA, this);
        return newA;
    }

    public Object get1DJavaArray(DataType wantType) {
        if (wantType == this.getDataType()) {
            if (this.indexCalc.isFastIterator()) {
                return this.getStorage();
            }
            return this.copyTo1DJavaArray();
        }
        Array newA = Array.factory(wantType, this.getShape());
        MAMath.copy(newA, this);
        return newA.getStorage();
    }

    public Object get1DJavaArray(Class wantType) {
        DataType want = DataType.getType(wantType, this.isUnsigned());
        return this.get1DJavaArray(want);
    }

    public ByteBuffer getDataAsByteBuffer() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer getDataAsByteBuffer(ByteOrder order) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer getDataAsByteBuffer(int capacity, ByteOrder order) {
        ByteBuffer bb = ByteBuffer.allocate(capacity);
        if (order != null) {
            bb.order(order);
        }
        return bb;
    }

    public static Array factory(DataType dtype, int[] shape, ByteBuffer bb) {
        switch (dtype) {
            case CHAR: 
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                int size = bb.limit();
                if (shape == null) {
                    shape = new int[]{size};
                }
                Array result = Array.factory(dtype, shape);
                for (int i = 0; i < size; ++i) {
                    result.setByte(i, bb.get(i));
                }
                return result;
            }
            case ENUM2: 
            case USHORT: 
            case SHORT: {
                ShortBuffer sb = bb.asShortBuffer();
                int size = sb.limit();
                if (shape == null) {
                    shape = new int[]{size};
                }
                Array result = Array.factory(dtype, shape);
                for (int i = 0; i < size; ++i) {
                    result.setShort(i, sb.get(i));
                }
                return result;
            }
            case ENUM4: 
            case UINT: 
            case INT: {
                IntBuffer ib = bb.asIntBuffer();
                int size = ib.limit();
                if (shape == null) {
                    shape = new int[]{size};
                }
                Array result = Array.factory(dtype, shape);
                for (int i = 0; i < size; ++i) {
                    result.setInt(i, ib.get(i));
                }
                return result;
            }
            case ULONG: 
            case LONG: {
                LongBuffer lb = bb.asLongBuffer();
                int size = lb.limit();
                if (shape == null) {
                    shape = new int[]{size};
                }
                Array result = Array.factory(dtype, shape);
                for (int i = 0; i < size; ++i) {
                    result.setLong(i, lb.get(i));
                }
                return result;
            }
            case FLOAT: {
                FloatBuffer ffb = bb.asFloatBuffer();
                int size = ffb.limit();
                if (shape == null) {
                    shape = new int[]{size};
                }
                Array result = Array.factory(dtype, shape);
                for (int i = 0; i < size; ++i) {
                    result.setFloat(i, ffb.get(i));
                }
                return result;
            }
            case DOUBLE: {
                DoubleBuffer db = bb.asDoubleBuffer();
                int size = db.limit();
                if (shape == null) {
                    shape = new int[]{size};
                }
                Array result = Array.factory(dtype, shape);
                for (int i = 0; i < size; ++i) {
                    result.setDouble(i, db.get(i));
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("" + (Object)((Object)dtype));
    }

    public Object copyTo1DJavaArray() {
        Array newA = this.copy();
        return newA.getStorage();
    }

    public Object copyToNDJavaArray() {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(this.getElementType(), this.getShape());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = this.getIndexIterator();
        Array.reflectArrayCopyOut(javaArray, this, iter);
        return javaArray;
    }

    public Array flip(int dim) {
        return this.createView(this.indexCalc.flip(dim));
    }

    public Array transpose(int dim1, int dim2) {
        return this.createView(this.indexCalc.transpose(dim1, dim2));
    }

    public Array permute(int[] dims) {
        return this.createView(this.indexCalc.permute(dims));
    }

    public Array reshape(int[] shape) {
        Array result = Array.factory(this.getDataType(), shape);
        if (result.getSize() != this.getSize()) {
            throw new IllegalArgumentException("reshape arrays must have same total size");
        }
        Array.arraycopy(this, 0, result, 0, (int)this.getSize());
        return result;
    }

    public Array reshapeNoCopy(int[] shape) {
        Array result = Array.factory(this.getDataType(), shape, this.getStorage());
        if (result.getSize() != this.getSize()) {
            throw new IllegalArgumentException("reshape arrays must have same total size");
        }
        return result;
    }

    public Array reduce() {
        Index ri = this.indexCalc.reduce();
        if (ri == this.indexCalc) {
            return this;
        }
        return this.createView(ri);
    }

    public Array reduce(int dim) {
        return this.createView(this.indexCalc.reduce(dim));
    }

    public boolean isUnsigned() {
        return this.dataType.isUnsigned();
    }

    public boolean isConstant() {
        return this.indexCalc instanceof IndexConstant;
    }

    public boolean isVlen() {
        return false;
    }

    public abstract double getDouble(Index var1);

    public abstract void setDouble(Index var1, double var2);

    public abstract float getFloat(Index var1);

    public abstract void setFloat(Index var1, float var2);

    public abstract long getLong(Index var1);

    public abstract void setLong(Index var1, long var2);

    public abstract int getInt(Index var1);

    public abstract void setInt(Index var1, int var2);

    public abstract short getShort(Index var1);

    public abstract void setShort(Index var1, short var2);

    public abstract byte getByte(Index var1);

    public abstract void setByte(Index var1, byte var2);

    public abstract char getChar(Index var1);

    public abstract void setChar(Index var1, char var2);

    public abstract boolean getBoolean(Index var1);

    public abstract void setBoolean(Index var1, boolean var2);

    public abstract Object getObject(Index var1);

    public abstract void setObject(Index var1, Object var2);

    public abstract double getDouble(int var1);

    public abstract void setDouble(int var1, double var2);

    public abstract float getFloat(int var1);

    public abstract void setFloat(int var1, float var2);

    public abstract long getLong(int var1);

    public abstract void setLong(int var1, long var2);

    public abstract int getInt(int var1);

    public abstract void setInt(int var1, int var2);

    public abstract short getShort(int var1);

    public abstract void setShort(int var1, short var2);

    public abstract byte getByte(int var1);

    public abstract void setByte(int var1, byte var2);

    public abstract char getChar(int var1);

    public abstract void setChar(int var1, char var2);

    public abstract boolean getBoolean(int var1);

    public abstract void setBoolean(int var1, boolean var2);

    public abstract Object getObject(int var1);

    public abstract void setObject(int var1, Object var2);

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        IndexIterator ii = this.getIndexIterator();
        while (ii.hasNext()) {
            Object value = ii.getObjectNext();
            if (this.isUnsigned()) {
                assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                value = DataType.widenNumberIfNegative((Number)value);
            }
            sbuff.append(value);
            sbuff.append(" ");
        }
        return sbuff.toString();
    }

    public String shapeToString() {
        int[] shape = this.getShape();
        if (shape.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < shape.length; ++i) {
            int s = shape[i];
            if (i > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean hasNext() {
        if (null == this.ii) {
            this.ii = this.getIndexIterator();
        }
        return this.ii.hasNext();
    }

    public Object next() {
        return this.ii.getObjectNext();
    }

    public double nextDouble() {
        return this.ii.getDoubleNext();
    }

    public float nextFloat() {
        return this.ii.getFloatNext();
    }

    public byte nextByte() {
        return this.ii.getByteNext();
    }

    public short nextShort() {
        return this.ii.getShortNext();
    }

    public int nextInt() {
        return this.ii.getIntNext();
    }

    public long nextLong() {
        return this.ii.getLongNext();
    }

    public char nextChar() {
        return this.ii.getCharNext();
    }

    public boolean nextBoolean() {
        return this.ii.getBooleanNext();
    }

    public void resetLocalIterator() {
        this.ii = null;
    }
}

