/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.List;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.WRFEta;
import ucar.unidata.util.Parameter;

public class WRFEtaTransformBuilder
extends AbstractTransformBuilder
implements VertTransformBuilderIF {
    private CoordinateSystem cs;

    public WRFEtaTransformBuilder(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public VerticalCT makeCoordinateTransform(NetcdfDataset ds, AttributeContainer v) {
        VerticalCT.Type type = VerticalCT.Type.WRFEta;
        VerticalCT ct = new VerticalCT(type.toString(), this.getTransformName(), type, this);
        ct.addParameter(new Parameter("height formula", "height(x,y,z) = (PH(x,y,z) + PHB(x,y,z)) / 9.81"));
        ct.addParameter(new Parameter("perturbation_geopotential", "PH"));
        ct.addParameter(new Parameter("base_geopotential", "PHB"));
        ct.addParameter(new Parameter("pressure formula", "pressure(x,y,z) = P(x,y,z) + PB(x,y,z)"));
        ct.addParameter(new Parameter("perturbation_presure", "P"));
        ct.addParameter(new Parameter("base_presure", "PB"));
        if (this.cs.getXaxis() != null) {
            ct.addParameter(new Parameter("staggered_x", "" + this.isStaggered(this.cs.getXaxis())));
        } else {
            ct.addParameter(new Parameter("staggered_x", "" + this.isStaggered2(this.cs.getLonAxis(), 1)));
        }
        if (this.cs.getYaxis() != null) {
            ct.addParameter(new Parameter("staggered_y", "" + this.isStaggered(this.cs.getYaxis())));
        } else {
            ct.addParameter(new Parameter("staggered_y", "" + this.isStaggered2(this.cs.getLatAxis(), 0)));
        }
        ct.addParameter(new Parameter("staggered_z", "" + this.isStaggered(this.cs.getZaxis())));
        ct.addParameter(new Parameter("eta", "" + this.cs.getZaxis().getFullName()));
        return ct;
    }

    @Override
    public String getTransformName() {
        return VerticalCT.Type.WRFEta.name();
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new WRFEta(ds, timeDim, (List<Parameter>)vCT.getParameters());
    }

    private boolean isStaggered(CoordinateAxis axis) {
        if (axis == null) {
            return false;
        }
        String name = axis.getShortName();
        return name != null && name.endsWith("stag");
    }

    private boolean isStaggered2(CoordinateAxis axis, int dimIndex) {
        if (axis == null) {
            return false;
        }
        Dimension dim = axis.getDimension(dimIndex);
        return dim != null && dim.getShortName().endsWith("stag");
    }
}

