/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.internal.dataset.transform.vertical.VerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.WRFEta;
import ucar.unidata.util.Parameter;

public class WRFEtaTransformBuilder
implements VerticalCTBuilder {
    private final CoordinatesHelper.Builder coords;
    private final CoordinateSystem.Builder cs;

    public WRFEtaTransformBuilder(CoordinatesHelper.Builder coords, CoordinateSystem.Builder cs) {
        this.coords = coords;
        this.cs = cs;
    }

    @Override
    public VerticalCT makeVerticalCT(NetcdfDataset ds) {
        VerticalCT.Type type = VerticalCT.Type.WRFEta;
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("height formula", "height(x,y,z) = (PH(x,y,z) + PHB(x,y,z)) / 9.81"));
        params.add(new Parameter("perturbation_geopotential", "PH"));
        params.add(new Parameter("base_geopotential", "PHB"));
        params.add(new Parameter("pressure formula", "pressure(x,y,z) = P(x,y,z) + PB(x,y,z)"));
        params.add(new Parameter("perturbation_presure", "P"));
        params.add(new Parameter("base_presure", "PB"));
        if (this.coords.findAxisByType(this.cs, AxisType.GeoX).isPresent()) {
            params.add(new Parameter("staggered_x", "" + this.isStaggered(AxisType.GeoX)));
        } else {
            params.add(new Parameter("staggered_x", "" + this.isStaggered2(AxisType.Lon, 1)));
        }
        if (this.coords.findAxisByType(this.cs, AxisType.GeoY).isPresent()) {
            params.add(new Parameter("staggered_y", "" + this.isStaggered(AxisType.GeoY)));
        } else {
            params.add(new Parameter("staggered_y", "" + this.isStaggered2(AxisType.Lat, 0)));
        }
        params.add(new Parameter("staggered_z", "" + this.isStaggered(AxisType.GeoZ)));
        this.coords.findAxisByType(this.cs, AxisType.GeoZ).ifPresent(a -> params.add(new Parameter("eta", "" + a.getFullName())));
        return new WRFEtaTransform(this.getTransformName(), type.toString(), type, params);
    }

    @Override
    public String getTransformName() {
        return VerticalCT.Type.WRFEta.name() + this.cs.coordAxesNames;
    }

    private boolean isStaggered(AxisType type) {
        return this.coords.findAxisByType(this.cs, type).map(a -> a.shortName != null && a.shortName.endsWith("stag")).orElse(false);
    }

    private boolean isStaggered2(AxisType type, int dimIndex) {
        return this.coords.findAxisByType(this.cs, type).map(a -> {
            String dimName = a.getDimensionName(dimIndex);
            return dimName != null && dimName.endsWith("stag");
        }).orElse(false);
    }

    static class WRFEtaTransform
    extends VerticalCT
    implements VerticalTransformBuilder {
        WRFEtaTransform(String name, String authority, VerticalCT.Type type, List<Parameter> params) {
            super(name, authority, type, params);
        }

        @Override
        public VerticalTransform makeVerticalTransform(NetcdfDataset ds, Dimension timeDim) {
            return new WRFEta(ds, timeDim, (List<Parameter>)this.getParameters());
        }
    }
}

