/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.Optional;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.httpservices.HTTPUtil;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamReader;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.IO;

public class CdmRemote
extends NetcdfFile {
    public static final String PROTOCOL = "cdmremote";
    public static final String SCHEME = "cdmremote:";
    private static boolean showRequest;
    private static boolean compress;
    private HTTPSession httpClient;
    private final String remoteURI;

    public static void setDebugFlags(DebugFlags debugFlag) {
        showRequest = debugFlag.isSet("CdmRemote/showRequest");
    }

    public static void setAllowCompression(boolean b) {
        compress = b;
    }

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return SCHEME + urlName.substring(5);
        }
        if (urlName.startsWith("https:")) {
            return SCHEME + urlName.substring(6);
        }
        return urlName;
    }

    public CdmRemote(String _remoteURI) throws IOException {
        long start = System.currentTimeMillis();
        String temp = _remoteURI;
        try {
            if (temp.startsWith(SCHEME)) {
                temp = temp.substring(SCHEME.length());
            } else if (!(temp.startsWith("http:") | temp.startsWith("https:"))) {
                temp = "http:" + temp;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.remoteURI = temp;
        this.httpClient = HTTPFactory.newSession((String)this.remoteURI);
        String url = this.remoteURI + "?req=header";
        if (showRequest) {
            System.out.printf(" CdmRemote request %s%n", url);
        }
        try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)url);){
            method.setFollowRedirects(true);
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(CdmRemote.getErrorMessage(method));
            }
            if (statusCode >= 300) {
                throw new IOException(CdmRemote.getErrorMessage(method));
            }
            InputStream is = method.getResponseAsStream();
            NcStreamReader reader = new NcStreamReader();
            reader.readStream(is, this);
            this.location = SCHEME + this.remoteURI;
        }
        long took = System.currentTimeMillis() - start;
        if (showRequest) {
            System.out.printf(" CdmRemote request %s took %d msecs %n", url, took);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdmRemote(InputStream is, String location) throws IOException {
        this.remoteURI = location;
        try {
            NcStreamReader reader = new NcStreamReader();
            reader.readStream(is, this);
            this.location = SCHEME + this.remoteURI;
        }
        finally {
            is.close();
        }
    }

    @Override
    protected Array readData(Variable v, Section section) throws IOException {
        URI escapedURI;
        if (v.getDataType() == DataType.SEQUENCE) {
            Structure s = (Structure)v;
            StructureDataIterator siter = this.getStructureIterator(s, -1);
            return new ArraySequence(s.makeStructureMembers(), siter, -1);
        }
        Formatter f = new Formatter();
        f.format("%s?req=data", this.remoteURI);
        if (compress) {
            f.format("&deflate=5", new Object[0]);
        }
        f.format("&var=%s", v.getFullNameEscaped());
        if (section != null && section.computeSize() != v.getSize() && v.getDataType() != DataType.SEQUENCE) {
            f.format("(%s)", section.toString());
        }
        String url = f.toString();
        try {
            escapedURI = HTTPUtil.parseToURI((String)url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (showRequest) {
            System.out.printf("CdmRemote data request for variable: '%s' section=(%s)%n url='%s'%n esc='%s'%n", v.getFullName(), section, url, escapedURI);
        }
        try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)escapedURI.toString());){
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(CdmRemote.getErrorMessage(method));
            }
            if (statusCode >= 300) {
                throw new IOException(CdmRemote.getErrorMessage(method));
            }
            Optional contentLength = method.getResponseHeaderValue("Content-Length");
            if (contentLength.isPresent()) {
                int wantSize;
                int readLen = Integer.parseInt((String)contentLength.get());
                if (showRequest) {
                    System.out.printf(" content-length = %d%n", readLen);
                }
                if (v.getDataType() != DataType.SEQUENCE && readLen != (wantSize = (int)((long)v.getElementSize() * (section == null ? v.getSize() : section.computeSize())))) {
                    throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
                }
            }
            InputStream is = method.getResponseAsStream();
            NcStreamReader reader = new NcStreamReader();
            NcStreamReader.DataResult result = reader.readData(is, this, this.remoteURI);
            assert (v.getFullNameEscaped().equals(result.varNameFullEsc));
            Array array = result.data;
            return array;
        }
    }

    private static String getErrorMessage(HTTPMethod method) {
        String path = method.getURI().toString();
        String status = method.getStatusLine();
        String content = method.getResponseAsString();
        return content == null ? status + " " + path : status + " " + path + "\n " + content;
    }

    @Override
    protected StructureDataIterator getStructureIterator(Structure s, int bufferSize) {
        try {
            InputStream is = CdmRemote.sendQuery(this.httpClient, this.remoteURI, s.getFullNameEscaped());
            NcStreamReader reader = new NcStreamReader();
            return reader.getStructureIterator(is, this);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public static InputStream sendQuery(HTTPSession session, String remoteURI, String query) throws IOException {
        long start = System.currentTimeMillis();
        StringBuilder sbuff = new StringBuilder(remoteURI);
        sbuff.append("?");
        sbuff.append(query);
        if (showRequest) {
            System.out.printf(" CdmRemote sendQuery= %s", sbuff);
        }
        HTTPMethod method = HTTPFactory.Get((HTTPSession)session, (String)sbuff.toString());
        try {
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 400) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            InputStream stream = method.getResponseBodyAsStream();
            if (showRequest) {
                System.out.printf(" took %d msecs %n", System.currentTimeMillis() - start);
            }
            return stream;
        }
        catch (IOException e) {
            method.close();
            throw e;
        }
    }

    @Override
    public String getFileTypeId() {
        return "ncstreamRemote";
    }

    @Override
    public String getFileTypeDescription() {
        return "ncstreamRemote";
    }

    public long writeToFile(String filename) throws IOException {
        File file = new File(filename);
        String url = this.remoteURI + "?req=header";
        Escaper urlParamEscaper = UrlEscapers.urlFormParameterEscaper();
        long size = 0L;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(NcStream.MAGIC_START);
            size += 4L;
            try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)url);){
                int statusCode;
                if (showRequest) {
                    System.out.printf("CdmRemote request %s %n", url);
                }
                if ((statusCode = method.execute()) == 404) {
                    throw new FileNotFoundException(CdmRemote.getErrorMessage(method));
                }
                if (statusCode >= 300) {
                    throw new IOException(CdmRemote.getErrorMessage(method));
                }
                InputStream is = method.getResponseBodyAsStream();
                size += IO.copyB(is, fos, 64000);
            }
            for (Variable v : this.getVariables()) {
                StringBuilder sbuff = new StringBuilder(this.remoteURI);
                sbuff.append("?var=");
                sbuff.append(urlParamEscaper.escape(v.getShortName()));
                if (showRequest) {
                    System.out.println(" CdmRemote data request for variable: " + v.getFullName() + " url=" + sbuff);
                }
                HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)sbuff.toString());
                try {
                    int readLen;
                    int statusCode = method.execute();
                    if (statusCode == 404) {
                        throw new FileNotFoundException(CdmRemote.getErrorMessage(method));
                    }
                    if (statusCode >= 300) {
                        throw new IOException(CdmRemote.getErrorMessage(method));
                    }
                    int wantSize = (int)v.getSize();
                    Optional contentLength = method.getResponseHeaderValue("Content-Length");
                    if (contentLength.isPresent() && (readLen = Integer.parseInt((String)contentLength.get())) != wantSize) {
                        throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
                    }
                    InputStream is = method.getResponseBodyAsStream();
                    size += IO.copyB(is, fos, 64000);
                }
                finally {
                    if (method == null) continue;
                    method.close();
                }
            }
            fos.flush();
        }
        return size;
    }

    @Override
    public synchronized void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

