/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.Misc;

public class CompareNetcdf2 {
    public static final ObjFilter IDENTITY_FILTER = new ObjFilter(){};
    private static final int MAX_SIZE_TO_READ = 10000000;
    private Formatter f;
    private boolean showCompare;
    private boolean showEach;
    private boolean compareData;
    private boolean ignoreattrcase;

    public boolean enumsAreEqual(EnumTypedef enum1, EnumTypedef enum2) {
        String name1 = enum1.getShortName();
        String name2 = enum2.getShortName();
        if (name1.endsWith("_t")) {
            name1 = name1.substring(0, name1.length() - 2);
        }
        if (name2.endsWith("_t")) {
            name2 = name2.substring(0, name2.length() - 2);
        }
        return Objects.equal((Object)name1, (Object)name2) && Objects.equal(enum1.getMap(), enum2.getMap()) && enum1.getBaseType() == enum2.getBaseType();
    }

    public static boolean compareData(String name, Array data1, Array data2) {
        return new CompareNetcdf2().compareData(name, data1, data2, false, true);
    }

    public static boolean compareData(String name, Array data1, double[] data2) {
        Array data2a = Array.factory(DataType.DOUBLE, new int[]{data2.length}, (Object)data2);
        return CompareNetcdf2.compareData(name, data1, data2a);
    }

    public static boolean compareFiles(NetcdfFile org, NetcdfFile copy, Formatter f) {
        return CompareNetcdf2.compareFiles(org, copy, f, false, false, false);
    }

    public static boolean compareFiles(NetcdfFile org, NetcdfFile copy, Formatter f, boolean _compareData, boolean _showCompare, boolean _showEach) {
        CompareNetcdf2 tc = new CompareNetcdf2(f, _showCompare, _showEach, _compareData);
        return tc.compare(org, copy);
    }

    public static boolean compareLists(List org, List copy, Formatter f) {
        boolean ok1 = CompareNetcdf2.checkContains("first", org, copy, f);
        boolean ok2 = CompareNetcdf2.checkContains("second", copy, org, f);
        return ok1 && ok2;
    }

    public static boolean checkContains(String what, List<Object> container, List<Object> wantList, Formatter f) {
        boolean ok = true;
        for (Object want1 : wantList) {
            int index2 = container.indexOf(want1);
            if (index2 >= 0) continue;
            f.format("  ** %s missing in %s %n", want1, what);
            ok = false;
        }
        return ok;
    }

    public CompareNetcdf2() {
        this(new Formatter(System.out));
    }

    public CompareNetcdf2(Formatter f) {
        this(f, false, false, System.getProperty("allTests") != null);
    }

    public CompareNetcdf2(Formatter f, boolean showCompare, boolean showEach, boolean compareData) {
        this(f, showCompare, showEach, compareData, true);
    }

    public CompareNetcdf2(Formatter f, boolean showCompare, boolean showEach, boolean compareData, boolean ignoreattrcase) {
        this.f = f;
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
        this.ignoreattrcase = ignoreattrcase;
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy) {
        return this.compare(org, copy, this.showCompare, this.showEach, this.compareData);
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy, @Nullable ObjFilter filter) {
        return this.compare(org, copy, filter, this.showCompare, this.showEach, this.compareData);
    }

    @Deprecated
    public boolean compare(NetcdfFile org, NetcdfFile copy, boolean showCompare, boolean showEach, boolean compareData) {
        return this.compare(org, copy, null, showCompare, showEach, compareData);
    }

    @Deprecated
    public boolean compare(NetcdfFile org, NetcdfFile copy, @Nullable ObjFilter objFilter, boolean showCompare, boolean showEach, boolean compareData) {
        if (objFilter == null) {
            objFilter = IDENTITY_FILTER;
        }
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
        this.f.format(" First file = %s%n", org.getLocation());
        this.f.format(" Second file= %s%n", copy.getLocation());
        long start = System.currentTimeMillis();
        boolean ok = this.compareGroups(org.getRootGroup(), copy.getRootGroup(), objFilter);
        this.f.format(" Files are the same = %s%n", ok);
        long took = System.currentTimeMillis() - start;
        this.f.format(" Time to compare = %d msecs%n", took);
        if (org instanceof NetcdfDataset && copy instanceof NetcdfDataset) {
            NetcdfDataset orgds = (NetcdfDataset)org;
            NetcdfDataset copyds = (NetcdfDataset)copy;
            for (CoordinateSystem cs1 : orgds.getCoordinateSystems()) {
                CoordinateSystem cs2 = copyds.getCoordinateSystems().stream().filter(cs -> cs.getName().equals(cs1.getName())).findFirst().orElse(null);
                if (cs2 == null) {
                    ok = false;
                    this.f.format("  ** Cant find CoordinateSystem '%s' in file2 %n", cs1.getName());
                    continue;
                }
                ok &= this.compareCoordinateSystem(cs1, cs2, objFilter);
            }
        }
        return ok;
    }

    public boolean compareVariables(NetcdfFile org, NetcdfFile copy) {
        Variable copyVar;
        this.f.format("Original = %s%n", org.getLocation());
        this.f.format("CompareTo= %s%n", copy.getLocation());
        boolean ok = true;
        for (Variable orgV : org.getVariables()) {
            copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar == null) {
                this.f.format(" MISSING '%s' in 2nd file%n", orgV.getFullName());
                ok = false;
                continue;
            }
            ok &= this.compareVariables(orgV, copyVar, null, this.compareData, true);
        }
        this.f.format("%n", new Object[0]);
        for (Variable orgV : copy.getVariables()) {
            copyVar = org.findVariable(orgV.getShortName());
            if (copyVar != null) continue;
            this.f.format(" MISSING '%s' in 1st file%n", orgV.getFullName());
            ok = false;
        }
        return ok;
    }

    private boolean compareGroups(Group org, Group copy, ObjFilter filter) {
        if (this.showCompare) {
            this.f.format("compare Group '%s' to '%s' %n", org.getShortName(), copy.getShortName());
        }
        boolean ok = true;
        if (!org.getShortName().equals(copy.getShortName())) {
            this.f.format(" ** names are different %s != %s %n", org.getShortName(), copy.getShortName());
            ok = false;
        }
        if (filter.checkDimensionsForFile(org.getNetcdfFile().getLocation())) {
            ok &= this.checkGroupDimensions(org, copy, "copy");
            ok &= this.checkGroupDimensions(copy, org, "org");
        }
        ok &= this.checkAttributes(null, org.attributes(), copy.attributes(), filter);
        ok &= this.checkEnums(org, copy, filter);
        for (Variable orgV : org.getVariables()) {
            Variable copyVar = copy.findVariableLocal(orgV.getShortName());
            if (copyVar == null) {
                this.f.format(" ** cant find variable %s in 2nd file%n", orgV.getFullName());
                ok = false;
                continue;
            }
            ok &= this.compareVariables(orgV, copyVar, filter, this.compareData, true);
        }
        for (Variable copyV : copy.getVariables()) {
            Variable orgV = org.findVariableLocal(copyV.getShortName());
            if (orgV != null) continue;
            this.f.format(" ** cant find variable %s in 1st file%n", copyV.getFullName());
            ok = false;
        }
        ArrayList groups = new ArrayList();
        String name = org.isRoot() ? "root group" : org.getFullName();
        ok &= this.checkAll(name, (List)org.getGroups(), (List)copy.getGroups(), groups);
        for (int i = 0; i < groups.size(); i += 2) {
            Group orgGroup = (Group)groups.get(i);
            Group copyGroup = (Group)groups.get(i + 1);
            ok &= this.compareGroups(orgGroup, copyGroup, filter);
        }
        return ok;
    }

    public boolean compareVariable(Variable org, Variable copy, ObjFilter filter) {
        return this.compareVariables(org, copy, filter, this.compareData, true);
    }

    private boolean compareVariables(Variable org, Variable copy, ObjFilter filter, boolean compareData, boolean justOne) {
        boolean ok = true;
        if (this.showCompare) {
            this.f.format("compare Variable %s to %s %n", org.getFullName(), copy.getFullName());
        }
        if (!org.getFullName().equals(copy.getFullName())) {
            this.f.format(" ** names are different %s != %s %n", org.getFullName(), copy.getFullName());
            ok = false;
        }
        if (filter.varDataTypeCheckOk(org) && org.getDataType() != copy.getDataType()) {
            this.f.format(" ** %s dataTypes are different %s != %s %n", new Object[]{org.getFullName(), org.getDataType(), copy.getDataType()});
            ok = false;
        }
        ok &= this.checkDimensions((List<Dimension>)org.getDimensions(), (List<Dimension>)copy.getDimensions(), copy.getFullName() + " copy");
        ok &= this.checkDimensions((List<Dimension>)copy.getDimensions(), (List<Dimension>)org.getDimensions(), org.getFullName() + " org");
        ok &= this.checkAttributes(org, org.attributes(), copy.attributes(), filter);
        if (compareData) {
            try {
                ok &= this.compareVariableData(org, copy, this.showCompare, justOne);
            }
            catch (IOException | InvalidRangeException e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.f.format("%s", sw.toString());
                return false;
            }
        }
        if (org instanceof Structure) {
            if (!(copy instanceof Structure)) {
                this.f.format("  ** %s not Structure%n", org);
                ok = false;
            } else {
                Structure orgS = (Structure)org;
                Structure copyS = (Structure)copy;
                for (Variable orgV : orgS.getVariables()) {
                    Variable copyVar = copyS.findVariable(orgV.getShortName());
                    if (copyVar == null) {
                        this.f.format(" ** cant find variable %s in 2nd file%n", orgV.getFullName());
                        ok = false;
                        continue;
                    }
                    boolean compareStructData = compareData && !(orgV instanceof Sequence);
                    ok &= this.compareVariables(orgV, copyVar, filter, compareStructData, true);
                }
            }
        }
        if (org instanceof VariableEnhanced && copy instanceof VariableEnhanced) {
            VariableEnhanced orge = (VariableEnhanced)((Object)org);
            VariableEnhanced copye = (VariableEnhanced)((Object)copy);
            for (CoordinateSystem cs1 : orge.getCoordinateSystems()) {
                CoordinateSystem cs2 = copye.getCoordinateSystems().stream().filter(cs -> cs.getName().equals(cs1.getName())).findFirst().orElse(null);
                if (cs2 == null) {
                    ok = false;
                    this.f.format("  ** Cant find CoordinateSystem '%s' in file2 for var %s %n", cs1.getName(), org.getShortName());
                    continue;
                }
                ok &= this.compareCoordinateSystem(cs1, cs2, filter);
            }
        }
        return ok;
    }

    private boolean compareCoordinateSystem(CoordinateSystem cs1, CoordinateSystem cs2, ObjFilter filter) {
        Comparable<VariableSimpleIF> ct2;
        if (this.showCompare) {
            this.f.format("compare CoordinateSystem '%s' to '%s' %n", cs1.getName(), cs2.getName());
        }
        boolean ok = true;
        for (Comparable<VariableSimpleIF> ct1 : cs1.getCoordinateAxes()) {
            ct2 = cs2.getCoordinateAxes().stream().filter(arg_0 -> CompareNetcdf2.lambda$compareCoordinateSystem$2((CoordinateAxis)ct1, arg_0)).findFirst().orElse(null);
            if (ct2 == null) {
                ok = false;
                this.f.format("  ** Cant find coordinateAxis %s in file2 %n", ((Variable)ct1).getFullName());
                continue;
            }
            ok &= this.compareCoordinateAxis((CoordinateAxis)ct1, (CoordinateAxis)ct2, filter);
        }
        for (Comparable<VariableSimpleIF> ct1 : cs1.getCoordinateTransforms()) {
            ct2 = cs2.getCoordinateTransforms().stream().filter(arg_0 -> CompareNetcdf2.lambda$compareCoordinateSystem$3(filter, (CoordinateTransform)ct1, arg_0)).findFirst().orElse(null);
            if (ct2 == null) {
                ok = false;
                this.f.format("  ** Cant find transform %s in file2 %n", ((CoordinateTransform)ct1).getName());
                continue;
            }
            boolean ctOk = filter.compareCoordinateTransform((CoordinateTransform)ct1, (CoordinateTransform)ct2);
            if (!ctOk) {
                this.f.format("  ** compareCoordinateTransform failed on ct %s for cs %s %n", ((CoordinateTransform)ct1).getName(), cs1.getName());
            }
            ok = ok && ctOk;
        }
        return ok;
    }

    private boolean compareCoordinateAxis(CoordinateAxis a1, CoordinateAxis a2, ObjFilter filter) {
        if (this.showCompare) {
            this.f.format("  compare CoordinateAxis '%s' to '%s' %n", a1.getShortName(), a2.getShortName());
        }
        this.compareVariable(a1, a2, filter);
        return true;
    }

    private boolean checkAttributes(Variable v, AttributeContainer list1, AttributeContainer list2, ObjFilter objFilter) {
        boolean ok = true;
        String name = v == null ? "global" : "variable " + v.getFullName();
        for (Attribute att1 : list1) {
            if (!objFilter.attCheckOk(v, att1)) continue;
            ok &= this.checkAtt(name, att1, "file1", list1, "file2", list2, objFilter);
        }
        for (Attribute att2 : list2) {
            if (!objFilter.attCheckOk(v, att2)) continue;
            ok &= this.checkAtt(name, att2, "file2", list2, "file1", list1, objFilter);
        }
        return ok;
    }

    private boolean checkDimensions(List<Dimension> list1, List<Dimension> list2, String where) {
        boolean ok = true;
        for (Dimension d1 : list1) {
            if (!d1.isShared()) continue;
            boolean hasit = this.listContains(list2, d1);
            if (!hasit) {
                this.f.format("  ** Missing Variable dim '%s' not in %s %n", d1, where);
            }
            ok &= hasit;
        }
        return ok;
    }

    private boolean listContains(List<Dimension> list, Dimension d2) {
        for (Dimension d1 : list) {
            if (!this.equalInValue(d1, d2)) continue;
            return true;
        }
        return false;
    }

    public Dimension findDimension(Group g, Dimension dim) {
        if (dim == null) {
            return null;
        }
        for (Dimension d : g.getDimensions()) {
            if (!this.equalInValue(d, dim)) continue;
            return d;
        }
        Group parent = g.getParentGroup();
        if (parent != null) {
            return this.findDimension(parent, dim);
        }
        return null;
    }

    public EnumTypedef findEnum(Group g, EnumTypedef typedef, ObjFilter filter) {
        if (typedef == null) {
            return null;
        }
        for (EnumTypedef other : g.getEnumTypedefs()) {
            if (!filter.enumsAreEqual(typedef, other)) continue;
            return other;
        }
        Group parent = g.getParentGroup();
        if (parent != null) {
            return this.findEnum(parent, typedef, filter);
        }
        return null;
    }

    private boolean equalInValue(Dimension d1, Dimension other) {
        if (d1.getShortName() == null && other.getShortName() != null) {
            return false;
        }
        if (d1.getShortName() != null && !d1.getShortName().equals(other.getShortName())) {
            return false;
        }
        return d1.getLength() == other.getLength() && d1.isUnlimited() == other.isUnlimited() && d1.isVariableLength() == other.isVariableLength() && d1.isShared() == other.isShared();
    }

    private boolean checkGroupDimensions(Group group1, Group group2, String where) {
        boolean ok = true;
        for (Dimension d1 : group1.getDimensions()) {
            if (!d1.isShared() || group2.getDimensions().contains(d1)) continue;
            if (this.findDimension(group2, d1) != null) {
                this.f.format("  ** Dimension '%s' found in parent group of %s %s%n", d1, where, group2.getFullName());
                continue;
            }
            this.f.format("  ** Missing Group dim '%s' not in %s %s%n", d1, where, group2.getFullName());
            ok = false;
        }
        return ok;
    }

    private boolean checkEnums(Group org, Group copy, ObjFilter filter) {
        boolean ok = true;
        for (EnumTypedef enum1 : org.getEnumTypedefs()) {
            EnumTypedef enum2;
            if (this.showCompare) {
                this.f.format("compare Enum %s%n", enum1.getShortName());
            }
            if ((enum2 = this.findEnum(copy, enum1, filter)) != null) continue;
            this.findEnum(org, enum1, filter);
            this.f.format("  ** Enum %s not in file2 %n", enum1.getShortName());
            ok = false;
        }
        for (EnumTypedef enum2 : copy.getEnumTypedefs()) {
            EnumTypedef enum1 = this.findEnum(org, enum2, filter);
            if (enum1 != null) continue;
            this.findEnum(org, enum2, filter);
            this.f.format("  ** Enum %s not in file1 %n", enum2.getShortName());
            ok = false;
        }
        return ok;
    }

    private boolean checkAll(String what, List list1, List list2, List result) {
        boolean ok = true;
        for (Object aList1 : list1) {
            ok &= this.checkEach(what, aList1, "file1", list1, "file2", list2, result);
        }
        for (Object aList2 : list2) {
            ok &= this.checkEach(what, aList2, "file2", list2, "file1", list1, null);
        }
        return ok;
    }

    private boolean checkEach(String what, Object want1, String name1, List list1, String name2, List list2, List result) {
        boolean ok = true;
        try {
            int index2 = list2.indexOf(want1);
            if (index2 < 0) {
                this.f.format("  ** %s: %s 0x%x (%s) not in %s %n", what, want1, want1.hashCode(), name1, name2);
                ok = false;
            } else {
                Object want2 = list2.get(index2);
                int index1 = list1.indexOf(want2);
                if (index1 < 0) {
                    this.f.format("  ** %s: %s 0x%x (%s) not in %s %n", what, want2, want2.hashCode(), name2, name1);
                    ok = false;
                } else {
                    Object want = list1.get(index1);
                    if (!want.equals(want1)) {
                        this.f.format("  ** %s: %s 0x%x (%s) not equal to %s 0x%x (%s) %n", what, want1, want1.hashCode(), name1, want2, want2.hashCode(), name2);
                        ok = false;
                    } else {
                        if (this.showEach) {
                            this.f.format("  OK <%s> equals <%s>%n", want1, want2);
                        }
                        if (result != null) {
                            result.add(want1);
                            result.add(want2);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.f.format(" *** Throwable= %s %n", t.getMessage());
            ok = false;
        }
        return ok;
    }

    private boolean checkAtt(String what, Attribute want, String name1, AttributeContainer list1, String name2, AttributeContainer list2, ObjFilter objFilter) {
        boolean ok = true;
        Attribute found = this.ignoreattrcase ? list2.findAttributeIgnoreCase(want.getShortName()) : list2.findAttribute(want.getShortName());
        if (found == null) {
            this.f.format("  ** %s: %s (%s) not in %s %n", what, want, name1, name2);
            ok = false;
        } else if (!objFilter.attsAreEqual(want, found)) {
            this.f.format("  ** %s: %s 0x%x (%s) not equal to %s 0x%x (%s) %n", what, want, want.hashCode(), name1, found, found.hashCode(), name2);
            ok = false;
        } else if (this.showEach) {
            this.f.format("  OK <%s> equals <%s>%n", want, found);
        }
        return ok;
    }

    private static int[] makeShapeSubset(int[] shape) {
        int maxLength = 10;
        return Arrays.stream(shape).sequential().map(s -> Math.min(10, s)).toArray();
    }

    private boolean compareVariableData(Variable var1, Variable var2, boolean showCompare, boolean justOne) throws IOException, InvalidRangeException {
        Section section;
        long size = var1.getSize() * (long)var1.getElementSize();
        Section section2 = section = size > 10000000L ? new Section(CompareNetcdf2.makeShapeSubset(var1.getShape())) : null;
        if (showCompare && section != null) {
            this.f.format(" compareArrays %s too large so only comparing section %s%n", var1.getNameAndDimensions(), section);
        }
        Array data1 = var1.read(section);
        Array data2 = var2.read(section);
        if (showCompare) {
            this.f.format(" compareArrays %s unlimited=%s size=%d%n", var1.getNameAndDimensions(), var1.isUnlimited(), data1.getSize());
        }
        boolean ok = this.compareData(var1.getFullName(), data1, data2, justOne);
        if (showCompare) {
            this.f.format("   ok=%s%n", ok);
        }
        return ok;
    }

    public boolean compareData(String name, double[] data1, double[] data2) {
        Array data1a = Array.factory(DataType.DOUBLE, new int[]{data1.length}, (Object)data1);
        Array data2a = Array.factory(DataType.DOUBLE, new int[]{data2.length}, (Object)data2);
        return this.compareData(name, data1a, data2a, false, false);
    }

    public boolean compareData(String name, Array data1, Array data2, boolean justOne) {
        return this.compareData(name, data1, data2, justOne, true);
    }

    private boolean compareData(String name, Array data1, Array data2, boolean justOne, boolean testTypes) {
        boolean ok = true;
        if (data1.getSize() != data2.getSize()) {
            this.f.format(" DIFF %s: data size %d !== %d%n", name, data1.getSize(), data2.getSize());
            ok = false;
        }
        if (testTypes && data1.getElementType() != data2.getElementType()) {
            this.f.format(" DIFF %s: data element type %s !== %s%n", name, data1.getElementType(), data2.getElementType());
            ok = false;
        }
        if (testTypes && data1.getDataType() != data2.getDataType()) {
            this.f.format(" DIFF %s: data type %s !== %s%n", new Object[]{name, data1.getDataType(), data2.getDataType()});
            ok = false;
        }
        if (!Misc.compare(data1.getShape(), data2.getShape(), this.f)) {
            this.f.format(" DIFF %s: data shape %s !== %s%n", name, Arrays.toString(data1.getShape()), Arrays.toString(data2.getShape()));
            ok = false;
        }
        if (!ok) {
            return false;
        }
        DataType dt = data1.getDataType();
        IndexIterator iter1 = data1.getIndexIterator();
        IndexIterator iter2 = data2.getIndexIterator();
        if (data1.isVlen()) {
            while (iter1.hasNext() && iter2.hasNext()) {
                Object v1 = iter1.getObjectNext();
                Object v2 = iter2.getObjectNext();
                if (v1.getClass() != v2.getClass()) {
                    this.f.format(" DIFF %s: ArrayObject class %s != %s %n", name, v1.getClass().getName(), v2.getClass().getName());
                    ok = false;
                    if (!justOne) continue;
                    break;
                }
                if (!(v1 instanceof Array)) continue;
                ok &= this.compareData(name, (Array)v1, (Array)v2, justOne, testTypes);
            }
        } else if (dt == DataType.DOUBLE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                double v2;
                double v1 = iter1.getDoubleNext();
                if (Misc.nearlyEquals(v1, v2 = iter2.getDoubleNext())) continue;
                this.f.format(this.createNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt == DataType.FLOAT) {
            while (iter1.hasNext() && iter2.hasNext()) {
                float v2;
                float v1 = iter1.getFloatNext();
                if (Misc.nearlyEquals(v1, v2 = iter2.getFloatNext())) continue;
                this.f.format(this.createNumericDataDiffMessage(dt, name, Float.valueOf(v1), Float.valueOf(v2), iter1), new Object[0]);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt.getPrimitiveClassType() == Integer.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                int v2;
                int v1 = iter1.getIntNext();
                if (v1 == (v2 = iter2.getIntNext())) continue;
                this.f.format(this.createNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt.getPrimitiveClassType() == Short.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                short v2;
                short v1 = iter1.getShortNext();
                if (v1 == (v2 = iter2.getShortNext())) continue;
                this.f.format(this.createNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt.getPrimitiveClassType() == Byte.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                byte v2;
                byte v1 = iter1.getByteNext();
                if (v1 == (v2 = iter2.getByteNext())) continue;
                this.f.format(this.createNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt.getPrimitiveClassType() == Long.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                long v2;
                long v1 = iter1.getLongNext();
                if (v1 == (v2 = iter2.getLongNext())) continue;
                this.f.format(this.createNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt.getPrimitiveClassType() == Character.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                char v2;
                char v1 = iter1.getCharNext();
                if (v1 == (v2 = iter2.getCharNext())) continue;
                this.f.format(" DIFF char %s: %s != %s count=%s%n", name, Character.valueOf(v1), Character.valueOf(v2), iter1);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt == DataType.STRING) {
            while (iter1.hasNext() && iter2.hasNext()) {
                String v2;
                String v1 = (String)iter1.getObjectNext();
                if (v1.equals(v2 = (String)iter2.getObjectNext())) continue;
                this.f.format(" DIFF string %s: %s != %s count=%s%n", name, v1, v2, iter1);
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else if (dt == DataType.STRUCTURE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                this.compareStructureData((StructureData)iter1.next(), (StructureData)iter2.next(), justOne);
            }
        } else if (dt == DataType.OPAQUE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                ByteBuffer obj1 = (ByteBuffer)iter1.next();
                ByteBuffer obj2 = (ByteBuffer)iter2.next();
                if (obj1.limit() == obj2.limit()) continue;
                this.f.format(" DIFF %s: opaque size %d != %d%n", name, obj1.limit(), obj2.limit());
                ok = false;
                if (!justOne) continue;
                break;
            }
        } else {
            ok = false;
            this.f.format(" %s: Unknown data type %s%n", name, data1.getClass().getName());
        }
        return ok;
    }

    private String createNumericDataDiffMessage(DataType dt, String name, Number v1, Number v2, IndexIterator iter) {
        return String.format(" DIFF %s %s: %s != %s;  count = %s, absDiff = %s, relDiff = %s %n", new Object[]{dt, name, v1, v2, iter, Misc.absoluteDifference(v1.doubleValue(), v2.doubleValue()), Misc.relativeDifference(v1.doubleValue(), v2.doubleValue())});
    }

    private boolean compareStructureData(StructureData sdata1, StructureData sdata2, boolean justOne) {
        boolean ok = true;
        StructureMembers sm1 = sdata1.getStructureMembers();
        StructureMembers sm2 = sdata2.getStructureMembers();
        if (sm1.getMembers().size() != sm2.getMembers().size()) {
            this.f.format(" size %d !== %d%n", sm1.getMembers().size(), sm2.getMembers().size());
            ok = false;
        }
        for (StructureMembers.Member m1 : sm1.getMembers()) {
            StructureMembers.Member m2 = sm2.findMember(m1.getName());
            Array data1 = sdata1.getArray(m1);
            Array data2 = sdata2.getArray(m2);
            ok &= this.compareData(m1.getName(), data1, data2, justOne, true);
        }
        return ok;
    }

    public static void main(String[] arg) throws IOException {
        String usage = "usage: ucar.nc2.util.CompareNetcdf2 file1 file2 [-showEach] [-compareData]";
        if (arg.length < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean showEach = false;
        boolean compareData = false;
        String file1 = arg[0];
        String file2 = arg[1];
        for (int i = 2; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-showEach")) {
                showEach = true;
            }
            if (!s.equalsIgnoreCase("-compareData")) continue;
            compareData = true;
        }
        NetcdfFile ncfile1 = NetcdfDatasets.openFile(file1, null);
        NetcdfFile ncfile2 = NetcdfDatasets.openFile(file2, null);
        CompareNetcdf2.compareFiles(ncfile1, ncfile2, new Formatter(System.out), true, compareData, showEach);
        ncfile1.close();
        ncfile2.close();
    }

    private static /* synthetic */ boolean lambda$compareCoordinateSystem$3(ObjFilter filter, CoordinateTransform ct1, CoordinateTransform ct) {
        return filter.compareCoordinateTransform(ct1, ct);
    }

    private static /* synthetic */ boolean lambda$compareCoordinateSystem$2(CoordinateAxis ct1, CoordinateAxis ct) {
        return ct.getFullName().equals(ct1.getFullName());
    }

    public static class Netcdf4ObjectFilter
    implements ObjFilter {
        @Override
        public boolean attCheckOk(Variable v, Attribute att) {
            String name = att.getShortName();
            if (name.equals("_ChunkSizes")) {
                return false;
            }
            if (name.equals("_FillValue")) {
                return false;
            }
            if (name.equals("_lastModified")) {
                return false;
            }
            if (name.equals("_Netcdf4Dimid")) {
                return false;
            }
            if (name.equals("_Netcdf4Coordinates")) {
                return false;
            }
            if (name.equals("_nc3_strict")) {
                return false;
            }
            return !name.startsWith("_");
        }

        @Override
        public boolean varDataTypeCheckOk(Variable v) {
            if (v.getDataType() == DataType.CHAR) {
                return false;
            }
            return v.getDataType() != DataType.STRING;
        }

        @Override
        public boolean attsAreEqual(Attribute att1, Attribute att2) {
            if (att1.getShortName().equalsIgnoreCase("units") && att2.getShortName().equalsIgnoreCase("units")) {
                return att1.getStringValue().trim().equals(att2.getStringValue().trim());
            }
            return att1.equals(att2);
        }
    }

    public static interface ObjFilter {
        default public boolean attCheckOk(Variable v, Attribute att) {
            return true;
        }

        default public boolean attsAreEqual(Attribute att1, Attribute att2) {
            return att1.equals(att2);
        }

        default public boolean enumsAreEqual(EnumTypedef enum1, EnumTypedef enum2) {
            return enum1.equals(enum2);
        }

        default public boolean varDataTypeCheckOk(Variable v) {
            return true;
        }

        default public boolean checkDimensionsForFile(String filename) {
            return true;
        }

        default public boolean compareCoordinateTransform(CoordinateTransform ct1, CoordinateTransform ct2) {
            return ct1.equals(ct2);
        }
    }
}

