/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.util.ArrayList;
import java.util.List;
import omero.gateway.model.MaskData;

public class Mask {
    private Mask() {
    }

    public static MaskData createCroppedMask(int[][] mask) {
        return Mask.createCroppedMask(Mask.intToBoolean(mask));
    }

    public static MaskData createCroppedMask(boolean[][] mask) {
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = 0;
        int maxy = 0;
        int width = mask.length;
        int height = mask[0].length;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                if (!mask[x][y]) continue;
                if (x < minx) {
                    minx = x;
                }
                if (x > maxx) {
                    maxx = x;
                }
                if (y < miny) {
                    miny = y;
                }
                if (y <= maxy) continue;
                maxy = y;
            }
        }
        if (maxx == 0) {
            return null;
        }
        int neww = maxx - minx + 1;
        int newh = maxy - miny + 1;
        boolean[][] newmask = new boolean[neww][newh];
        for (int y = 0; y < newh; ++y) {
            for (int x = 0; x < neww; ++x) {
                newmask[x][y] = mask[x + minx][maxy - y];
            }
        }
        MaskData result = new MaskData();
        result.setMask(newmask);
        result.setX(minx);
        result.setY(miny);
        result.setHeight(newh);
        result.setWidth(neww);
        return result;
    }

    public static List<MaskData> createCroppedMasks(int[][] masks) {
        int[][] copy = new int[masks.length][masks[0].length];
        for (int i = 0; i < copy.length; ++i) {
            for (int j = 0; j < copy[0].length; ++j) {
                copy[i][j] = masks[i][j];
            }
        }
        ArrayList<MaskData> res = new ArrayList<MaskData>();
        int target = 0;
        while ((target = Mask.getFirstNonZeroInt(copy)) > 0) {
            boolean[][] binMask = new boolean[copy.length][copy[0].length];
            for (int i = 0; i < binMask.length; ++i) {
                for (int j = 0; j < binMask[0].length; ++j) {
                    if (copy[i][j] != target) continue;
                    binMask[i][j] = true;
                    copy[i][j] = 0;
                }
            }
            MaskData m = Mask.createCroppedMask(binMask);
            res.add(m);
        }
        return res;
    }

    public static List<MaskData> createCroppedMasks(int[] masks, int width) {
        int[][] folded = Mask.fold(masks, width);
        return Mask.createCroppedMasks(folded);
    }

    private static int getFirstNonZeroInt(int[][] array) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                if (array[i][j] <= 0) continue;
                return array[i][j];
            }
        }
        return 0;
    }

    private static boolean[][] intToBoolean(int[][] array) {
        boolean[][] result = new boolean[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                result[i][j] = array[i][j] != 0;
            }
        }
        return result;
    }

    public static int[][] fold(int[] array, int length) {
        int height = array.length / length;
        if (array.length % length != 0) {
            ++height;
        }
        int[][] result = new int[height][length];
        for (int i = 0; i < array.length; ++i) {
            result[i / length][i % length] = array[i];
        }
        return result;
    }

    public static int[] unfold(int[][] array) {
        int w = array.length;
        int h = array[0].length;
        int[] result = new int[w * h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                result[i * h + j] = array[i][j];
            }
        }
        return result;
    }
}

