/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPUtil;

@Immutable
public abstract class HTTPAuthUtil {
    static boolean authscopeCompatible(AuthScope ss, AuthScope ms) {
        if (!ss.getHost().equalsIgnoreCase(ms.getHost())) {
            return false;
        }
        if (ss.getPort() != ms.getPort()) {
            return false;
        }
        String sss = ss.getScheme();
        String mss = ms.getScheme();
        return sss == AuthScope.ANY_SCHEME || mss == AuthScope.ANY_SCHEME || sss == mss;
    }

    static AuthScope uriToAuthScope(String surl) throws HTTPException {
        try {
            URI uri = HTTPUtil.parseToURI(surl);
            return HTTPAuthUtil.uriToAuthScope(uri);
        }
        catch (URISyntaxException e) {
            throw new HTTPException(e);
        }
    }

    static AuthScope uriToAuthScope(URI uri) {
        assert (uri != null);
        return new AuthScope(uri.getHost(), uri.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
    }

    static URI authscopeToURI(AuthScope authScope) throws HTTPException {
        try {
            URI url = new URI("https", null, authScope.getHost(), authScope.getPort(), "", null, null);
            return url;
        }
        catch (URISyntaxException mue) {
            throw new HTTPException(mue);
        }
    }

    public static HttpHost authscopeToHost(AuthScope scope) {
        return new HttpHost(scope.getHost(), scope.getPort(), "http");
    }

    public static AuthScope hostToAuthScope(HttpHost host) {
        return new AuthScope(host.getHostName(), host.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
    }

    public static AuthScope bestmatch(AuthScope scope, Set<AuthScope> scopelist) {
        Object creds = null;
        int bestMatchFactor = -1;
        AuthScope bestMatch = null;
        for (AuthScope current : scopelist) {
            int factor = scope.match(current);
            if (factor <= bestMatchFactor) continue;
            bestMatchFactor = factor;
            bestMatch = current;
        }
        return bestMatch;
    }
}

