/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.SessionAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExternalInfo;
import ome.model.meta.Node;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="owner_or_admin", parameters={@ParamDef(name="current_user", type="java.lang.Long"), @ParamDef(name="is_admin", type="java.lang.Integer")})})
@Filters(value={@org.hibernate.annotations.Filter(name="owner_or_admin", condition="(1 = :is_admin or owner = :current_user)"), @org.hibernate.annotations.Filter(name="LightAdminPrivilegesSecurityFilter", condition="(COALESCE(sudoer, owner) = :real_owner OR 'ReadSession' IN (:privileges))")})
@Entity
@Table(name="session", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_session", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_session"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Session
implements Serializable,
IObject,
IGlobal,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.Session_id";
    protected Long id;
    public static final String VERSION = "ome.model.meta.Session_version";
    protected Integer version = 0;
    protected Node node = null;
    protected String uuid = null;
    protected Experimenter owner = null;
    protected Experimenter sudoer = null;
    protected Long timeToIdle = null;
    protected Long timeToLive = null;
    protected Timestamp started = null;
    protected Timestamp closed = null;
    protected String message = null;
    protected String defaultEventType = null;
    protected String userAgent = null;
    @Deprecated
    protected String userIP = null;
    protected Set<Event> events = new HashSet<Event>();
    protected Set<SessionAnnotationLink> annotationLinks = new HashSet<SessionAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "session_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "session_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "session_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "session_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String NODE = "ome.model.meta.Session_node";
    public static final String UUID = "ome.model.meta.Session_uuid";
    public static final String OWNER = "ome.model.meta.Session_owner";
    public static final String SUDOER = "ome.model.meta.Session_sudoer";
    public static final String TIMETOIDLE = "ome.model.meta.Session_timeToIdle";
    public static final String TIMETOLIVE = "ome.model.meta.Session_timeToLive";
    public static final String STARTED = "ome.model.meta.Session_started";
    public static final String CLOSED = "ome.model.meta.Session_closed";
    public static final String MESSAGE = "ome.model.meta.Session_message";
    public static final String DEFAULTEVENTTYPE = "ome.model.meta.Session_defaultEventType";
    public static final String USERAGENT = "ome.model.meta.Session_userAgent";
    @Deprecated
    public static final String USERIP = "ome.model.meta.Session_userIP";
    public static final String EVENTS = "ome.model.meta.Session_events";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.meta.Session_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.meta.Session_annotationLinks";
    public static final String DETAILS = "ome.model.meta.Session_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Session() {
        this(null, true);
    }

    protected Session(Long id) {
        this(id, true);
    }

    public Session(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Session(Node _node, String _uuid, Experimenter _owner, Long _timeToIdle, Long _timeToLive, Timestamp _started, String _defaultEventType) {
        this(null, true);
        this.setNode(_node);
        this.setUuid(_uuid);
        this.setOwner(_owner);
        this.setTimeToIdle(_timeToIdle);
        this.setTimeToLive(_timeToLive);
        this.setStarted(_started);
        this.setDefaultEventType(_defaultEventType);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_session")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Node.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="node", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKsession_node_node")
    public Node getNode() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.node;
    }

    public void setNode(Node node) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.node = node;
    }

    @Type(type="ome.util.PrivilegedStringType$FilteredFullAdminUUID")
    @ColumnTransformer(read="(owner || ';' || /*securestring*/ uuid)")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=true, name="uuid", updatable=true)
    public String getUuid() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.uuid = uuid;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Experimenter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="owner", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKsession_owner_experimenter")
    public Experimenter getOwner() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.owner;
    }

    public void setOwner(Experimenter owner) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.owner = owner;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Experimenter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="sudoer", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKsession_sudoer_experimenter")
    public Experimenter getSudoer() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sudoer;
    }

    public void setSudoer(Experimenter sudoer) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sudoer = sudoer;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="timeToIdle", updatable=true)
    public Long getTimeToIdle() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.timeToIdle;
    }

    public void setTimeToIdle(Long timeToIdle) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.timeToIdle = timeToIdle;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="timeToLive", updatable=true)
    public Long getTimeToLive() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.timeToLive;
    }

    public void setTimeToLive(Long timeToLive) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.timeToLive = timeToLive;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED)})
    @Column(columnDefinition="", nullable=false, unique=false, name="started", updatable=true)
    public Timestamp getStarted() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.started;
    }

    public void setStarted(Timestamp started) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.started = started;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED)})
    @Column(columnDefinition="", nullable=true, unique=false, name="closed", updatable=true)
    public Timestamp getClosed() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.closed;
    }

    public void setClosed(Timestamp closed) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.closed = closed;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="message", updatable=true)
    public String getMessage() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.message;
    }

    public void setMessage(String message) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.message = message;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="defaultEventType", updatable=true)
    public String getDefaultEventType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.defaultEventType;
    }

    public void setDefaultEventType(String defaultEventType) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.defaultEventType = defaultEventType;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="userAgent", updatable=true)
    public String getUserAgent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.userAgent = userAgent;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Transient
    @Deprecated
    public String getUserIP() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.userIP;
    }

    @Deprecated
    public void setUserIP(String userIP) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.userIP = userIP;
    }

    @OneToMany(mappedBy="session", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    protected Set<Event> getEvents() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.events;
    }

    protected void setEvents(Set<Event> events) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.events = events;
    }

    public int sizeOfEvents() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.events == null ? -1 : this.events.size();
    }

    public Iterator<Event> iterateEvents() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            return new EmptyIterator<Event>();
        }
        return this.getEvents().iterator();
    }

    public Collection<Event> unmodifiableEvents() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getEvents());
    }

    public <E> List<E> collectEvents(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Event> it = this.iterateEvents();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addEvent(Event target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            this.throwNullCollectionException("Events");
        }
        this.getEvents().add(target);
        if (target != null) {
            target.setSession(this);
        }
    }

    public void addEventSet(Collection<Event> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            this.throwNullCollectionException("Events");
        }
        this.getEvents().addAll(targets);
        for (Event target : targets) {
            if (target == null) continue;
            target.setSession(this);
        }
    }

    public void removeEvent(Event target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            this.throwNullCollectionException("Events");
        }
        this.getEvents().remove(target);
        target.setSession(null);
    }

    public void removeEventSet(Collection<Event> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            this.throwNullCollectionException("Events");
        }
        this.getEvents().removeAll(targets);
        for (Event target : targets) {
            target.setSession(null);
        }
    }

    public void clearEvents() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEvents() == null) {
            this.throwNullCollectionException("Events");
        }
        this.getEvents().clear();
        Iterator<Event> it = this.iterateEvents();
        while (it.hasNext()) {
            Event target = it.next();
            target.setSession(null);
        }
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="session_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="session_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="session_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="session_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<SessionAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<SessionAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<SessionAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<SessionAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<SessionAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<SessionAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addSessionAnnotationLink(SessionAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addSessionAnnotationLinkSet(Collection<SessionAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (SessionAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeSessionAnnotationLink(SessionAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeSessionAnnotationLinkSet(Collection<SessionAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (SessionAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public SessionAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        SessionAnnotationLink link = new SessionAnnotationLink();
        link.link(this, addition);
        this.addSessionAnnotationLink(link, true);
        return link;
    }

    public void addSessionAnnotationLink(SessionAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<SessionAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                SessionAnnotationLink link = (SessionAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<SessionAnnotationLink> findSessionAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<SessionAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<SessionAnnotationLink> result = new HashSet<SessionAnnotationLink>();
        while (it.hasNext()) {
            SessionAnnotationLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<SessionAnnotationLink> toRemove = this.findSessionAnnotationLink(removal);
        Iterator<SessionAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeSessionAnnotationLink(it.next(), true);
        }
    }

    public void removeSessionAnnotationLink(SessionAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<SessionAnnotationLink> list = new ArrayList<SessionAnnotationLink>(this.getAnnotationLinks());
        for (SessionAnnotationLink link : list) {
            this.removeSessionAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Session_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Session_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Session_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Session newInstance() {
        return new Session();
    }

    public Session proxy() {
        return new Session(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.node = (Node)__filter.filter(NODE, this.node);
            this.uuid = (String)__filter.filter(UUID, this.uuid);
            this.owner = (Experimenter)__filter.filter(OWNER, this.owner);
            this.sudoer = (Experimenter)__filter.filter(SUDOER, this.sudoer);
            this.timeToIdle = (Long)__filter.filter(TIMETOIDLE, this.timeToIdle);
            this.timeToLive = (Long)__filter.filter(TIMETOLIVE, this.timeToLive);
            this.started = (Timestamp)__filter.filter(STARTED, this.started);
            this.closed = (Timestamp)__filter.filter(CLOSED, this.closed);
            this.message = (String)__filter.filter(MESSAGE, this.message);
            this.defaultEventType = (String)__filter.filter(DEFAULTEVENTTYPE, this.defaultEventType);
            this.userAgent = (String)__filter.filter(USERAGENT, this.userAgent);
            this.userIP = (String)__filter.filter(USERIP, this.userIP);
            this.events = (Set)__filter.filter(EVENTS, this.events);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NODE)) {
            return this.getNode();
        }
        if (field.equals(UUID)) {
            return this.getUuid();
        }
        if (field.equals(OWNER)) {
            return this.getOwner();
        }
        if (field.equals(SUDOER)) {
            return this.getSudoer();
        }
        if (field.equals(TIMETOIDLE)) {
            return this.getTimeToIdle();
        }
        if (field.equals(TIMETOLIVE)) {
            return this.getTimeToLive();
        }
        if (field.equals(STARTED)) {
            return this.getStarted();
        }
        if (field.equals(CLOSED)) {
            return this.getClosed();
        }
        if (field.equals(MESSAGE)) {
            return this.getMessage();
        }
        if (field.equals(DEFAULTEVENTTYPE)) {
            return this.getDefaultEventType();
        }
        if (field.equals(USERAGENT)) {
            return this.getUserAgent();
        }
        if (field.equals(USERIP)) {
            return this.getUserIP();
        }
        if (field.equals(EVENTS)) {
            return this.getEvents();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NODE)) {
            this.setNode((Node)value);
        } else if (field.equals(UUID)) {
            this.setUuid((String)value);
        } else if (field.equals(OWNER)) {
            this.setOwner((Experimenter)value);
        } else if (field.equals(SUDOER)) {
            this.setSudoer((Experimenter)value);
        } else if (field.equals(TIMETOIDLE)) {
            this.setTimeToIdle((Long)value);
        } else if (field.equals(TIMETOLIVE)) {
            this.setTimeToLive((Long)value);
        } else if (field.equals(STARTED)) {
            this.setStarted((Timestamp)value);
        } else if (field.equals(CLOSED)) {
            this.setClosed((Timestamp)value);
        } else if (field.equals(MESSAGE)) {
            this.setMessage((String)value);
        } else if (field.equals(DEFAULTEVENTTYPE)) {
            this.setDefaultEventType((String)value);
        } else if (field.equals(USERAGENT)) {
            this.setUserAgent((String)value);
        } else if (field.equals(USERIP)) {
            this.setUserIP((String)value);
        } else if (field.equals(EVENTS)) {
            this.setEvents((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.node = null;
        this.uuid = null;
        this.owner = null;
        this.sudoer = null;
        this.timeToIdle = null;
        this.timeToLive = null;
        this.started = null;
        this.closed = null;
        this.message = null;
        this.defaultEventType = null;
        this.userAgent = null;
        this.userIP = null;
        this.events = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(NODE);
        raw.add(UUID);
        raw.add(OWNER);
        raw.add(SUDOER);
        raw.add(TIMETOIDLE);
        raw.add(TIMETOLIVE);
        raw.add(STARTED);
        raw.add(CLOSED);
        raw.add(MESSAGE);
        raw.add(DEFAULTEVENTTYPE);
        raw.add(USERAGENT);
        raw.add(USERIP);
        raw.add(EVENTS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKsession_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

