/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import omero.grid.ImportProcessPrx;
import omero.model.Fileset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContainer {
    private static final Logger log = LoggerFactory.getLogger(ProcessContainer.class);
    private final LoadingCache<Long, Data> perGroup = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, Data>(){

        public Data load(Long group) {
            return new Data();
        }
    });

    private Data getOrCreate(Long group) {
        try {
            return (Data)this.perGroup.get((Object)group);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void addProcess(Process process) {
        Data data = this.getOrCreate(process.getGroup());
        data.add(process);
    }

    public void removeProcess(Process process) {
        Data data = this.getOrCreate(process.getGroup());
        if (data != null) {
            data.remove(process);
        }
    }

    public List<Process> listProcesses(Collection<Long> groups) {
        if (groups == null) {
            groups = this.perGroup.asMap().keySet();
        }
        ArrayList<Process> rv = new ArrayList<Process>();
        for (Long group : groups) {
            Data d = this.getOrCreate(group);
            if (d == null) continue;
            d.fill(rv);
        }
        return rv;
    }

    public int pingAll() {
        List<Process> processes = this.listProcesses(null);
        int errors = 0;
        for (Process process : processes) {
            try {
                process.ping();
            }
            catch (Throwable t) {
                ++errors;
                log.info(String.format("Removing process [%s] due to error: %s", process, t));
                log.debug(t.toString());
            }
        }
        return errors;
    }

    public int shutdownAll() {
        List<Process> processes = this.listProcesses(null);
        int errors = 0;
        for (Process process : processes) {
            try {
                process.shutdown();
            }
            catch (Throwable t) {
                ++errors;
                log.error("Ignoring error on process shutdown", t);
            }
        }
        return errors;
    }

    private static final class Data {
        private static final MapMaker mapMaker = new MapMaker();
        private final Map<Process, Object> processes = mapMaker.makeMap();

        private Data() {
        }

        void add(Process process) {
            this.processes.put(process, process);
        }

        void remove(Process process) {
            this.processes.remove(process);
        }

        void fill(List<Process> toFill) {
            for (Process process : this.processes.keySet()) {
                toFill.add(process);
            }
        }
    }

    public static interface Process {
        public ImportProcessPrx getProxy();

        public Fileset getFileset();

        public long getGroup();

        public void ping();

        public void shutdown();
    }
}

