/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ome.conditions.InternalException;
import ome.model.IObject;
import ome.model.enums.AdminPrivilege;
import ome.security.ACLVoter;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.messages.EventLogMessage;
import omero.cmd.ERR;
import omero.cmd.Helper;
import omero.cmd.graphs.ChildOption;
import omero.cmd.graphs.ChildOptionI;
import omero.cmd.graphs.ChildOptionsPolicy;
import omero.cmd.graphs.GraphUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class GraphHelper {
    private final Helper helper;
    private final GraphPathBean graphPathBean;

    public GraphHelper(Helper helper, GraphPathBean graphPathBean) {
        this.helper = helper;
        this.graphPathBean = graphPathBean;
    }

    public boolean checkIsAdministrator(AdminPrivilege requiredPrivilege) {
        return this.helper.getEventContext().getCurrentAdminPrivileges().contains(requiredPrivilege);
    }

    public Set<Class<? extends IObject>> getClassesFromNames(Collection<String> classNames) {
        if (CollectionUtils.isEmpty(classNames)) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends IObject>> classes = new HashSet<Class<? extends IObject>>();
        for (String className : classNames) {
            Class<? extends IObject> actualClass;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                className = className.substring(lastDot + 1);
            }
            if ((actualClass = this.graphPathBean.getClassForSimpleName(className)) == null) {
                throw new IllegalArgumentException("unknown model object class named: " + className);
            }
            classes.add(actualClass);
        }
        return classes;
    }

    public GraphTraversal prepareGraphTraversal(List<ChildOption> childOptions, Set<GraphPolicy.Ability> requiredPermissions, GraphPolicy graphPolicy, Iterable<Function<GraphPolicy, GraphPolicy>> graphPolicyAdjusters, ACLVoter aclVoter, GraphPathBean graphPathBean, SetMultimap<String, String> unnullable, GraphTraversal.Processor processor, boolean dryRun) {
        if (childOptions != null) {
            List<ChildOptionI> childOptionsI = ChildOptionI.castChildOptions(childOptions);
            for (ChildOptionI childOption : childOptionsI) {
                childOption.init();
            }
            graphPolicy = ChildOptionsPolicy.getChildOptionsPolicy(graphPolicy, childOptionsI, requiredPermissions);
        }
        for (Function<GraphPolicy, GraphPolicy> adjuster : graphPolicyAdjusters) {
            graphPolicy = adjuster.apply(graphPolicy);
        }
        if (dryRun) {
            processor = GraphUtil.disableProcessor(processor);
        }
        return new GraphTraversal(this.helper.getSession(), this.helper.getEventContext(), aclVoter, graphPathBean, unnullable, graphPolicy, processor);
    }

    public Set<String> getTargetSet(Set<Class<? extends IObject>> legalClasses, Collection<String> targetClasses) {
        HashSet<String> targetSet = new HashSet<String>();
        for (String targetClassName : targetClasses) {
            int lastDot = targetClassName.lastIndexOf(46);
            if (lastDot > 0) {
                targetClassName = targetClassName.substring(lastDot + 1);
            }
            Class<? extends IObject> targetObjectClass = this.graphPathBean.getClassForSimpleName(targetClassName);
            Iterator<Class<? extends IObject>> legalClassesIterator = legalClasses.iterator();
            do {
                if (legalClassesIterator.hasNext()) continue;
                IllegalArgumentException e = new IllegalArgumentException("cannot target " + targetClassName);
                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-target", new String[0]);
            } while (!legalClassesIterator.next().isAssignableFrom(targetObjectClass));
            targetSet.add(targetObjectClass.getName());
        }
        return targetSet;
    }

    public SetMultimap<String, Long> getTargetMultimap(Set<Class<? extends IObject>> legalClasses, Map<String, List<Long>> targetObjects) {
        HashMultimap targetMultimap = HashMultimap.create();
        for (Map.Entry<String, List<Long>> oneClassToTarget : targetObjects.entrySet()) {
            String targetObjectClassName = oneClassToTarget.getKey();
            int lastDot = targetObjectClassName.lastIndexOf(46);
            if (lastDot > 0) {
                targetObjectClassName = targetObjectClassName.substring(lastDot + 1);
            }
            Class<? extends IObject> targetObjectClass = this.graphPathBean.getClassForSimpleName(targetObjectClassName);
            Iterator<Class<? extends IObject>> legalClassesIterator = legalClasses.iterator();
            do {
                if (legalClassesIterator.hasNext()) continue;
                IllegalArgumentException e = new IllegalArgumentException("cannot target " + targetObjectClassName);
                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-target", new String[0]);
            } while (!legalClassesIterator.next().isAssignableFrom(targetObjectClass));
            Collection ids = oneClassToTarget.getValue();
            targetMultimap.putAll((Object)targetObjectClass.getName(), (Iterable)ids);
        }
        return targetMultimap;
    }

    public Set<String> getTopLevelNames(Iterable<Class<? extends IObject>> modelClasses) {
        HashSet<String> classNames = new HashSet<String>();
        for (Class<? extends IObject> modelClass : modelClasses) {
            Class<? extends IObject> superclass;
            while ((superclass = modelClass.getSuperclass()) != Object.class) {
                modelClass = superclass;
            }
            classNames.add(modelClass.getSimpleName());
        }
        return classNames;
    }

    public void publishEventLog(ApplicationContext context, String action, String className, Collection<Long> ids) {
        Class<IObject> actualClass;
        try {
            actualClass = Class.forName(className).asSubclass(IObject.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalException("reference to unknown model class " + className + ": " + cnfe);
        }
        context.publishEvent((ApplicationEvent)new EventLogMessage(this, action, actualClass, (List<Long>)ImmutableList.copyOf(ids)));
    }
}

