/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationMDArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationReader;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.IHDF5TimeDurationWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.HDFNativeData;

public class HDF5TimeDurationWriter
extends HDF5TimeDurationReader
implements IHDF5TimeDurationWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5TimeDurationWriter(HDF5BaseWriter baseWriter, HDF5LongReader longReader) {
        super(baseWriter, longReader);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(final String objectPath, final String name, final long timeDuration, final HDF5TimeUnit timeUnit) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createSimpleDataSpace(new long[]{1L}, registry);
                    HDF5TimeDurationWriter.this.baseWriter.setAttribute(objectPath, name, timeUnit.getTypeVariant(), HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, dataSpaceId, new long[]{timeDuration}, registry);
                } else {
                    HDF5TimeDurationWriter.this.baseWriter.setAttribute(objectPath, name, timeUnit.getTypeVariant(), HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, -1L, new long[]{timeDuration}, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setAttr(String objectPath, String name, HDF5TimeDuration timeDuration) {
        this.setAttr(objectPath, name, timeDuration.getValue(), timeDuration.getUnit());
    }

    @Override
    public void setArrayAttr(final String objectPath, final String name, final HDF5TimeDurationArray timeDurations) {
        assert (objectPath != null);
        assert (name != null);
        assert (timeDurations != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createSimpleDataSpace(new long[]{timeDurations.timeDurations.length}, registry);
                    HDF5TimeDurationWriter.this.baseWriter.setAttribute(objectPath, name, timeDurations.timeUnit.getTypeVariant(), HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, dataSpaceId, timeDurations.timeDurations, registry);
                } else {
                    long memoryTypeId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, timeDurations.timeDurations.length, registry);
                    long storageTypeId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, timeDurations.timeDurations.length, registry);
                    HDF5TimeDurationWriter.this.baseWriter.setAttribute(objectPath, name, timeDurations.timeUnit.getTypeVariant(), storageTypeId, memoryTypeId, -1L, timeDurations.timeDurations, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(final String objectPath, final String attributeName, final HDF5TimeDurationMDArray timeDurations) {
        assert (objectPath != null);
        assert (attributeName != null);
        assert (timeDurations != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createSimpleDataSpace(timeDurations.timeDurations.longDimensions(), registry);
                    HDF5TimeDurationWriter.this.baseWriter.setAttribute(objectPath, attributeName, timeDurations.timeUnit.getTypeVariant(), HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, dataSpaceId, timeDurations.timeDurations.getAsFlatArray(), registry);
                } else {
                    long memoryTypeId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, timeDurations.timeDurations.dimensions(), registry);
                    long storageTypeId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, timeDurations.timeDurations.dimensions(), registry);
                    HDF5TimeDurationWriter.this.baseWriter.setAttribute(objectPath, attributeName, timeDurations.timeUnit.getTypeVariant(), storageTypeId, memoryTypeId, -1L, timeDurations.timeDurations.getAsFlatArray(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void writeTimeDuration(String objectPath, long timeDuration) {
        this.write(objectPath, timeDuration, HDF5TimeUnit.SECONDS);
    }

    @Override
    public void write(final String objectPath, final long timeDuration, final HDF5TimeUnit timeUnit) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                long dataSetId = HDF5TimeDurationWriter.this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, HDFNativeData.longToByte(timeDuration), true, true, registry);
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeScalarRunnable);
    }

    @Override
    public void write(String objectPath, HDF5TimeDuration timeDuration) {
        this.write(objectPath, timeDuration.getValue(), timeDuration.getUnit());
    }

    @Override
    public void createArray(String objectPath, int size, HDF5TimeUnit timeUnit) {
        this.createArray(objectPath, size, timeUnit, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, long size, int blockSize, HDF5TimeUnit timeUnit) {
        this.createArray(objectPath, size, blockSize, timeUnit, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArray(final String objectPath, final int size, final HDF5TimeUnit timeUnit, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = features.requiresChunking() ? HDF5TimeDurationWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[1], new long[]{size}, 8, registry) : HDF5TimeDurationWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{size}, null, 8, registry);
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(final String objectPath, final long size, final int blockSize, final HDF5TimeUnit timeUnit, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5TimeDurationWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeDurationArray(String objectPath, long[] timeDurations) {
        this.writeTimeDurationArray(objectPath, timeDurations, HDF5TimeUnit.SECONDS, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeArray(String objectPath, HDF5TimeDurationArray timeDurations) {
        this.writeArray(objectPath, timeDurations, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final HDF5TimeDurationArray timeDurations, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (timeDurations != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5TimeDurationWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_I64LE, new long[]{timeDurations.timeDurations.length}, 8, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, timeDurations.timeDurations);
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, timeDurations.timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeDurationArray(String objectPath, long[] timeDurations, HDF5TimeUnit timeUnit) {
        this.writeTimeDurationArray(objectPath, timeDurations, timeUnit, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeTimeDurationArray(String objectPath, long[] timeDurations, HDF5TimeUnit timeUnit, HDF5IntStorageFeatures features) {
        this.writeArray(objectPath, new HDF5TimeDurationArray(timeDurations, timeUnit));
    }

    public void writeTimeDurationArray(String objectPath, HDF5TimeDuration[] timeDurations) {
        this.writeTimeDurationArray(objectPath, timeDurations, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeTimeDurationArray(String objectPath, HDF5TimeDuration[] timeDurations, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (timeDurations != null);
        if (timeDurations.length == 0) {
            return;
        }
        HDF5TimeDurationArray durations = HDF5TimeDurationArray.create(timeDurations);
        this.writeArray(objectPath, durations);
    }

    @Override
    public void writeArrayBlock(String objectPath, HDF5TimeDurationArray data, long blockNumber) {
        this.writeArrayBlockWithOffset(objectPath, data, data.getLength(), (long)data.getLength() * blockNumber);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final HDF5TimeDurationArray data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                long dataSetId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.fileId, objectPath, ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, false, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationWriter.this.baseWriter.checkIsTimeDuration(objectPath, dataSetId, registry);
                long dataSpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                long memorySpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, storedUnit.convert(data));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeTimeDurationArrayBlock(String objectPath, long[] data, long blockNumber, HDF5TimeUnit timeUnit) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber, timeUnit);
    }

    public void writeTimeDurationArrayBlockWithOffset(String objectPath, long[] data, int dataSize, long offset, HDF5TimeUnit timeUnit) {
        this.writeArrayBlockWithOffset(objectPath, new HDF5TimeDurationArray(data, timeUnit), dataSize, offset);
    }

    public void writeTimeDurationArrayBlock(String objectPath, HDF5TimeDuration[] data, long blockNumber) {
        this.writeTimeDurationArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeTimeDurationArrayBlockWithOffset(String objectPath, HDF5TimeDuration[] data, int dataSize, long offset) {
        this.writeArrayBlockWithOffset(objectPath, HDF5TimeDurationArray.create(data), dataSize, offset);
    }

    @Override
    public void writeMDArray(final String objectPath, final HDF5TimeDurationMDArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5TimeDurationWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, data.longDimensions(), 8, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, data.timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArray(String objectPath, HDF5TimeDurationMDArray data) {
        this.writeMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, int[] dimensions, HDF5TimeUnit timeUnit) {
        this.createMDArray(objectPath, dimensions, timeUnit, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5TimeUnit timeUnit) {
        this.createMDArray(objectPath, dimensions, blockDimensions, timeUnit, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(final String objectPath, final int[] dimensions, final HDF5TimeUnit timeUnit, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId;
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    dataSetId = HDF5TimeDurationWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, nullDimensions, MDArray.toLong((int[])dimensions), 8, registry);
                } else {
                    dataSetId = HDF5TimeDurationWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, MDArray.toLong((int[])dimensions), null, 8, registry);
                }
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5TimeUnit timeUnit, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5TimeDurationWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, dimensions, MDArray.toLong((int[])blockDimensions), 8, registry);
                HDF5TimeDurationWriter.this.baseWriter.setTypeVariant(dataSetId, timeUnit.getTypeVariant(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, HDF5TimeDurationMDArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final HDF5TimeDurationMDArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                long dataSetId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.fileId, objectPath, ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.fileFormat, dataSetDimensions, false, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationWriter.this.baseWriter.checkIsTimeDuration(objectPath, dataSetId, registry);
                long dataSpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                long memorySpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray(storedUnit));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final HDF5TimeDurationMDArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong((int[])blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                long dataSetId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.fileId, objectPath, ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.fileFormat, dataSetDimensions, false, registry);
                long dataSpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationWriter.this.baseWriter.checkIsTimeDuration(objectPath, dataSetId, registry);
                ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                long memorySpaceId = ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5TimeDurationWriter)HDF5TimeDurationWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong((int[])memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray(storedUnit));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

