/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;

public final class MatrixUtils {
    private MatrixUtils() {
    }

    public static int[] dims(int ... dim) {
        return dim;
    }

    public static long[] dims(long ... dim) {
        return dim;
    }

    public static long[] ldims(long ... dim) {
        return dim;
    }

    static void checkMDArrayDimensions(String name, int[] dimensions, MDAbstractArray<?> array) {
        if (!Arrays.equals(dimensions, array.dimensions())) {
            throw new IllegalArgumentException("The member '" + name + "' has dimensions " + Arrays.toString(array.dimensions()) + " but is supposed to have dimensions " + Arrays.toString(dimensions) + ".");
        }
    }

    static void checkMatrixDimensions(String name, int[] dimensions, Object matrix) {
        int dimX = Array.getLength(matrix);
        int dimY = Array.getLength(Array.get(matrix, 0));
        if (dimensions.length != 2 || dimensions[0] != dimX || dimensions[1] != dimY) {
            throw new IllegalArgumentException("The member '" + name + "' has dimensions [" + dimX + "," + dimY + "]." + " but is supposed to have dimensions " + Arrays.toString(dimensions) + ".");
        }
    }

    static float[] flatten(float[][] matrix) {
        if (matrix.length == 0) {
            throw new IllegalArgumentException("Matrix must not have a length of 0.");
        }
        int dimY = matrix.length;
        int dimX = matrix[0].length;
        int i = 1;
        while (i < dimY) {
            if (matrix[i].length != dimX) {
                throw new IllegalArgumentException("All rows in matrix need to have the same number of columns.");
            }
            ++i;
        }
        float[] result = new float[dimX * dimY];
        int i2 = 0;
        while (i2 < dimY) {
            System.arraycopy(matrix[i2], 0, result, i2 * dimX, dimX);
            ++i2;
        }
        return result;
    }

    static float[][] shapen(float[] matrixData, int[] dims) {
        int dimY = dims[0];
        int dimX = dims[1];
        float[][] result = new float[dimY][dimX];
        int i = 0;
        while (i < dimY) {
            System.arraycopy(matrixData, i * dimX, result[i], 0, dimX);
            ++i;
        }
        return result;
    }

    static double[] flatten(double[][] matrix) {
        if (matrix.length == 0) {
            throw new IllegalArgumentException("Matrix must not have a length of 0.");
        }
        int dimY = matrix.length;
        int dimX = matrix[0].length;
        int i = 1;
        while (i < dimY) {
            if (matrix[i].length != dimX) {
                throw new IllegalArgumentException("All rows in matrix need to have the same number of columns.");
            }
            ++i;
        }
        double[] result = new double[dimX * dimY];
        int i2 = 0;
        while (i2 < dimY) {
            System.arraycopy(matrix[i2], 0, result, i2 * dimX, dimX);
            ++i2;
        }
        return result;
    }

    static double[][] shapen(double[] matrixData, int[] dims) {
        int dimY = dims[0];
        int dimX = dims[1];
        double[][] result = new double[dimY][dimX];
        int i = 0;
        while (i < dimY) {
            System.arraycopy(matrixData, i * dimX, result[i], 0, dimX);
            ++i;
        }
        return result;
    }

    static int[] flatten(int[][] matrix) {
        if (matrix.length == 0) {
            throw new IllegalArgumentException("Matrix must not have a length of 0.");
        }
        int dimY = matrix.length;
        int dimX = matrix[0].length;
        int i = 1;
        while (i < dimY) {
            if (matrix[i].length != dimX) {
                throw new IllegalArgumentException("All rows in matrix need to have the same number of columns.");
            }
            ++i;
        }
        int[] result = new int[dimX * dimY];
        int i2 = 0;
        while (i2 < dimY) {
            System.arraycopy(matrix[i2], 0, result, i2 * dimX, dimX);
            ++i2;
        }
        return result;
    }

    static int[][] shapen(int[] matrixData, int[] dims) {
        int dimY = dims[0];
        int dimX = dims[1];
        int[][] result = new int[dimY][dimX];
        int i = 0;
        while (i < dimY) {
            System.arraycopy(matrixData, i * dimX, result[i], 0, dimX);
            ++i;
        }
        return result;
    }

    static long[] flatten(long[][] matrix) {
        if (matrix.length == 0) {
            throw new IllegalArgumentException("Matrix must not have a length of 0.");
        }
        int dimY = matrix.length;
        int dimX = matrix[0].length;
        int i = 1;
        while (i < dimY) {
            if (matrix[i].length != dimX) {
                throw new IllegalArgumentException("All rows in matrix need to have the same number of columns.");
            }
            ++i;
        }
        long[] result = new long[dimX * dimY];
        int i2 = 0;
        while (i2 < dimY) {
            System.arraycopy(matrix[i2], 0, result, i2 * dimX, dimX);
            ++i2;
        }
        return result;
    }

    static long[][] shapen(long[] matrixData, int[] dims) {
        int dimY = dims[0];
        int dimX = dims[1];
        long[][] result = new long[dimY][dimX];
        int i = 0;
        while (i < dimY) {
            System.arraycopy(matrixData, i * dimX, result[i], 0, dimX);
            ++i;
        }
        return result;
    }

    static short[] flatten(short[][] matrix) {
        if (matrix.length == 0) {
            throw new IllegalArgumentException("Matrix must not have a length of 0.");
        }
        int dimY = matrix.length;
        int dimX = matrix[0].length;
        int i = 1;
        while (i < dimY) {
            if (matrix[i].length != dimX) {
                throw new IllegalArgumentException("All rows in matrix need to have the same number of columns.");
            }
            ++i;
        }
        short[] result = new short[dimX * dimY];
        int i2 = 0;
        while (i2 < dimY) {
            System.arraycopy(matrix[i2], 0, result, i2 * dimX, dimX);
            ++i2;
        }
        return result;
    }

    static short[][] shapen(short[] matrixData, int[] dims) {
        int dimY = dims[0];
        int dimX = dims[1];
        short[][] result = new short[dimY][dimX];
        int i = 0;
        while (i < dimY) {
            System.arraycopy(matrixData, i * dimX, result[i], 0, dimX);
            ++i;
        }
        return result;
    }

    static byte[] flatten(byte[][] matrix) {
        if (matrix.length == 0) {
            throw new IllegalArgumentException("Matrix must not have a length of 0.");
        }
        int dimY = matrix.length;
        int dimX = matrix[0].length;
        int i = 1;
        while (i < dimY) {
            if (matrix[i].length != dimX) {
                throw new IllegalArgumentException("All rows in matrix need to have the same number of columns.");
            }
            ++i;
        }
        byte[] result = new byte[dimX * dimY];
        int i2 = 0;
        while (i2 < dimY) {
            System.arraycopy(matrix[i2], 0, result, i2 * dimX, dimX);
            ++i2;
        }
        return result;
    }

    static byte[][] shapen(byte[] matrixData, int[] dims) {
        int dimY = dims[0];
        int dimX = dims[1];
        byte[][] result = new byte[dimY][dimX];
        int i = 0;
        while (i < dimY) {
            System.arraycopy(matrixData, i * dimX, result[i], 0, dimX);
            ++i;
        }
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static boolean incrementIdx(int[] idx, int[] dims, int[] offset) {
        block4: {
            int n;
            int d;
            block3: {
                d = idx.length - 1;
                if (!true) break block3;
                n = --d;
                if ((idx[n] = idx[n] + 1) < offset[d] + dims[d]) break block4;
            }
            do {
                idx[d] = offset[d];
                if (d == 0) {
                    return false;
                }
                n = --d;
            } while ((idx[n] = idx[n] + 1) >= offset[d] + dims[d]);
        }
        return true;
    }

    static int[] concat(int[] array1, int[] array2) {
        if (array1.length == 0) {
            return array2;
        }
        if (array2.length == 0) {
            return array1;
        }
        int[] result = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    static long[] concat(long[] array1, int[] array2) {
        if (array1.length == 0) {
            return MDArray.toLong((int[])array2);
        }
        if (array2.length == 0) {
            return array1;
        }
        long[] result = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        int i = 0;
        while (i < array2.length) {
            result[array1.length + i] = array2[i];
            ++i;
        }
        return result;
    }

    static int cardinalityBoundIndices(Map<?, ?> boundIndices) {
        return boundIndices.size();
    }

    static int cardinalityBoundIndices(long[] boundIndices) {
        int card = 0;
        int i = 0;
        while (i < boundIndices.length) {
            if (boundIndices[i] >= 0L) {
                ++card;
            }
            ++i;
        }
        return card;
    }

    static void createFullBlockDimensionsAndOffset(int[] blockDimensions, long[] offsetOrNull, Map<Integer, Long> boundIndices, long[] fullDimensions, int[] fullBlockDimensions, long[] fullOffset) {
        MatrixUtils.createFullBlockDimensionsAndOffset(blockDimensions, offsetOrNull, boundIndices, fullDimensions.length, fullDimensions, fullBlockDimensions, fullOffset);
    }

    static void createFullBlockDimensionsAndOffset(int[] blockDimensions, long[] offsetOrNull, Map<Integer, Long> boundIndices, int fullRank, int[] fullBlockDimensions, long[] fullOffset) {
        MatrixUtils.createFullBlockDimensionsAndOffset(blockDimensions, offsetOrNull, boundIndices, fullRank, null, fullBlockDimensions, fullOffset);
    }

    static void createFullBlockDimensionsAndOffset(int[] blockDimensions, long[] offsetOrNull, Map<Integer, Long> boundIndices, int fullRank, long[] fullDimensionsOrNull, int[] fullBlockDimensions, long[] fullOffset) {
        int j = 0;
        int i = 0;
        while (i < fullRank) {
            Long boundIndexOrNull = boundIndices.get(i);
            if (boundIndexOrNull == null) {
                if (blockDimensions[j] < 0 && fullDimensionsOrNull != null) {
                    blockDimensions[j] = (int)fullDimensionsOrNull[i];
                }
                fullBlockDimensions[i] = blockDimensions[j];
                fullOffset[i] = offsetOrNull == null ? 0L : offsetOrNull[j];
                ++j;
            } else {
                fullBlockDimensions[i] = 1;
                fullOffset[i] = boundIndexOrNull;
            }
            ++i;
        }
    }

    static void createFullBlockDimensionsAndOffset(int[] blockDimensions, long[] offsetOrNull, long[] boundIndices, long[] fullDimensions, int[] fullBlockDimensions, long[] fullOffset) {
        MatrixUtils.createFullBlockDimensionsAndOffset(blockDimensions, offsetOrNull, boundIndices, fullDimensions.length, fullDimensions, fullBlockDimensions, fullOffset);
    }

    static void createFullBlockDimensionsAndOffset(int[] blockDimensions, long[] offsetOrNull, long[] boundIndices, int fullRank, int[] fullBlockDimensions, long[] fullOffset) {
        MatrixUtils.createFullBlockDimensionsAndOffset(blockDimensions, offsetOrNull, boundIndices, fullRank, null, fullBlockDimensions, fullOffset);
    }

    static void createFullBlockDimensionsAndOffset(int[] blockDimensions, long[] offsetOrNull, long[] boundIndices, int fullRank, long[] fullDimensionsOrNull, int[] fullBlockDimensions, long[] fullOffset) {
        int j = 0;
        int i = 0;
        while (i < fullRank) {
            long boundIndex = boundIndices[i];
            if (boundIndex < 0L) {
                if (blockDimensions[j] < 0 && fullDimensionsOrNull != null) {
                    blockDimensions[j] = (int)fullDimensionsOrNull[i];
                }
                fullBlockDimensions[i] = blockDimensions[j];
                fullOffset[i] = offsetOrNull == null ? 0L : offsetOrNull[j];
                ++j;
            } else {
                fullBlockDimensions[i] = 1;
                fullOffset[i] = boundIndex;
            }
            ++i;
        }
    }

    static void checkBoundIndices(String objectPath, long[] dimensions, int cardBoundIndices) throws HDF5JavaException {
        if (cardBoundIndices > dimensions.length) {
            throw new HDF5JavaException("Dataset " + objectPath + ": more bound indices (#" + cardBoundIndices + ") than dataset dimensions (#" + dimensions.length + ")");
        }
    }

    static void checkBoundIndices(String objectPath, long[] dimensions, long[] boundIndices) throws HDF5JavaException {
        if (dimensions.length != boundIndices.length) {
            throw new HDF5JavaException("Dataset " + objectPath + ": boundIndices array (#" + boundIndices.length + ") differs from dataset dimensions (#" + dimensions.length + ")");
        }
    }

    static void checkBoundIndices(String objectPath, long[] dimensions, int[] blockDimensions, int cardBoundIndices) throws HDF5JavaException {
        if (dimensions.length != blockDimensions.length + cardBoundIndices) {
            throw new HDF5JavaException("Dataset " + objectPath + ": cardinality of bound indices (#" + cardBoundIndices + ") plus rank of blocks (#" + blockDimensions.length + ") not equal to rank of dataset (#" + dimensions.length + ")");
        }
    }
}

