/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.sql.SQLException;
import java.util.Collection;
import ome.conditions.ApiUsageException;
import ome.parameters.Parameters;
import ome.services.query.Definitions;
import ome.services.query.Query;
import ome.services.query.QueryException;
import ome.services.query.QueryParameterDef;
import ome.util.SqlAction;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class StringQuery
extends Query {
    public static final String STRING = "::string::";
    static Definitions defs = new Definitions(new QueryParameterDef("::string::", String.class, false));
    private final SqlAction sql;

    public StringQuery(Parameters parameters) {
        this((SqlAction)null, parameters);
    }

    public StringQuery(SqlAction sql, Parameters parameters) {
        super(defs, parameters);
        this.sql = sql;
    }

    @Override
    protected void buildQuery(Session session) throws HibernateException, SQLException {
        org.hibernate.Query query;
        String queryString = (String)this.value(STRING);
        if (this.sql != null) {
            for (String key : this.params.keySet()) {
                if (STRING.equals(key)) continue;
                queryString = this.sql.rewriteHql(queryString, key, this.value(key));
            }
        }
        try {
            query = session.createQuery(queryString);
        }
        catch (Exception e) {
            throw new QueryException("Illegal query:" + this.value(STRING) + "\n" + e.getMessage());
        }
        String[] nParams = query.getNamedParameters();
        for (int i = 0; i < nParams.length; ++i) {
            String p = nParams[i];
            Object v = this.value(p);
            if (v == null) {
                throw new ApiUsageException("Null parameters not allowed: " + p);
            }
            if (Collection.class.isAssignableFrom(v.getClass())) {
                query.setParameterList(p, (Collection)v);
                continue;
            }
            query.setParameter(p, v);
        }
        this.setQuery(query);
    }
}

