/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;

public class FilterHelpers {
    public static Array bytesToArray(byte[] in, DataType type, ByteOrder order) {
        return Array.factory(type, new int[]{in.length / type.getSize()}, FilterHelpers.convertToType(in, type, order));
    }

    public static byte[] arrayToBytes(Array arr, DataType type, ByteOrder order) {
        ByteBuffer bb = ByteBuffer.allocate((int)arr.getSize() * type.getSize());
        bb.order(order);
        IndexIterator ii = arr.getIndexIterator();
        while (ii.hasNext()) {
            switch (type) {
                case BYTE: 
                case UBYTE: {
                    bb.put(ii.getByteNext());
                    break;
                }
                case SHORT: 
                case USHORT: {
                    bb.putShort(ii.getShortNext());
                    break;
                }
                case INT: 
                case UINT: {
                    bb.putInt(ii.getIntNext());
                    break;
                }
                case LONG: 
                case ULONG: {
                    bb.putLong(ii.getLongNext());
                    break;
                }
                case FLOAT: {
                    bb.putFloat(ii.getFloatNext());
                    break;
                }
                case DOUBLE: {
                    bb.putDouble(ii.getDoubleNext());
                }
            }
        }
        return bb.array();
    }

    private static Object convertToType(byte[] dataIn, DataType wantType, ByteOrder bo) {
        if (wantType.getSize() == 1) {
            return dataIn;
        }
        ByteBuffer bb = ByteBuffer.wrap(dataIn);
        bb.order(bo);
        switch (wantType) {
            case SHORT: 
            case USHORT: {
                ShortBuffer sb = bb.asShortBuffer();
                short[] shortArray = new short[sb.limit()];
                sb.get(shortArray);
                return shortArray;
            }
            case INT: 
            case UINT: {
                IntBuffer ib = bb.asIntBuffer();
                int[] intArray = new int[ib.limit()];
                ib.get(intArray);
                return intArray;
            }
            case LONG: 
            case ULONG: {
                LongBuffer lb = bb.asLongBuffer();
                long[] longArray = new long[lb.limit()];
                lb.get(longArray);
                return longArray;
            }
            case FLOAT: {
                FloatBuffer fb = bb.asFloatBuffer();
                float[] floatArray = new float[fb.limit()];
                fb.get(floatArray);
                return floatArray;
            }
            case DOUBLE: {
                DoubleBuffer db = bb.asDoubleBuffer();
                double[] doubleArray = new double[db.limit()];
                db.get(doubleArray);
                return doubleArray;
            }
        }
        return bb.array();
    }

    public static DataType nextLarger(DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return DataType.SHORT;
            }
            case UBYTE: {
                return DataType.USHORT;
            }
            case SHORT: {
                return DataType.INT;
            }
            case USHORT: {
                return DataType.UINT;
            }
            case INT: {
                return DataType.LONG;
            }
            case UINT: {
                return DataType.ULONG;
            }
            case LONG: 
            case ULONG: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }

    public static DataType getAttributeDataType(Attribute attribute, DataType.Signedness signedness) {
        DataType dataType = attribute.getDataType();
        if (signedness == DataType.Signedness.UNSIGNED) {
            dataType = dataType.withSignedness(signedness);
        }
        return dataType;
    }

    public static int rank(DataType dataType) {
        if (dataType == null) {
            return -1;
        }
        switch (dataType) {
            case BYTE: {
                return 0;
            }
            case UBYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case USHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case UINT: {
                return 5;
            }
            case LONG: {
                return 6;
            }
            case ULONG: {
                return 7;
            }
            case FLOAT: {
                return 8;
            }
            case DOUBLE: {
                return 9;
            }
        }
        return -1;
    }

    public static DataType largestOf(DataType ... dataTypes) {
        DataType widest = null;
        for (DataType dataType : dataTypes) {
            if (widest == null) {
                widest = dataType;
                continue;
            }
            if (FilterHelpers.rank(dataType) <= FilterHelpers.rank(widest)) continue;
            widest = dataType;
        }
        return widest;
    }
}

