/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.EncodingVersion;
import Ice.FormatType;
import Ice.MarshalException;
import Ice.Object;
import Ice.ObjectPrx;
import Ice.OptionalFormat;
import Ice.OutputStream;
import Ice.SlicedData;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceInternal.Instance;
import IceInternal.Util;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class OutputStreamI
implements OutputStream {
    private Communicator _communicator;
    private BasicStream _os;

    public OutputStreamI(Communicator communicator) {
        this._communicator = communicator;
        Instance instance = Util.getInstance(communicator);
        this._os = new BasicStream(instance, instance.defaultsAndOverrides().defaultEncoding, false);
        this._os.closure(this);
    }

    public OutputStreamI(Communicator communicator, EncodingVersion v) {
        this._communicator = communicator;
        Instance instance = Util.getInstance(communicator);
        this._os = new BasicStream(instance, v, false);
        this._os.closure(this);
    }

    public OutputStreamI(Communicator communicator, BasicStream os) {
        this._communicator = communicator;
        this._os = os;
        this._os.closure(this);
    }

    @Override
    public Communicator communicator() {
        return this._communicator;
    }

    @Override
    public void writeBool(boolean v) {
        this._os.writeBool(v);
    }

    @Override
    public void writeBoolSeq(boolean[] v) {
        this._os.writeBoolSeq(v);
    }

    @Override
    public void writeByte(byte v) {
        this._os.writeByte(v);
    }

    @Override
    public void writeByteSeq(byte[] v) {
        this._os.writeByteSeq(v);
    }

    @Override
    public void writeByteBuffer(ByteBuffer v) {
        this._os.writeByteBuffer(v);
    }

    @Override
    public void writeSerializable(Serializable v) {
        this._os.writeSerializable(v);
    }

    @Override
    public void writeShort(short v) {
        this._os.writeShort(v);
    }

    @Override
    public void writeShortSeq(short[] v) {
        this._os.writeShortSeq(v);
    }

    @Override
    public void writeShortBuffer(ShortBuffer v) {
        this._os.writeShortBuffer(v);
    }

    @Override
    public void writeInt(int v) {
        this._os.writeInt(v);
    }

    @Override
    public void writeIntSeq(int[] v) {
        this._os.writeIntSeq(v);
    }

    @Override
    public void writeIntBuffer(IntBuffer v) {
        this._os.writeIntBuffer(v);
    }

    @Override
    public void writeLong(long v) {
        this._os.writeLong(v);
    }

    @Override
    public void writeLongSeq(long[] v) {
        this._os.writeLongSeq(v);
    }

    @Override
    public void writeLongBuffer(LongBuffer v) {
        this._os.writeLongBuffer(v);
    }

    @Override
    public void writeFloat(float v) {
        this._os.writeFloat(v);
    }

    @Override
    public void writeFloatSeq(float[] v) {
        this._os.writeFloatSeq(v);
    }

    @Override
    public void writeFloatBuffer(FloatBuffer v) {
        this._os.writeFloatBuffer(v);
    }

    @Override
    public void writeDouble(double v) {
        this._os.writeDouble(v);
    }

    @Override
    public void writeDoubleSeq(double[] v) {
        this._os.writeDoubleSeq(v);
    }

    @Override
    public void writeDoubleBuffer(DoubleBuffer v) {
        this._os.writeDoubleBuffer(v);
    }

    @Override
    public void writeString(String v) {
        this._os.writeString(v);
    }

    @Override
    public void writeStringSeq(String[] v) {
        this._os.writeStringSeq(v);
    }

    @Override
    public void writeSize(int sz) {
        if (sz < 0) {
            throw new MarshalException();
        }
        this._os.writeSize(sz);
    }

    @Override
    public void writeProxy(ObjectPrx v) {
        this._os.writeProxy(v);
    }

    @Override
    public void writeObject(Object v) {
        this._os.writeObject(v);
    }

    @Override
    public void writeEnum(int v, int maxValue) {
        this._os.writeEnum(v, maxValue);
    }

    @Override
    public void writeException(UserException v) {
        this._os.writeUserException(v);
    }

    @Override
    public void startObject(SlicedData slicedData) {
        this._os.startWriteObject(slicedData);
    }

    @Override
    public void endObject() {
        this._os.endWriteObject();
    }

    @Override
    public void startException(SlicedData slicedData) {
        this._os.startWriteException(slicedData);
    }

    @Override
    public void endException() {
        this._os.endWriteException();
    }

    @Override
    public void startSlice(String typeId, int compactId, boolean last) {
        this._os.startWriteSlice(typeId, compactId, last);
    }

    @Override
    public void endSlice() {
        this._os.endWriteSlice();
    }

    @Override
    public void startEncapsulation(EncodingVersion encoding, FormatType format) {
        this._os.startWriteEncaps(encoding, format);
    }

    @Override
    public void startEncapsulation() {
        this._os.startWriteEncaps();
    }

    @Override
    public void endEncapsulation() {
        this._os.endWriteEncapsChecked();
    }

    @Override
    public EncodingVersion getEncoding() {
        return this._os.getWriteEncoding();
    }

    @Override
    public void writePendingObjects() {
        this._os.writePendingObjects();
    }

    @Override
    public boolean writeOptional(int tag, OptionalFormat format) {
        return this._os.writeOpt(tag, format);
    }

    @Override
    public int pos() {
        return this._os.pos();
    }

    @Override
    public void rewrite(int sz, int pos) {
        this._os.rewriteInt(sz, pos);
    }

    @Override
    public int startSize() {
        return this._os.startSize();
    }

    @Override
    public void endSize(int pos) {
        this._os.endSize(pos);
    }

    @Override
    public byte[] finished() {
        Buffer buf = this._os.prepareWrite();
        byte[] result = new byte[buf.b.limit()];
        buf.b.get(result);
        return result;
    }

    @Override
    public void reset(boolean clearBuffer) {
        this._os.clear();
        Buffer buf = this._os.getBuffer();
        if (clearBuffer) {
            buf.clear();
        } else {
            buf.reset();
        }
        buf.b.position(0);
    }

    @Override
    public void destroy() {
        if (this._os != null) {
            this._os = null;
        }
    }
}

