/*
 * Decompiled with CFR 0.152.
 */
package ome.parameters;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import ome.conditions.ApiUsageException;

public class QueryParameter
implements Serializable {
    public final Class type;
    public final String name;
    public final Object value;
    private static final long serialVersionUID = 112229651549133492L;

    public QueryParameter(String name, Class type, Object value) {
        if (name == null) {
            throw new ApiUsageException("Expecting a value for name.");
        }
        if (type == null) {
            throw new ApiUsageException("Expecting a value for type.");
        }
        if (value != null && !type.isAssignableFrom(value.getClass())) {
            StringBuffer sb = new StringBuffer();
            sb.append("Value object should be of type: ");
            sb.append(type.getName());
            sb.append(" and not: ");
            sb.append(value.getClass().getName());
            throw new ApiUsageException(sb.toString());
        }
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("QP{");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type.getName());
        sb.append(",value=");
        sb.append(this.value);
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryParameter)) {
            return false;
        }
        QueryParameter qp = (QueryParameter)obj;
        if (this == qp) {
            return true;
        }
        if (!this.name.equals(qp.name)) {
            return false;
        }
        if (!this.type.equals(qp.type)) {
            return false;
        }
        return this.value == null ? qp.value == null : this.value.equals(qp.value);
    }

    public int hashCode() {
        int result = 11;
        result = 17 * result + this.name.hashCode();
        result = 19 * result + this.type.hashCode();
        result = 23 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.type == null) {
            throw new InvalidObjectException("QueryParameter type cannot be null.");
        }
        if (this.value == null) {
            throw new InvalidObjectException("QueryParameter value cannot be null.");
        }
        if (!this.type.isAssignableFrom(this.value.getClass())) {
            throw new InvalidObjectException("QueryParameter value must be of type type.");
        }
    }
}

