/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredAnalyzer
extends Analyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredAnalyzer.class);
    private static AtomicReference<Class<? extends Analyzer>> configuredAnalyzerClass = new AtomicReference();
    private final Analyzer wrappedAnalyzer;

    public ConfiguredAnalyzer() {
        Class<? extends Analyzer> analyzerClass = configuredAnalyzerClass.get();
        if (analyzerClass == null) {
            throw new IllegalStateException("must configure with analyzer class before using default constructor");
        }
        this.wrappedAnalyzer = this.instantiateWrappedAnalyzer(analyzerClass);
    }

    public ConfiguredAnalyzer(Class<? extends Analyzer> analyzerClass) {
        if (analyzerClass == null) {
            throw new IllegalArgumentException("must give analyzer class or use default constructor");
        }
        this.wrappedAnalyzer = this.instantiateWrappedAnalyzer(analyzerClass);
        if (analyzerClass != configuredAnalyzerClass.getAndSet(analyzerClass)) {
            LOGGER.debug("set analyzer class to {}", analyzerClass);
        }
    }

    private Analyzer instantiateWrappedAnalyzer(Class<? extends Analyzer> analyzerClass) {
        try {
            return analyzerClass.newInstance();
        }
        catch (ReflectiveOperationException roe) {
            throw new IllegalArgumentException("cannot instantiate analyzer class " + analyzerClass);
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return this.wrappedAnalyzer.tokenStream(fieldName, reader);
    }

    public void close() {
        this.wrappedAnalyzer.close();
    }
}

