/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import ome.api.ServiceInterface;
import ome.conditions.InternalException;
import ome.logic.HardWiredInterceptor;
import ome.services.blitz.fire.AopContextInitializer;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.IceMethodInvoker;
import ome.services.throttling.Task;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import omero.ServerError;
import omero.api.AMD_StatefulServiceInterface_activate;
import omero.api.AMD_StatefulServiceInterface_getCurrentEventContext;
import omero.api.AMD_StatefulServiceInterface_passivate;
import omero.util.IceMapper;
import omero.util.ServantHolder;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractAmdServant
implements ApplicationContextAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final BlitzExecutor be;
    protected ServiceInterface service;
    protected IceMethodInvoker invoker;
    protected OmeroContext ctx;
    protected ServantHolder holder;

    public AbstractAmdServant(ServiceInterface service, BlitzExecutor be) {
        this.be = be;
        this.service = service;
    }

    public void setHolder(ServantHolder holder) {
        this.holder = holder;
    }

    public final void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = (OmeroContext)ctx;
        if (this.service != null) {
            this.invoker = new IceMethodInvoker(this.service, this.ctx);
        }
        try {
            this.onSetOmeroContext(this.ctx);
        }
        catch (Exception e) {
            throw new FatalBeanException("Error on setOmeroContext", (Throwable)e);
        }
    }

    public void onSetOmeroContext(OmeroContext context) throws Exception {
    }

    public final void applyHardWiredInterceptors(List<HardWiredInterceptor> cptors, AopContextInitializer initializer) {
        if (this.service != null) {
            ProxyFactory wiredService = new ProxyFactory();
            wiredService.setInterfaces((Class[])this.service.getClass().getInterfaces());
            wiredService.setTarget((Object)this.service);
            ArrayList<HardWiredInterceptor> reversed = new ArrayList<HardWiredInterceptor>(cptors);
            Collections.reverse(reversed);
            for (HardWiredInterceptor hwi : reversed) {
                wiredService.addAdvice(0, (Advice)hwi);
            }
            wiredService.addAdvice(0, (Advice)initializer);
            this.service = (ServiceInterface)wiredService.getProxy();
        }
    }

    public final void callInvokerOnRawArgs(Object __cb, Current __current, Object ... args) {
        if (this.service == null) {
            throw new InternalException("Null service; cannot use callInvoker()");
        }
        this.be.callInvokerOnRawArgs(this.service, this.invoker, __cb, __current, args);
    }

    public final void callInvokerOnMappedArgs(IceMapper mapper, Object __cb, Current __current, Object ... args) {
        if (this.service == null) {
            throw new InternalException("Null service; cannot use callInvoker()");
        }
        this.be.callInvokerWithMappedArgs(this.service, this.invoker, mapper, __cb, __current, args);
    }

    public final void runnableCall(Current __current, Task r) {
        this.be.runnableCall(__current, r);
    }

    public final <R> void safeRunnableCall(Current __current, Object cb, boolean isVoid, Callable<R> callable) {
        this.be.safeRunnableCall(__current, cb, isVoid, callable);
    }

    public final void executorWorkCall(Executor.Work work) {
        throw new UnsupportedOperationException();
    }

    public final void activate_async(AMD_StatefulServiceInterface_activate __cb, Current __current) {
    }

    public final void passivate_async(AMD_StatefulServiceInterface_passivate __cb, Current __current) {
    }

    public final void getCurrentEventContext_async(AMD_StatefulServiceInterface_getCurrentEventContext __cb, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, new Object[0]);
    }
}

