/*
 * Decompiled with CFR 0.152.
 */
package ome.services.formats;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.api.RawPixelsStore;
import ome.formats.model.UnitsFactory;
import omero.api.RawPixelsStorePrx;
import omero.model.Image;
import omero.model.Pixels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroReader
extends FormatReader {
    private static final Logger log = LoggerFactory.getLogger(OmeroReader.class);
    private final RawPixelsStore raw;
    private final RawPixelsStorePrx prx;
    private final Pixels pix;
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    public final int sizeT;
    public final int sizeC;
    public final int planes;

    private OmeroReader(Pixels pix, RawPixelsStore raw, RawPixelsStorePrx prx) {
        super("OMERO", "*");
        this.pix = pix;
        this.prx = prx;
        this.raw = raw;
        this.sizeX = pix.getSizeX().getValue();
        this.sizeY = pix.getSizeY().getValue();
        this.sizeZ = pix.getSizeZ().getValue();
        this.sizeC = pix.getSizeC().getValue();
        this.sizeT = pix.getSizeT().getValue();
        this.planes = this.sizeZ * this.sizeC * this.sizeT;
        if (this.raw == null && this.prx == null || this.raw != null && this.prx != null) {
            throw new RuntimeException("Improperly configured");
        }
    }

    public OmeroReader(RawPixelsStore raw, Pixels pix) {
        this(pix, raw, null);
    }

    public OmeroReader(RawPixelsStorePrx prx, Pixels pix) {
        this(pix, null, prx);
    }

    public boolean isThisType(String name, boolean open) {
        StringTokenizer st = new StringTokenizer(name, "\n");
        return st.countTokens() == 5;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return true;
    }

    public byte[] openBytes(int no, byte[] buf, int x1, int y1, int w1, int h1) throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        FormatTools.checkPlaneNumber((IFormatReader)this, (int)no);
        FormatTools.checkBufferSize((IFormatReader)this, (int)buf.length);
        int[] zct = FormatTools.getZCTCoords((IFormatReader)this, (int)no);
        byte[] plane = null;
        if (this.raw != null) {
            plane = this.raw.getPlane(zct[0], zct[1], zct[2]);
        } else if (this.prx != null) {
            try {
                plane = this.prx.getPlane(zct[0], zct[1], zct[2]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Improperly configured");
        }
        int len = this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel((int)this.getPixelType());
        System.arraycopy(plane, 0, buf, 0, len);
        return buf;
    }

    public void close() throws IOException {
        super.close();
    }

    protected void initFile(String id) throws FormatException, IOException {
        log.debug("OmeroReader.initFile(" + id + ")");
        super.initFile(id);
        String ptype = this.pix.getPixelsType().getValue().getValue();
        String dorder = this.pix.getDimensionOrder().getValue().getValue();
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.sizeX = this.sizeX;
        ms0.sizeY = this.sizeY;
        ms0.sizeZ = this.sizeZ;
        ms0.sizeC = this.sizeC;
        ms0.sizeT = this.sizeT;
        ms0.rgb = false;
        ms0.littleEndian = false;
        ms0.dimensionOrder = dorder;
        ms0.imageCount = this.planes;
        ms0.pixelType = FormatTools.pixelTypeFromString((String)ptype);
        double px = this.pix.getSizeX().getValue();
        double py = this.pix.getSizeY().getValue();
        double pz = this.pix.getSizeZ().getValue();
        Image image = this.pix.getImage();
        String name = image.getName().getValue();
        String description = null;
        if (image.getDescription() != null) {
            description = image.getDescription().getValue();
        }
        MetadataStore store = this.getMetadataStore();
        store.setImageName(name, 0);
        store.setImageDescription(description, 0);
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        store.setPixelsPhysicalSizeX(UnitsFactory.makeLengthXML(px, ome.xml.model.Pixels.getPhysicalSizeXUnitXsdDefault()), 0);
        store.setPixelsPhysicalSizeY(UnitsFactory.makeLengthXML(py, ome.xml.model.Pixels.getPhysicalSizeYUnitXsdDefault()), 0);
        store.setPixelsPhysicalSizeZ(UnitsFactory.makeLengthXML(pz, ome.xml.model.Pixels.getPhysicalSizeZUnitXsdDefault()), 0);
    }
}

