/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import ome.conditions.OverUsageException;
import ome.services.messages.stats.AbstractStatsMessage;
import ome.services.messages.stats.ObjectsReadStatsMessage;
import ome.services.messages.stats.ObjectsWrittenStatsMessage;
import ome.services.throttling.ThrottlingStrategy;
import ome.system.OmeroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractThrottlingStrategy
implements ApplicationContextAware,
ThrottlingStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected OmeroContext ctx;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = (OmeroContext)applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ObjectsReadStatsMessage) {
            ObjectsReadStatsMessage read = (ObjectsReadStatsMessage)event;
            this.handle(read, read.getObjectsRead() + " objects read.");
        } else if (event instanceof ObjectsWrittenStatsMessage) {
            ObjectsWrittenStatsMessage written = (ObjectsWrittenStatsMessage)event;
            this.handle(written, written.getObjectsWritten() + " objects written.");
        }
    }

    private void handle(AbstractStatsMessage event, String msg) {
        if (event.isHard()) {
            throw new OverUsageException(String.format("Aborting execution: Reason = \"%s\"", msg));
        }
        this.log.info("Blocking for 5 seconds: " + msg);
        while (System.currentTimeMillis() < event.getTimestamp() + 5000L) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

