/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.sql.Timestamp;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RTime;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Length;
import omero.model.PlateAcquisition;
import omero.model.Well;
import omero.model.WellSample;
import omero.rtypes;
import omero.util.IceMapper;

public class WellSampleI
extends WellSample
implements ModelBased {
    public static final String POSX = "ome.model.screen.WellSample_posX";
    public static final String POSY = "ome.model.screen.WellSample_posY";
    public static final String TIMEPOINT = "ome.model.screen.WellSample_timepoint";
    public static final String PLATEACQUISITION = "ome.model.screen.WellSample_plateAcquisition";
    public static final String WELL = "ome.model.screen.WellSample_well";
    public static final String IMAGE = "ome.model.screen.WellSample_image";
    public static final String DETAILS = "ome.model.screen.WellSample_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public WellSampleI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public WellSampleI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public WellSampleI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadPosX();
        this.unloadPosY();
        this.unloadTimepoint();
        this.unloadPlateAcquisition();
        this.unloadWell();
        this.unloadImage();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        WellSampleI copy = new WellSampleI();
        copy.id = this.id;
        copy.version = this.version;
        copy.posX = this.posX == null ? null : this.posX.copy();
        copy.posY = this.posY == null ? null : this.posY.copy();
        copy.timepoint = this.timepoint;
        copy.plateAcquisition = this.plateAcquisition == null ? null : (PlateAcquisition)this.plateAcquisition.proxy();
        copy.well = this.well == null ? null : (Well)this.well.proxy();
        copy.image = this.image == null ? null : (Image)this.image.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new WellSampleI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadPosX() {
        this.posX = null;
    }

    @Override
    public Length getPosX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.posX;
    }

    @Override
    public void setPosX(Length posX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.posX = posX;
    }

    private void copyPosX(ome.model.screen.WellSample source, IceMapper mapper) {
        this.posX = (Length)mapper.findTarget(source.getPosX());
    }

    private void fillPosX(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(POSX, (Object)mapper.reverse((ModelBased)this.getPosX()));
    }

    public void unloadPosY() {
        this.posY = null;
    }

    @Override
    public Length getPosY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.posY;
    }

    @Override
    public void setPosY(Length posY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.posY = posY;
    }

    private void copyPosY(ome.model.screen.WellSample source, IceMapper mapper) {
        this.posY = (Length)mapper.findTarget(source.getPosY());
    }

    private void fillPosY(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(POSY, (Object)mapper.reverse((ModelBased)this.getPosY()));
    }

    public void unloadTimepoint() {
        this.timepoint = null;
    }

    @Override
    public RTime getTimepoint(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.timepoint;
    }

    @Override
    public void setTimepoint(RTime timepoint, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.timepoint = timepoint;
    }

    private void copyTimepoint(ome.model.screen.WellSample source, IceMapper mapper) {
        this.timepoint = source.getTimepoint() == null ? null : rtypes.rtime(source.getTimepoint().getTime());
    }

    private void fillTimepoint(ome.model.screen.WellSample target, IceMapper mapper) {
        try {
            target.setTimepoint((Timestamp)mapper.fromRType(this.getTimepoint()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPlateAcquisition() {
        this.plateAcquisition = null;
    }

    @Override
    public PlateAcquisition getPlateAcquisition(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.plateAcquisition;
    }

    @Override
    public void setPlateAcquisition(PlateAcquisition plateAcquisition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.plateAcquisition = plateAcquisition;
    }

    private void copyPlateAcquisition(ome.model.screen.WellSample source, IceMapper mapper) {
        this.plateAcquisition = (PlateAcquisition)mapper.findTarget(source.getPlateAcquisition());
    }

    private void fillPlateAcquisition(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(PLATEACQUISITION, (Object)mapper.reverse((ModelBased)this.getPlateAcquisition()));
    }

    public void unloadWell() {
        this.well = null;
    }

    @Override
    public Well getWell(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.well;
    }

    @Override
    public void setWell(Well well, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.well = well;
    }

    private void copyWell(ome.model.screen.WellSample source, IceMapper mapper) {
        this.well = (Well)mapper.findTarget(source.getWell());
    }

    private void fillWell(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(WELL, (Object)mapper.reverse((ModelBased)this.getWell()));
    }

    public void unloadImage() {
        this.image = null;
    }

    @Override
    public Image getImage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.image;
    }

    @Override
    public void setImage(Image image, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.image = image;
    }

    private void copyImage(ome.model.screen.WellSample source, IceMapper mapper) {
        this.image = (Image)mapper.findTarget(source.getImage());
    }

    private void fillImage(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(IMAGE, (Object)mapper.reverse((ModelBased)this.getImage()));
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.screen.WellSample) {
            ome.model.screen.WellSample source = (ome.model.screen.WellSample)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyPosX(source, mapper);
                this.copyPosY(source, mapper);
                this.copyTimepoint(source, mapper);
                this.copyPlateAcquisition(source, mapper);
                this.copyWell(source, mapper);
                this.copyImage(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("WellSample cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.screen.WellSample target = new ome.model.screen.WellSample();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillPosX(target, mapper);
            this.fillPosY(target, mapper);
            this.fillTimepoint(target, mapper);
            this.fillPlateAcquisition(target, mapper);
            this.fillWell(target, mapper);
            this.fillImage(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<WellSampleI> cast(List list) {
        return list;
    }
}

