/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.io.IOException;
import ome.model.core.Pixels;
import ome.model.enums.RenderingModel;
import omeis.providers.re.GreyScaleStrategy;
import omeis.providers.re.HSBStrategy;
import omeis.providers.re.RGBAIntBuffer;
import omeis.providers.re.RGBBuffer;
import omeis.providers.re.RGBIntBuffer;
import omeis.providers.re.Renderer;
import omeis.providers.re.RenderingStats;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.RegionDef;
import omeis.providers.re.quantum.QuantizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RenderingStrategy {
    private static Logger log = LoggerFactory.getLogger(RenderingStrategy.class);
    protected Renderer renderer;
    protected int sizeX1;
    protected int sizeX2;
    protected int maxTasks = Runtime.getRuntime().availableProcessors();

    private void isRegionValid(RegionDef region, Pixels pixels) {
        if (region == null) {
            return;
        }
        int x = region.getX();
        if (x < 0) {
            throw new RuntimeException("Invalid Region, X-coordinate of the top-left corner cannot be negative:" + x);
        }
        int y = region.getY();
        if (y < 0) {
            throw new RuntimeException("Invalid Region, y-coordinate of the top-left corner cannot be negative:" + y);
        }
        int w = region.getWidth();
        if (w <= 0) {
            throw new RuntimeException("Invalid Region, the width must be positive:" + w);
        }
        int h = region.getHeight();
        if (h <= 0) {
            throw new RuntimeException("Invalid Region, the height must be positive:" + h);
        }
        int sizeX = pixels.getSizeX();
        int sizeY = pixels.getSizeY();
        if (x + w > sizeX) {
            region.setWidth(sizeX - x);
        }
        if (y + h > sizeY) {
            region.setHeight(sizeY - y);
        }
    }

    protected void initAxesSize(PlaneDef pd, Pixels pixels) {
        RegionDef region = pd.getRegion();
        this.isRegionValid(region, pixels);
        int stride = pd.getStride();
        if (stride < 0) {
            stride = 0;
        }
        ++stride;
        try {
            switch (pd.getSlice()) {
                case 0: {
                    if (region != null) {
                        this.sizeX1 = region.getWidth();
                        this.sizeX2 = region.getHeight();
                    } else {
                        this.sizeX1 = pixels.getSizeX();
                        this.sizeX2 = pixels.getSizeY();
                    }
                    this.sizeX1 /= stride;
                    this.sizeX2 /= stride;
                    break;
                }
                case 2: {
                    this.sizeX1 = pixels.getSizeX();
                    this.sizeX2 = pixels.getSizeZ();
                    break;
                }
                case 1: {
                    this.sizeX1 = pixels.getSizeZ();
                    this.sizeX2 = pixels.getSizeY();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid slice ID: " + pd.getSlice() + ".", nfe);
        }
    }

    protected RenderingStrategy() {
    }

    protected RGBBuffer getRgbBuffer() {
        RenderingStats stats = this.renderer.getStats();
        stats.startMalloc();
        RGBBuffer buf = new RGBBuffer(this.sizeX1, this.sizeX2);
        stats.endMalloc();
        return buf;
    }

    protected RGBIntBuffer getIntBuffer() {
        RenderingStats stats = this.renderer.getStats();
        stats.startMalloc();
        RGBIntBuffer buf = new RGBIntBuffer(this.sizeX1, this.sizeX2);
        stats.endMalloc();
        return buf;
    }

    protected RGBAIntBuffer getRGBAIntBuffer() {
        RenderingStats stats = this.renderer.getStats();
        stats.startMalloc();
        RGBAIntBuffer buf = new RGBAIntBuffer(this.sizeX1, this.sizeX2);
        stats.endMalloc();
        return buf;
    }

    static RenderingStrategy makeNew(RenderingModel model) {
        String value = model.getValue();
        if (value.equals("greyscale")) {
            return new GreyScaleStrategy();
        }
        if (value.equals("rgb")) {
            return new HSBStrategy();
        }
        if (value.equals("rgb")) {
            return new HSBStrategy();
        }
        log.warn("WARNING: Unknown model '" + value + "' using greyscale.");
        return new GreyScaleStrategy();
    }

    abstract RGBBuffer render(Renderer var1, PlaneDef var2) throws IOException, QuantizationException;

    abstract RGBIntBuffer renderAsPackedInt(Renderer var1, PlaneDef var2) throws IOException, QuantizationException;

    abstract RGBAIntBuffer renderAsPackedIntAsRGBA(Renderer var1, PlaneDef var2) throws IOException, QuantizationException;

    abstract int getImageSize(PlaneDef var1, Pixels var2);

    abstract String getPlaneDimsAsString(PlaneDef var1, Pixels var2);
}

