/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class SBIGReader
extends FormatReader {
    private static final long HEADER_SIZE = 2048L;
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss";
    private boolean compressed;

    public SBIGReader() {
        super("SBIG", "");
        this.domains = new String[]{"Astronomy"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2048;
        int checkLen = 32;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)2048, (boolean)false)) {
            return false;
        }
        return stream.readString(32).indexOf("ST-7 Compressed Image") >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(2048L);
        int width = this.getSizeX() * 2;
        if (this.compressed) {
            byte[] b = new byte[FormatTools.getPlaneSize((IFormatReader)this)];
            for (int row = 0; row < this.getSizeY(); ++row) {
                short rowLen = this.in.readShort();
                if (rowLen == width) {
                    this.in.read(b, row * width, (int)rowLen);
                    continue;
                }
                int bufferPointer = row * width;
                this.in.read(b, bufferPointer, 2);
                while (bufferPointer - row * width < width - 2) {
                    short prevPixel = DataTools.bytesToShort(b, bufferPointer, this.isLittleEndian());
                    bufferPointer += 2;
                    byte check = this.in.readByte();
                    if (check == -128) {
                        this.in.read(b, bufferPointer, 2);
                        continue;
                    }
                    prevPixel = (short)(prevPixel + check);
                    DataTools.unpackBytes(prevPixel, b, bufferPointer, 2, this.isLittleEndian());
                }
            }
            try (RandomAccessInputStream stream = new RandomAccessInputStream(b);){
                this.readPlane(stream, x, y, w, h, buf);
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compressed = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        Double sizeX = null;
        Double sizeY = null;
        String date = null;
        String description = null;
        for (String line : lines = DataTools.readFile(this.currentId).split("\n")) {
            int eq = (line = line.trim()).indexOf(61);
            if (eq != -1) {
                Double size;
                String key = line.substring(0, eq).trim();
                String value = line.substring(eq + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("Width")) {
                    m.sizeX = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("Height")) {
                    m.sizeY = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("Note")) {
                    description = value;
                    continue;
                }
                if (key.equals("X_pixel_size")) {
                    size = DataTools.parseDouble(value);
                    if (size == null) continue;
                    sizeX = size * 1000.0;
                    continue;
                }
                if (key.equals("Y_pixel_size")) {
                    size = DataTools.parseDouble(value);
                    if (size == null) continue;
                    sizeY = size * 1000.0;
                    continue;
                }
                if (key.equals("Date")) {
                    date = value;
                    continue;
                }
                if (!key.equals("Time")) continue;
                date = date + " " + value;
                continue;
            }
            if (line.indexOf("Compressed") != -1) {
                this.compressed = true;
                continue;
            }
            if (line.equals("End")) break;
        }
        m.pixelType = 3;
        m.littleEndian = true;
        m.rgb = false;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (date != null && (date = DateTools.formatDate(date, DATE_FORMAT)) != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length x = FormatTools.getPhysicalSizeX(sizeX);
            Length y = FormatTools.getPhysicalSizeY(sizeY);
            if (x != null) {
                store.setPixelsPhysicalSizeX(x, 0);
            }
            if (y != null) {
                store.setPixelsPhysicalSizeY(y, 0);
            }
            store.setImageDescription(description, 0);
        }
    }
}

