/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.filter;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

public class WildcardMatchOnPath
implements MFileFilter {
    private static final boolean debug = false;
    private String wildcardString;
    protected Pattern pattern;

    public WildcardMatchOnPath(String wildcardString) {
        this.wildcardString = wildcardString;
        String regExp = wildcardString.replaceAll("\\.", "\\\\.");
        regExp = regExp.replaceAll("\\*", ".*");
        regExp = regExp.replaceAll("\\?", ".?");
        this.pattern = Pattern.compile((String)regExp);
    }

    WildcardMatchOnPath(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean accept(MFile file) {
        String p = file.getPath();
        Matcher matcher = this.pattern.matcher((CharSequence)p);
        return matcher.matches();
    }

    public String toString() {
        return "WildcardMatchOnPath{wildcard=" + this.wildcardString + " regexp=" + this.pattern + '}';
    }
}

