/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.util.concurrent.atomic.AtomicBoolean;
import ome.security.auth.PasswordChangeException;
import ome.security.auth.PasswordProvider;
import org.springframework.util.Assert;

public class PasswordProviders
implements PasswordProvider {
    private final PasswordProvider[] providers;
    private AtomicBoolean ignoreCaseLookup;

    public PasswordProviders(PasswordProvider ... providers) {
        this(new AtomicBoolean(false), providers);
    }

    public PasswordProviders(AtomicBoolean ignoreCaseLookup, PasswordProvider ... providers) {
        Assert.notNull((Object)providers);
        int l = providers.length;
        this.providers = new PasswordProvider[l];
        System.arraycopy(providers, 0, this.providers, 0, l);
        this.ignoreCaseLookup = ignoreCaseLookup;
    }

    @Override
    public boolean hasPassword(String user) {
        user = this.ignoreCaseLookup.get() ? user.toLowerCase() : user;
        for (PasswordProvider provider : this.providers) {
            boolean hasPassword = provider.hasPassword(user);
            if (!hasPassword) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean checkPassword(String user, String password, boolean readOnly) {
        user = this.ignoreCaseLookup.get() ? user.toLowerCase() : user;
        for (PasswordProvider provider : this.providers) {
            Boolean rv = provider.checkPassword(user, password, readOnly);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    @Override
    public void changePassword(String user, String password) throws PasswordChangeException {
        user = this.ignoreCaseLookup.get() ? user.toLowerCase() : user;
        for (PasswordProvider provider : this.providers) {
            boolean hasPassword = provider.hasPassword(user);
            if (!hasPassword) continue;
            provider.changePassword(user, password);
            return;
        }
        throw new PasswordChangeException("No provider found: " + user);
    }

    public void changeDistinguisedName(String user, String dn) throws PasswordChangeException {
        for (PasswordProvider provider : this.providers) {
            boolean hasPassword = provider.hasPassword(user);
            if (!hasPassword) continue;
            provider.changePassword(user, dn);
            return;
        }
        throw new PasswordChangeException("No provider found:" + user);
    }
}

